/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.openoffice.style;

import java.util.Comparator;
import java.util.Optional;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.openoffice.style.ComparableCitedKey;

public class CompareCitedKey
implements Comparator<ComparableCitedKey> {
    Comparator<BibEntry> entryComparator;
    boolean unresolvedComesFirst;

    CompareCitedKey(Comparator<BibEntry> entryComparator, boolean unresolvedComesFirst) {
        this.entryComparator = entryComparator;
        this.unresolvedComesFirst = unresolvedComesFirst;
    }

    @Override
    public int compare(ComparableCitedKey a, ComparableCitedKey b) {
        int mul;
        Optional<BibEntry> aBibEntry = a.getBibEntry();
        Optional<BibEntry> bBibEntry = b.getBibEntry();
        int n = mul = this.unresolvedComesFirst ? 1 : -1;
        if (aBibEntry.isEmpty() && bBibEntry.isEmpty()) {
            return a.getCitationKey().compareTo(b.getCitationKey());
        }
        if (aBibEntry.isEmpty()) {
            return -mul;
        }
        if (bBibEntry.isEmpty()) {
            return mul;
        }
        return this.entryComparator.compare(aBibEntry.get(), bBibEntry.get());
    }
}

