/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.search.rules;

import com.airhacks.afterburner.injection.Injector;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import org.jabref.architecture.AllowedToUseLogic;
import org.jabref.gui.StateManager;
import org.jabref.logic.pdf.search.PdfIndexer;
import org.jabref.logic.pdf.search.PdfIndexerManager;
import org.jabref.logic.pdf.search.PdfSearcher;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.pdf.search.PdfSearchResults;
import org.jabref.model.pdf.search.SearchResult;
import org.jabref.model.search.rules.SearchRule;
import org.jabref.model.search.rules.SearchRules;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@AllowedToUseLogic(value="Because access to the lucene index is needed")
public abstract class FullTextSearchRule
implements SearchRule {
    private static final Logger LOGGER = LoggerFactory.getLogger(FullTextSearchRule.class);
    protected final EnumSet<SearchRules.SearchFlags> searchFlags;
    protected String lastQuery;
    protected List<SearchResult> lastPdfSearchResults;

    public FullTextSearchRule(EnumSet<SearchRules.SearchFlags> searchFlags) {
        this.searchFlags = searchFlags;
        this.lastQuery = "";
        this.lastPdfSearchResults = Collections.emptyList();
    }

    public EnumSet<SearchRules.SearchFlags> getSearchFlags() {
        return this.searchFlags;
    }

    @Override
    public PdfSearchResults getFulltextResults(String query, BibEntry bibEntry) {
        if (!this.searchFlags.contains((Object)SearchRules.SearchFlags.FULLTEXT)) {
            LOGGER.debug("Fulltext search results called even though fulltext search flag is missing.");
            return new PdfSearchResults();
        }
        if (query.equals(this.lastQuery)) {
            LOGGER.trace("Reusing fulltext search results (query={}, lastQuery={}).", (Object)query, (Object)this.lastQuery);
        } else {
            PdfIndexer pdfIndexer;
            LOGGER.trace("Performing full query {}.", (Object)query);
            try {
                StateManager stateManager = (StateManager)Injector.instantiateModelOrService(StateManager.class);
                PreferencesService preferencesService = (PreferencesService)Injector.instantiateModelOrService(PreferencesService.class);
                pdfIndexer = PdfIndexerManager.getIndexer(stateManager.getActiveDatabase().get(), preferencesService.getFilePreferences());
            }
            catch (IOException e) {
                LOGGER.error("Could not access full text index.", (Throwable)e);
                return new PdfSearchResults();
            }
            this.lastQuery = query;
            this.lastPdfSearchResults = Collections.emptyList();
            try {
                PdfSearcher searcher = PdfSearcher.of(pdfIndexer);
                PdfSearchResults results = searcher.search(query, 5);
                this.lastPdfSearchResults = results.getSortedByScore();
            }
            catch (IOException e) {
                LOGGER.error("Could not retrieve search results.", (Throwable)e);
                return new PdfSearchResults();
            }
        }
        return new PdfSearchResults(this.lastPdfSearchResults.stream().filter(searchResult -> searchResult.isResultFor(bibEntry)).toList());
    }
}

