/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.search.rules;

import java.util.ArrayList;
import java.util.List;

public class SentenceAnalyzer {
    public static final char ESCAPE_CHAR = '\\';
    public static final char QUOTE_CHAR = '\"';
    private final String query;

    public SentenceAnalyzer(String query) {
        this.query = query;
    }

    public List<String> getWords() {
        ArrayList<String> result = new ArrayList<String>();
        StringBuilder stringBuilder = new StringBuilder();
        boolean escaped = false;
        boolean quoted = false;
        for (char c : this.query.toCharArray()) {
            if (!escaped && c == '\\') {
                escaped = true;
                continue;
            }
            if (!escaped && !quoted && Character.isWhitespace(c)) {
                if (stringBuilder.length() > 0) {
                    result.add(stringBuilder.toString());
                    stringBuilder = new StringBuilder();
                }
            } else if (c == '\"') {
                if (stringBuilder.length() > 0) {
                    result.add(stringBuilder.toString());
                    stringBuilder = new StringBuilder();
                }
                quoted = !quoted;
            } else {
                stringBuilder.append(c);
            }
            escaped = false;
        }
        if (stringBuilder.length() > 0) {
            result.add(stringBuilder.toString());
        }
        return result;
    }
}

