/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.model.texparser;

import com.google.common.collect.Multimap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.texparser.Citation;
import org.jabref.model.texparser.LatexParserResults;

public class LatexBibEntriesResolverResult {
    private final LatexParserResults latexParserResults;
    private final Set<BibEntry> newEntries;

    public LatexBibEntriesResolverResult(LatexParserResults latexParserResults) {
        this.latexParserResults = latexParserResults;
        this.newEntries = new HashSet<BibEntry>();
    }

    public Set<BibEntry> getNewEntries() {
        return this.newEntries;
    }

    public void addEntry(BibEntry entry) {
        this.newEntries.add(entry);
    }

    public Multimap<String, Citation> getCitations() {
        return this.latexParserResults.getCitations();
    }

    public String toString() {
        return "TexBibEntriesResolverResult{latexParserResults=%s, newEntries=%s}".formatted(this.latexParserResults, this.newEntries);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        LatexBibEntriesResolverResult that = (LatexBibEntriesResolverResult)obj;
        return Objects.equals(this.latexParserResults, that.latexParserResults) && Objects.equals(this.newEntries, that.newEntries);
    }

    public int hashCode() {
        return Objects.hash(this.latexParserResults, this.newEntries);
    }
}

