/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.preferences;

import java.nio.file.Path;
import java.util.List;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.jabref.logic.layout.TextBasedPreviewLayout;
import org.jabref.logic.preview.PreviewLayout;

public class PreviewPreferences {
    private final ObservableList<PreviewLayout> layoutCycle;
    private final IntegerProperty layoutCyclePosition;
    private final ObjectProperty<TextBasedPreviewLayout> customPreviewLayout;
    private final StringProperty defaultCustomPreviewLayout;
    private final BooleanProperty showPreviewAsExtraTab;
    private final BooleanProperty showPreviewEntryTableTooltip;
    private final ObservableList<Path> bstPreviewLayoutPaths;

    public PreviewPreferences(List<PreviewLayout> layoutCycle, int layoutCyclePosition, TextBasedPreviewLayout customPreviewLayout, String defaultCustomPreviewLayout, boolean showPreviewAsExtraTab, boolean showPreviewEntryTableTooltip, List<Path> bstPreviewLayoutPaths) {
        this.layoutCycle = FXCollections.observableArrayList(layoutCycle);
        this.layoutCyclePosition = new SimpleIntegerProperty(layoutCyclePosition);
        this.customPreviewLayout = new SimpleObjectProperty((Object)customPreviewLayout);
        this.defaultCustomPreviewLayout = new SimpleStringProperty(defaultCustomPreviewLayout);
        this.showPreviewAsExtraTab = new SimpleBooleanProperty(showPreviewAsExtraTab);
        this.showPreviewEntryTableTooltip = new SimpleBooleanProperty(showPreviewEntryTableTooltip);
        this.bstPreviewLayoutPaths = FXCollections.observableList(bstPreviewLayoutPaths);
    }

    public ObservableList<PreviewLayout> getLayoutCycle() {
        return this.layoutCycle;
    }

    public int getLayoutCyclePosition() {
        return this.layoutCyclePosition.getValue();
    }

    public IntegerProperty layoutCyclePositionProperty() {
        return this.layoutCyclePosition;
    }

    public void setLayoutCyclePosition(int position) {
        if (this.layoutCycle.isEmpty()) {
            this.layoutCyclePosition.setValue((Number)0);
        } else {
            int previewCyclePosition;
            for (previewCyclePosition = position; previewCyclePosition < 0; previewCyclePosition += this.layoutCycle.size()) {
            }
            this.layoutCyclePosition.setValue((Number)(previewCyclePosition % this.layoutCycle.size()));
        }
    }

    public PreviewLayout getSelectedPreviewLayout() {
        if (this.layoutCycle.size() <= 0 || this.layoutCyclePosition.getValue() < 0 || this.layoutCyclePosition.getValue() >= this.layoutCycle.size()) {
            return this.getCustomPreviewLayout();
        }
        return (PreviewLayout)this.layoutCycle.get(this.layoutCyclePosition.getValue().intValue());
    }

    public TextBasedPreviewLayout getCustomPreviewLayout() {
        return (TextBasedPreviewLayout)this.customPreviewLayout.getValue();
    }

    public ObjectProperty<TextBasedPreviewLayout> customPreviewLayoutProperty() {
        return this.customPreviewLayout;
    }

    public void setCustomPreviewLayout(TextBasedPreviewLayout layout) {
        this.customPreviewLayout.set((Object)layout);
    }

    public String getDefaultCustomPreviewLayout() {
        return this.defaultCustomPreviewLayout.getValue();
    }

    public boolean shouldShowPreviewAsExtraTab() {
        return this.showPreviewAsExtraTab.getValue();
    }

    public void setShowPreviewAsExtraTab(boolean showPreviewAsExtraTab) {
        this.showPreviewAsExtraTab.set(showPreviewAsExtraTab);
    }

    public BooleanProperty showPreviewAsExtraTabProperty() {
        return this.showPreviewAsExtraTab;
    }

    public boolean shouldShowPreviewEntryTableTooltip() {
        return this.showPreviewEntryTableTooltip.getValue();
    }

    public void setShowPreviewEntryTableTooltip(boolean showPreviewEntryTableTooltip) {
        this.showPreviewEntryTableTooltip.set(showPreviewEntryTableTooltip);
    }

    public BooleanProperty showPreviewEntryTableTooltip() {
        return this.showPreviewEntryTableTooltip;
    }

    public ObservableList<Path> getBstPreviewLayoutPaths() {
        return this.bstPreviewLayoutPaths;
    }

    public void setBstPreviewLayoutPaths(List<Path> bstPreviewLayoutPaths) {
        this.bstPreviewLayoutPaths.setAll(bstPreviewLayoutPaths);
    }
}

