/*
 * Decompiled with CFR 0.152.
 */
package com.tobiasdiez.easybind.select;

import com.tobiasdiez.easybind.EasyBinding;
import com.tobiasdiez.easybind.select.NestedSelectionElement;
import com.tobiasdiez.easybind.select.NestedSelectionElementFactory;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.value.ObservableValue;

class SelectObjectBinding<T, U>
extends ObjectBinding<U>
implements EasyBinding<U> {
    private final ObservableValue<T> root;
    private final NestedSelectionElement<T, U> nestedSelection;
    private final InvalidationListener rootInvalidationListener;

    public SelectObjectBinding(ObservableValue<T> root, NestedSelectionElementFactory<T, U> nestedSelectionFactory) {
        this.root = root;
        this.nestedSelection = nestedSelectionFactory.create(() -> ((SelectObjectBinding)this).invalidate());
        this.rootInvalidationListener = obs -> {
            this.nestedSelection.disconnect();
            this.invalidate();
        };
        root.addListener(this.rootInvalidationListener);
    }

    protected U computeValue() {
        if (!this.nestedSelection.isConnected()) {
            Object rootVal = this.root.getValue();
            if (rootVal == null) {
                return null;
            }
            this.nestedSelection.connect(rootVal);
        }
        return this.nestedSelection.getValue();
    }

    public void dispose() {
        this.root.removeListener(this.rootInvalidationListener);
        this.nestedSelection.disconnect();
    }
}

