/*
 * Decompiled with CFR 0.152.
 */
package org.reactfx.util;

import java.util.Iterator;
import org.reactfx.util.AccuMap;
import org.reactfx.util.AccumulationFacility;
import org.reactfx.util.AccumulatorSize;
import org.reactfx.util.NotificationAccumulator;
import org.reactfx.util.Tuple2;

abstract class NotificationAccumulatorBase<O, V, A>
implements NotificationAccumulator<O, V, A>,
AccumulationFacility<V, A> {
    private AccuMap<O, V, A> accuMap = AccuMap.empty();

    NotificationAccumulatorBase() {
    }

    protected abstract AccumulatorSize size(O var1, A var2);

    protected abstract Runnable head(O var1, A var2);

    protected abstract A tail(O var1, A var2);

    @Override
    public AccumulationFacility<V, A> getAccumulationFacility() {
        return this;
    }

    @Override
    public boolean isEmpty() {
        return this.accuMap.isEmpty();
    }

    @Override
    public Runnable takeOne() {
        Tuple2<O, Object> t = this.accuMap.peek(this);
        switch (t.map(this::size)) {
            case ZERO: {
                this.accuMap = this.accuMap.dropPeeked();
                return () -> {};
            }
            case ONE: {
                this.accuMap = this.accuMap.dropPeeked();
                return t.map(this::head);
            }
            case MANY: {
                Runnable notification = t.map(this::head);
                Object newAccumulatedValue = t.map(this::tail);
                this.accuMap = this.accuMap.updatePeeked(newAccumulatedValue);
                return notification;
            }
        }
        throw new AssertionError((Object)"Unreachable code");
    }

    @Override
    public void addAll(Iterator<O> keys, V value) {
        this.accuMap = this.accuMap.addAll(keys, value, this);
    }

    @Override
    public void clear() {
        this.accuMap = AccuMap.empty();
    }
}

