/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx;

import com.dlsc.gemsfx.GlassPane;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.ObjectPropertyBase;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.PseudoClass;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.EnumConverter;
import javafx.css.converter.SizeConverter;
import javafx.geometry.Insets;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.layout.Pane;
import javafx.scene.layout.Region;

public class ResponsivePane
extends Pane {
    private static final Side DEFAULT_SIDE = Side.LEFT;
    private static final PseudoClass SHOWING_SMALL_PSEUDOCLASS = PseudoClass.getPseudoClass((String)"showing-small");
    private static final PseudoClass SHOWING_LARGE_PSEUDOCLASS = PseudoClass.getPseudoClass((String)"showing-large");
    private static final PseudoClass SHOWING_NONE_PSEUDOCLASS = PseudoClass.getPseudoClass((String)"showing-none");
    private static final PseudoClass FORCED_PSEUDOCLASS = PseudoClass.getPseudoClass((String)"forced");
    private static final PseudoClass COVERING_PSEUDOCLASS = PseudoClass.getPseudoClass((String)"covering");
    private static final PseudoClass LEFT_PSEUDOCLASS = PseudoClass.getPseudoClass((String)"left");
    private static final PseudoClass RIGHT_PSEUDOCLASS = PseudoClass.getPseudoClass((String)"right");
    private static final PseudoClass TOP_PSEUDOCLASS = PseudoClass.getPseudoClass((String)"top");
    private static final PseudoClass BOTTOM_PSEUDOCLASS = PseudoClass.getPseudoClass((String)"bottom");
    private final BooleanProperty glassPaneNeedHide = new SimpleBooleanProperty(true);
    private final GlassPane glassPane = new GlassPane();
    private ObjectProperty<Node> content;
    public ObjectProperty<Node> smallSidebar;
    public ObjectProperty<Node> largeSidebar;
    private BooleanProperty largeSidebarCoversSmall;
    private BooleanProperty forceLargeSidebarDisplay;
    private ObjectProperty<Side> side;
    private DoubleProperty gap;

    public ResponsivePane() {
        this.getStyleClass().add((Object)"responsive-pane");
        this.glassPane.hideProperty().bind((ObservableValue)this.glassPaneNeedHide);
        this.glassPane.setOnMouseClicked(event -> this.setForceLargeSidebarDisplay(false));
        this.getChildren().add((Object)this.glassPane);
        this.updatePseudoClasses(this.getSide());
    }

    public String getUserAgentStylesheet() {
        return Objects.requireNonNull(ResponsivePane.class.getResource("responsive-pane.css")).toExternalForm();
    }

    public final ObjectProperty<Node> contentProperty() {
        if (this.content == null) {
            this.content = new NodeProperty("content");
        }
        return this.content;
    }

    public final void setContent(Node value) {
        this.contentProperty().set((Object)value);
    }

    public final Node getContent() {
        return this.content == null ? null : (Node)this.content.get();
    }

    public final ObjectProperty<Node> smallSidebarProperty() {
        if (this.smallSidebar == null) {
            this.smallSidebar = new NodeProperty("smallSidebar");
        }
        return this.smallSidebar;
    }

    public final void setSmallSidebar(Node value) {
        this.smallSidebarProperty().set((Object)value);
    }

    public final Node getSmallSidebar() {
        return this.smallSidebar == null ? null : (Node)this.smallSidebar.get();
    }

    public final ObjectProperty<Node> largeSidebarProperty() {
        if (this.largeSidebar == null) {
            this.largeSidebar = new NodeProperty("largeSidebar");
        }
        return this.largeSidebar;
    }

    public final void setLargeSidebar(Node value) {
        this.largeSidebarProperty().set((Object)value);
    }

    public final Node getLargeSidebar() {
        return this.largeSidebar == null ? null : (Node)this.largeSidebar.get();
    }

    public final boolean isLargeSidebarCoversSmall() {
        return this.largeSidebarCoversSmall != null && this.largeSidebarCoversSmall.get();
    }

    public final BooleanProperty largeSidebarCoversSmallProperty() {
        if (this.largeSidebarCoversSmall == null) {
            this.largeSidebarCoversSmall = new SimpleBooleanProperty((Object)this, "largeSidebarCoversSmall", false){

                protected void invalidated() {
                    ResponsivePane.this.requestLayout();
                }
            };
        }
        return this.largeSidebarCoversSmall;
    }

    public final void setLargeSidebarCoversSmall(boolean largeSidebarCoversSmall) {
        this.largeSidebarCoversSmallProperty().set(largeSidebarCoversSmall);
    }

    public final boolean isForceLargeSidebarDisplay() {
        return this.forceLargeSidebarDisplay != null && this.forceLargeSidebarDisplay.get();
    }

    public final BooleanProperty forceLargeSidebarDisplayProperty() {
        if (this.forceLargeSidebarDisplay == null) {
            this.forceLargeSidebarDisplay = new SimpleBooleanProperty((Object)this, "forceLargeSidebarDisplay", false){

                protected void invalidated() {
                    ResponsivePane.this.requestLayout();
                }
            };
        }
        return this.forceLargeSidebarDisplay;
    }

    public final void setForceLargeSidebarDisplay(boolean forceLargeSidebarDisplay) {
        this.forceLargeSidebarDisplayProperty().set(forceLargeSidebarDisplay);
    }

    public final ObjectProperty<Side> sideProperty() {
        if (this.side == null) {
            this.side = new StyleableObjectProperty<Side>(DEFAULT_SIDE){

                protected void invalidated() {
                    ResponsivePane.this.requestLayout();
                    ResponsivePane.this.updatePseudoClasses((Side)this.get());
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "side";
                }

                public CssMetaData<? extends Styleable, Side> getCssMetaData() {
                    return StyleableProperties.SIDE;
                }
            };
        }
        return this.side;
    }

    private void updatePseudoClasses(Side currentSide) {
        this.pseudoClassStateChanged(LEFT_PSEUDOCLASS, currentSide == Side.LEFT);
        this.pseudoClassStateChanged(RIGHT_PSEUDOCLASS, currentSide == Side.RIGHT);
        this.pseudoClassStateChanged(TOP_PSEUDOCLASS, currentSide == Side.TOP);
        this.pseudoClassStateChanged(BOTTOM_PSEUDOCLASS, currentSide == Side.BOTTOM);
    }

    public Side getSide() {
        return this.side == null ? DEFAULT_SIDE : (Side)this.side.get();
    }

    public void setSide(Side side) {
        this.sideProperty().set((Object)side);
    }

    public final DoubleProperty gapProperty() {
        if (this.gap == null) {
            this.gap = new StyleableDoubleProperty(0.0){

                protected void invalidated() {
                    ResponsivePane.this.requestLayout();
                }

                public Object getBean() {
                    return this;
                }

                public String getName() {
                    return "gap";
                }

                public CssMetaData<? extends Styleable, Number> getCssMetaData() {
                    return StyleableProperties.GAP;
                }
            };
        }
        return this.gap;
    }

    public double getGap() {
        return this.gap == null ? 0.0 : this.gap.get();
    }

    public void setGap(double gap) {
        this.gapProperty().set(gap);
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return ResponsivePane.getClassCssMetaData();
    }

    protected void layoutChildren() {
        Insets insets = this.getInsets();
        double insideWidth = this.getWidth() - (insets.getLeft() + insets.getRight());
        double insideHeight = this.getHeight() - (insets.getTop() + insets.getBottom());
        Node contentNode = this.getContent();
        Node smallSidebarNode = this.getSmallSidebar();
        Node largeSidebarNode = this.getLargeSidebar();
        double gap = Math.max(0.0, this.getGap());
        Side side = this.getSide() == null ? DEFAULT_SIDE : this.getSide();
        boolean isSideBarInHorizontal = side == Side.LEFT || side == Side.RIGHT;
        double prefContentWidth = this.computeNodeWidth(contentNode, isSideBarInHorizontal);
        double prefContentHeight = this.computeNodeHeight(contentNode, isSideBarInHorizontal);
        double largeSidebarWidth = this.computeNodeWidth(largeSidebarNode, isSideBarInHorizontal);
        double largeSidebarHeight = this.computeNodeHeight(largeSidebarNode, isSideBarInHorizontal);
        double smallSidebarWidth = this.computeNodeWidth(smallSidebarNode, isSideBarInHorizontal);
        double smallSidebarHeight = this.computeNodeHeight(smallSidebarNode, isSideBarInHorizontal);
        double sidebarWidth = 0.0;
        double sidebarHeight = 0.0;
        Node activeSidebar = null;
        if (largeSidebarNode != null && isSideBarInHorizontal && insideWidth >= prefContentWidth + largeSidebarWidth + gap) {
            activeSidebar = largeSidebarNode;
            sidebarWidth = largeSidebarWidth;
        } else if (largeSidebarNode != null && !isSideBarInHorizontal && insideHeight >= prefContentHeight + largeSidebarHeight + gap) {
            activeSidebar = largeSidebarNode;
            sidebarHeight = largeSidebarHeight;
        } else if (smallSidebarNode != null && isSideBarInHorizontal && insideWidth > prefContentWidth + smallSidebarWidth + gap) {
            activeSidebar = smallSidebarNode;
            sidebarWidth = smallSidebarWidth;
        } else if (smallSidebarNode != null && !isSideBarInHorizontal && insideHeight > prefContentHeight + smallSidebarHeight + gap) {
            activeSidebar = smallSidebarNode;
            sidebarHeight = smallSidebarHeight;
        }
        double contentStartX = insets.getLeft();
        double contentStartY = insets.getTop();
        double contentWidth = insideWidth;
        double contentHeight = insideHeight;
        boolean largeSidebarNeedDisplay = false;
        if (activeSidebar != null) {
            switch (side) {
                case LEFT: {
                    activeSidebar.relocate(contentStartX, contentStartY);
                    activeSidebar.resize(sidebarWidth, insideHeight);
                    if (activeSidebar == smallSidebarNode && largeSidebarNode != null && this.isForceLargeSidebarDisplay()) {
                        largeSidebarNeedDisplay = true;
                        if (this.isLargeSidebarCoversSmall()) {
                            largeSidebarNode.relocate(contentStartX, contentStartY);
                            largeSidebarNode.resize(largeSidebarWidth, insideHeight);
                        } else {
                            largeSidebarNode.relocate(contentStartX + sidebarWidth, contentStartY);
                            largeSidebarNode.resize(largeSidebarWidth, insideHeight);
                        }
                    }
                    contentStartX += sidebarWidth + gap;
                    contentWidth -= sidebarWidth + gap;
                    break;
                }
                case RIGHT: {
                    activeSidebar.relocate(contentStartX + insideWidth - sidebarWidth, contentStartY);
                    activeSidebar.resize(sidebarWidth, insideHeight);
                    if (activeSidebar == smallSidebarNode && largeSidebarNode != null && this.isForceLargeSidebarDisplay()) {
                        largeSidebarNeedDisplay = true;
                        if (this.isLargeSidebarCoversSmall()) {
                            largeSidebarNode.relocate(contentStartX + insideWidth - largeSidebarWidth, contentStartY);
                            largeSidebarNode.resize(largeSidebarWidth, insideHeight);
                        } else {
                            largeSidebarNode.relocate(contentStartX + insideWidth - largeSidebarWidth - sidebarWidth, contentStartY);
                            largeSidebarNode.resize(largeSidebarWidth, insideHeight);
                        }
                    }
                    contentWidth -= sidebarWidth + gap;
                    break;
                }
                case TOP: {
                    activeSidebar.relocate(contentStartX, contentStartY);
                    activeSidebar.resize(insideWidth, sidebarHeight);
                    if (activeSidebar == smallSidebarNode && largeSidebarNode != null && this.isForceLargeSidebarDisplay()) {
                        largeSidebarNeedDisplay = true;
                        if (this.isLargeSidebarCoversSmall()) {
                            largeSidebarNode.relocate(contentStartX, contentStartY);
                            largeSidebarNode.resize(insideWidth, largeSidebarHeight);
                        } else {
                            largeSidebarNode.relocate(contentStartX, contentStartY + sidebarHeight);
                            largeSidebarNode.resize(insideWidth, largeSidebarHeight);
                        }
                    }
                    contentStartY += sidebarHeight + gap;
                    contentHeight -= sidebarHeight + gap;
                    break;
                }
                case BOTTOM: {
                    activeSidebar.relocate(contentStartX, contentStartY + insideHeight - sidebarHeight);
                    activeSidebar.resize(insideWidth, sidebarHeight);
                    if (activeSidebar == smallSidebarNode && largeSidebarNode != null && this.isForceLargeSidebarDisplay()) {
                        largeSidebarNeedDisplay = true;
                        if (this.isLargeSidebarCoversSmall()) {
                            largeSidebarNode.relocate(contentStartX, contentStartY + insideHeight - largeSidebarHeight);
                            largeSidebarNode.resize(insideWidth, largeSidebarHeight);
                        } else {
                            largeSidebarNode.relocate(contentStartX, contentStartY + insideHeight - largeSidebarHeight - sidebarHeight);
                            largeSidebarNode.resize(insideWidth, largeSidebarHeight);
                        }
                    }
                    contentHeight -= sidebarHeight + gap;
                }
            }
            activeSidebar.setVisible(true);
            activeSidebar.setManaged(true);
        }
        this.pseudoClassStateChanged(SHOWING_NONE_PSEUDOCLASS, activeSidebar == null);
        this.pseudoClassStateChanged(SHOWING_SMALL_PSEUDOCLASS, activeSidebar == smallSidebarNode);
        this.pseudoClassStateChanged(SHOWING_LARGE_PSEUDOCLASS, activeSidebar == largeSidebarNode);
        this.pseudoClassStateChanged(FORCED_PSEUDOCLASS, largeSidebarNeedDisplay);
        this.pseudoClassStateChanged(COVERING_PSEUDOCLASS, largeSidebarNeedDisplay && this.isLargeSidebarCoversSmall());
        this.glassPaneNeedHide.set(!largeSidebarNeedDisplay);
        if (contentNode != null) {
            contentNode.relocate(contentStartX, contentStartY);
            contentNode.resize(contentWidth, contentHeight);
            if (this.getChildren().get(0) != contentNode) {
                ((NodeProperty)this.contentProperty()).setSuppressLayoutChanges(true);
                contentNode.toBack();
                ((NodeProperty)this.contentProperty()).setSuppressLayoutChanges(false);
            }
        }
        this.glassPane.relocate(contentStartX, contentStartY);
        this.glassPane.resize(contentWidth, contentHeight);
        if (smallSidebarNode != null && activeSidebar != smallSidebarNode) {
            smallSidebarNode.setVisible(false);
            smallSidebarNode.setManaged(false);
        }
        if (largeSidebarNode != null && activeSidebar != largeSidebarNode) {
            if (this.isForceLargeSidebarDisplay()) {
                largeSidebarNode.setVisible(largeSidebarNeedDisplay);
                largeSidebarNode.setManaged(largeSidebarNeedDisplay);
                if (this.getChildren().get(this.getChildren().size() - 1) != largeSidebarNode) {
                    ((NodeProperty)this.largeSidebarProperty()).setSuppressLayoutChanges(true);
                    largeSidebarNode.toFront();
                    ((NodeProperty)this.largeSidebarProperty()).setSuppressLayoutChanges(false);
                }
            } else {
                largeSidebarNode.setVisible(false);
                largeSidebarNode.setManaged(false);
            }
        }
    }

    private double computeNodeHeight(Node node, boolean isSideBarInHorizontal) {
        if (node == null || isSideBarInHorizontal) {
            return 0.0;
        }
        return this.boundSize(node.prefHeight(-1.0), node.minHeight(-1.0), node.maxHeight(-1.0));
    }

    private double computeNodeWidth(Node node, boolean isSideBarInHorizontal) {
        if (node == null || !isSideBarInHorizontal) {
            return 0.0;
        }
        return this.boundSize(node.prefWidth(-1.0), node.minWidth(-1.0), node.maxWidth(-1.0));
    }

    private double boundSize(double pref, double min, double max) {
        double a = Math.max(pref, min);
        double b = Math.max(min, max);
        return Math.min(a, b);
    }

    private final class NodeProperty
    extends ObjectPropertyBase<Node> {
        private Node oldValue = null;
        private final String propertyName;
        private boolean isBeingInvalidated;
        private boolean suppressLayoutChanges;

        NodeProperty(String propertyName) {
            this.propertyName = propertyName;
            ResponsivePane.this.getChildren().addListener(c -> {
                if (this.oldValue == null || this.isBeingInvalidated || this.suppressLayoutChanges) {
                    return;
                }
                while (c.next()) {
                    if (!c.wasRemoved()) continue;
                    List removed = c.getRemoved();
                    for (Node node : removed) {
                        if (node != this.oldValue) continue;
                        this.oldValue = null;
                        this.set(null);
                    }
                }
            });
        }

        protected void invalidated() {
            if (this.suppressLayoutChanges) {
                return;
            }
            ObservableList children = ResponsivePane.this.getChildren();
            this.isBeingInvalidated = true;
            try {
                Node _value;
                if (this.oldValue != null) {
                    children.remove(this.oldValue);
                }
                this.oldValue = _value = (Node)this.get();
                if (_value != null) {
                    children.add(_value);
                }
            }
            finally {
                this.isBeingInvalidated = false;
            }
        }

        public void setSuppressLayoutChanges(boolean suppress) {
            this.suppressLayoutChanges = suppress;
        }

        public Object getBean() {
            return this;
        }

        public String getName() {
            return this.propertyName;
        }
    }

    private static class StyleableProperties {
        private static final CssMetaData<ResponsivePane, Side> SIDE = new CssMetaData<ResponsivePane, Side>("-fx-side", (StyleConverter)new EnumConverter(Side.class), DEFAULT_SIDE){

            public boolean isSettable(ResponsivePane node) {
                return node.side == null || !node.side.isBound();
            }

            public StyleableProperty<Side> getStyleableProperty(ResponsivePane node) {
                return (StyleableProperty)node.sideProperty();
            }
        };
        private static final CssMetaData<ResponsivePane, Number> GAP = new CssMetaData<ResponsivePane, Number>("-fx-gap", SizeConverter.getInstance(), (Number)0.0){

            public boolean isSettable(ResponsivePane node) {
                return node.gap == null || !node.gap.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(ResponsivePane node) {
                return (StyleableProperty)node.gapProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Region.getClassCssMetaData());
            Collections.addAll(styleables, SIDE, GAP);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

