/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx;

import com.dlsc.gemsfx.skins.ScreensViewSkin;
import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.effect.BlurType;
import javafx.scene.effect.DropShadow;
import javafx.scene.effect.Reflection;
import javafx.scene.image.Image;
import javafx.scene.shape.Shape;
import javafx.stage.Screen;
import javafx.stage.Stage;
import javafx.stage.StageStyle;
import javafx.util.Callback;

public class ScreensView
extends Control {
    private static final Image DEFAULT_WALLPAPER = new Image(Objects.requireNonNull(ScreensView.class.getResource("wallpaper.jpg")).toExternalForm(), false);
    private final ObjectProperty<DropShadow> shadow = new SimpleObjectProperty((Object)this, "shadow");
    private final ObjectProperty<Reflection> reflection = new SimpleObjectProperty((Object)this, "reflection");
    private final ObservableList<Shape> shapes = FXCollections.observableArrayList();
    private final BooleanProperty showShadow = new SimpleBooleanProperty((Object)this, "showShadow", true);
    private final BooleanProperty showReflection = new SimpleBooleanProperty((Object)this, "showReflection", true);
    private final BooleanProperty showWallpaper = new SimpleBooleanProperty((Object)this, "showWallpaper", true);
    private final BooleanProperty showWindows = new SimpleBooleanProperty((Object)this, "showWindows", false);
    private final ObjectProperty<Callback<Screen, Image>> wallpaperProvider = new SimpleObjectProperty((Object)this, "wallpaperProvider");
    private final BooleanProperty enableWindowDragging = new SimpleBooleanProperty((Object)this, "enableWindowDragging", true);

    public ScreensView() {
        this.getStyleClass().add((Object)"screens-view");
        this.setWallpaperProvider((Callback<Screen, Image>)((Callback)screen -> DEFAULT_WALLPAPER));
        this.setFocusTraversable(false);
        DropShadow shadow = new DropShadow();
        shadow.setBlurType(BlurType.THREE_PASS_BOX);
        shadow.setRadius(2.0);
        this.setShadow(shadow);
        Reflection reflection = new Reflection();
        reflection.setFraction(0.25);
        reflection.setTopOffset(5.0);
        reflection.setTopOpacity(0.3);
        reflection.setBottomOpacity(0.0);
        this.setReflection(reflection);
    }

    protected Skin<?> createDefaultSkin() {
        return new ScreensViewSkin(this);
    }

    public String getUserAgentStylesheet() {
        return Objects.requireNonNull(ScreensView.class.getResource("screens-view.css")).toExternalForm();
    }

    public static ScreensView show() {
        ScreensView view = new ScreensView();
        Stage stage = new Stage(StageStyle.UTILITY);
        stage.setScene(new Scene((Parent)view));
        stage.setX(10.0);
        stage.setY(20.0);
        stage.setTitle("Screens");
        stage.show();
        return view;
    }

    public final DropShadow getShadow() {
        return (DropShadow)this.shadow.get();
    }

    public final ObjectProperty<DropShadow> shadowProperty() {
        return this.shadow;
    }

    public final void setShadow(DropShadow shadow) {
        this.shadow.set((Object)shadow);
    }

    public final Reflection getReflection() {
        return (Reflection)this.reflection.get();
    }

    public final ObjectProperty<Reflection> reflectionProperty() {
        return this.reflection;
    }

    public final void setReflection(Reflection reflection) {
        this.reflection.set((Object)reflection);
    }

    public final ObservableList<Shape> getShapes() {
        return this.shapes;
    }

    public final boolean isShowShadow() {
        return this.showShadow.get();
    }

    public final BooleanProperty showShadowProperty() {
        return this.showShadow;
    }

    public final void setShowShadow(boolean showShadow) {
        this.showShadow.set(showShadow);
    }

    public final boolean isShowReflection() {
        return this.showReflection.get();
    }

    public final BooleanProperty showReflectionProperty() {
        return this.showReflection;
    }

    public final void setShowReflection(boolean showReflection) {
        this.showReflection.set(showReflection);
    }

    public final boolean isShowWallpaper() {
        return this.showWallpaper.get();
    }

    public final BooleanProperty showWallpaperProperty() {
        return this.showWallpaper;
    }

    public final void setShowWallpaper(boolean showWallpaper) {
        this.showWallpaper.set(showWallpaper);
    }

    public final boolean isShowWindows() {
        return this.showWindows.get();
    }

    public final BooleanProperty showWindowsProperty() {
        return this.showWindows;
    }

    public final void setShowWindows(boolean showWindows) {
        this.showWindows.set(showWindows);
    }

    public final Callback<Screen, Image> getWallpaperProvider() {
        return (Callback)this.wallpaperProvider.get();
    }

    public final ObjectProperty<Callback<Screen, Image>> wallpaperProviderProperty() {
        return this.wallpaperProvider;
    }

    public final void setWallpaperProvider(Callback<Screen, Image> wallpaperProvider) {
        this.wallpaperProvider.set(wallpaperProvider);
    }

    public final boolean isEnableWindowDragging() {
        return this.enableWindowDragging.get();
    }

    public final BooleanProperty enableWindowDraggingProperty() {
        return this.enableWindowDragging;
    }

    public final void setEnableWindowDragging(boolean enableWindowDragging) {
        this.enableWindowDragging.set(enableWindowDragging);
    }
}

