/*
 * Decompiled with CFR 0.152.
 */
package com.dlsc.gemsfx;

import com.dlsc.gemsfx.skins.AvatarViewSkin;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.css.converter.EnumConverter;
import javafx.css.converter.SizeConverter;
import javafx.scene.control.Control;
import javafx.scene.control.Skin;
import javafx.scene.image.Image;
import org.apache.commons.lang3.StringUtils;

public class AvatarView
extends Control {
    private static final String DEFAULT_STYLE_CLASS = "avatar-view";
    private static final AvatarShape DEFAULT_AVATAR_SHAPE = AvatarShape.SQUARE;
    private static final double DEFAULT_ARC_SIZE = 10.0;
    private static final double DEFAULT_SIZE = 50.0;
    private final IntegerProperty numberOfStyles = new SimpleIntegerProperty((Object)this, "numberOfStyles", 5);
    private final StringProperty initials = new SimpleStringProperty((Object)this, "initials");
    private final ObjectProperty<Image> image = new SimpleObjectProperty((Object)this, "image");
    private final DoubleProperty arcSize = new StyleableDoubleProperty(10.0){

        public Object getBean() {
            return AvatarView.this;
        }

        public String getName() {
            return "arcSize";
        }

        public CssMetaData<? extends Styleable, Number> getCssMetaData() {
            return StyleableProperties.AVATAR_ARC_SIZE;
        }
    };
    private final DoubleProperty size = new StyleableDoubleProperty(50.0){

        public Object getBean() {
            return AvatarView.this;
        }

        public String getName() {
            return "size";
        }

        public CssMetaData<? extends Styleable, Number> getCssMetaData() {
            return StyleableProperties.AVATAR_SIZE;
        }
    };
    private final StyleableObjectProperty<AvatarShape> avatarShape = new StyleableObjectProperty<AvatarShape>(DEFAULT_AVATAR_SHAPE){

        public CssMetaData<? extends Styleable, AvatarShape> getCssMetaData() {
            return StyleableProperties.AVATAR_SHAPE;
        }

        public Object getBean() {
            return AvatarView.this;
        }

        public String getName() {
            return "avatarShape";
        }
    };
    private final IntegerProperty magicNumber = new SimpleIntegerProperty((Object)this, "magicNumber", -1);

    public AvatarView() {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.setFocusTraversable(false);
        this.initials.subscribe(this::updateMagicNumber);
        this.magicNumber.subscribe(number -> {
            this.getStyleClass().setAll((Object[])new String[]{DEFAULT_STYLE_CLASS});
            if (number.intValue() >= 0) {
                int index = number.intValue() % this.getNumberOfStyles();
                this.getStyleClass().add((Object)("style" + index));
            }
        });
        this.prefWidthProperty().bind((ObservableValue)this.sizeProperty());
        this.prefHeightProperty().bind((ObservableValue)this.sizeProperty());
        this.minWidthProperty().bind((ObservableValue)this.sizeProperty());
        this.minHeightProperty().bind((ObservableValue)this.sizeProperty());
        this.maxWidthProperty().bind((ObservableValue)this.sizeProperty());
        this.maxHeightProperty().bind((ObservableValue)this.sizeProperty());
    }

    public AvatarView(String initials, Image image) {
        this();
        this.setInitials(initials);
        this.setImage(image);
    }

    public AvatarView(String initials) {
        this();
        this.setInitials(initials);
    }

    public AvatarView(Image image) {
        this();
        this.setImage(image);
    }

    protected Skin<?> createDefaultSkin() {
        return new AvatarViewSkin(this);
    }

    public String getUserAgentStylesheet() {
        return Objects.requireNonNull(AvatarView.class.getResource("avatar-view.css")).toExternalForm();
    }

    public final int getNumberOfStyles() {
        return this.numberOfStyles.get();
    }

    public final IntegerProperty numberOfStylesProperty() {
        return this.numberOfStyles;
    }

    public final void setNumberOfStyles(int numberOfStyles) {
        this.numberOfStyles.set(numberOfStyles);
    }

    public final String getInitials() {
        return (String)this.initials.get();
    }

    public final StringProperty initialsProperty() {
        return this.initials;
    }

    public final void setInitials(String initials) {
        this.initials.set((Object)initials);
    }

    public final ObjectProperty<Image> imageProperty() {
        return this.image;
    }

    public final Image getImage() {
        return (Image)this.imageProperty().get();
    }

    public final void setImage(Image image) {
        this.imageProperty().set((Object)image);
    }

    public final double getArcSize() {
        return this.arcSize.get();
    }

    public final DoubleProperty arcSizeProperty() {
        return this.arcSize;
    }

    public final void setArcSize(double arcSize) {
        this.arcSize.set(arcSize);
    }

    public final double getSize() {
        return this.size.get();
    }

    public final DoubleProperty sizeProperty() {
        return this.size;
    }

    public final void setSize(double size) {
        this.size.set(size);
    }

    public final ObjectProperty<AvatarShape> avatarShapeProperty() {
        return this.avatarShape;
    }

    public final AvatarShape getAvatarShape() {
        return (AvatarShape)((Object)this.avatarShapeProperty().get());
    }

    public final void setAvatarShape(AvatarShape type) {
        this.avatarShapeProperty().set((Object)type);
    }

    private void updateMagicNumber() {
        String initials = this.getInitials();
        if (StringUtils.isNotBlank((CharSequence)initials)) {
            int spice;
            char[] numbers;
            if (initials.toLowerCase().length() >= 2) {
                numbers = initials.toLowerCase().substring(0, 2).toCharArray();
                spice = numbers[0] < numbers[1] ? 0 : 1;
            } else {
                numbers = initials.toLowerCase().substring(0, 1).toCharArray();
                spice = 1;
            }
            int sum = 0;
            for (char c : numbers) {
                sum += c;
            }
            this.magicNumber.set(sum + spice);
        } else {
            this.magicNumber.set(-1);
        }
    }

    protected List<CssMetaData<? extends Styleable, ?>> getControlCssMetaData() {
        return AvatarView.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public static enum AvatarShape {
        ROUND,
        SQUARE;

    }

    private static class StyleableProperties {
        private static final CssMetaData<AvatarView, AvatarShape> AVATAR_SHAPE = new CssMetaData<AvatarView, AvatarShape>("-fx-avatar-shape", (StyleConverter)new EnumConverter(AvatarShape.class), DEFAULT_AVATAR_SHAPE){

            public boolean isSettable(AvatarView control) {
                return !control.avatarShape.isBound();
            }

            public StyleableProperty<AvatarShape> getStyleableProperty(AvatarView control) {
                return (StyleableProperty)control.avatarShapeProperty();
            }
        };
        private static final CssMetaData<AvatarView, Number> AVATAR_ARC_SIZE = new CssMetaData<AvatarView, Number>("-fx-avatar-arc-size", SizeConverter.getInstance(), (Number)10.0){

            public boolean isSettable(AvatarView n) {
                return !n.arcSize.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(AvatarView n) {
                return (StyleableProperty)n.arcSizeProperty();
            }
        };
        private static final CssMetaData<AvatarView, Number> AVATAR_SIZE = new CssMetaData<AvatarView, Number>("-fx-avatar-size", SizeConverter.getInstance(), (Number)50.0){

            public boolean isSettable(AvatarView n) {
                return !n.size.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(AvatarView n) {
                return (StyleableProperty)n.sizeProperty();
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList styleables = new ArrayList(Control.getClassCssMetaData());
            Collections.addAll(styleables, AVATAR_SHAPE, AVATAR_ARC_SIZE, AVATAR_SIZE);
            STYLEABLES = Collections.unmodifiableList(styleables);
        }
    }
}

