/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.cli;

import com.airhacks.afterburner.injection.Injector;
import java.util.List;
import java.util.Objects;
import javafx.util.Pair;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.jabref.logic.exporter.ExporterFactory;
import org.jabref.logic.importer.ImportFormatReader;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.BuildInfo;
import org.jabref.logic.util.OS;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.strings.StringUtil;
import org.jabref.model.util.DummyFileUpdateMonitor;
import org.jabref.preferences.PreferencesService;

public class JabRefCLI {
    private static final int WIDTH = 100;
    private static final String WRAPPED_LINE_PREFIX = "";
    private static final String STRING_TABLE_DELIMITER = " : ";
    private final CommandLine cl;
    private final List<String> leftOver;

    public JabRefCLI(String[] args) throws ParseException {
        Options options = JabRefCLI.getOptions();
        this.cl = new DefaultParser().parse(options, args, true);
        this.leftOver = this.cl.getArgList();
    }

    public static String getExportMatchesSyntax() {
        return "[%s]searchTerm,outputFile:%s[,%s]".formatted(Localization.lang("field", new Object[0]), Localization.lang("file", new Object[0]), Localization.lang("exportFormat", new Object[0]));
    }

    public boolean isHelp() {
        return this.cl.hasOption("help");
    }

    public boolean isShowVersion() {
        return this.cl.hasOption("version");
    }

    public boolean isBlank() {
        return this.cl.hasOption("blank");
    }

    public boolean isDisableGui() {
        return this.cl.hasOption("nogui");
    }

    public boolean isPreferencesExport() {
        return this.cl.hasOption("prexp");
    }

    public String getPreferencesExport() {
        return this.cl.getOptionValue("prexp", "jabref_prefs.xml");
    }

    public boolean isPreferencesImport() {
        return this.cl.hasOption("primp");
    }

    public String getPreferencesImport() {
        return this.cl.getOptionValue("primp", "jabref_prefs.xml");
    }

    public boolean isPreferencesReset() {
        return this.cl.hasOption("prdef");
    }

    public String getPreferencesReset() {
        return this.cl.getOptionValue("prdef");
    }

    public boolean isFileExport() {
        return this.cl.hasOption("output");
    }

    public String getFileExport() {
        return this.cl.getOptionValue("output");
    }

    public boolean isBibtexImport() {
        return this.cl.hasOption("importBibtex");
    }

    public String getBibtexImport() {
        return this.cl.getOptionValue("importBibtex");
    }

    public boolean isFileImport() {
        return this.cl.hasOption("import");
    }

    public String getFileImport() {
        return this.cl.getOptionValue("import");
    }

    public boolean isAuxImport() {
        return this.cl.hasOption("aux");
    }

    public String getAuxImport() {
        return this.cl.getOptionValue("aux");
    }

    public boolean isImportToOpenBase() {
        return this.cl.hasOption("importToOpen");
    }

    public String getImportToOpenBase() {
        return this.cl.getOptionValue("importToOpen");
    }

    public boolean isDebugLogging() {
        return this.cl.hasOption("debug");
    }

    public boolean isFetcherEngine() {
        return this.cl.hasOption("fetch");
    }

    public String getFetcherEngine() {
        return this.cl.getOptionValue("fetch");
    }

    public boolean isExportMatches() {
        return this.cl.hasOption("exportMatches");
    }

    public String getExportMatches() {
        return this.cl.getOptionValue("exportMatches");
    }

    public boolean isGenerateCitationKeys() {
        return this.cl.hasOption("generateCitationKeys");
    }

    public boolean isAutomaticallySetFileLinks() {
        return this.cl.hasOption("automaticallySetFileLinks");
    }

    public boolean isWriteXMPtoPdf() {
        return this.cl.hasOption("writeXMPtoPdf");
    }

    public boolean isEmbeddBibfileInPdf() {
        return this.cl.hasOption("embeddBibfileInPdf");
    }

    public boolean isWriteMetadatatoPdf() {
        return this.cl.hasOption("writeMetadatatoPdf");
    }

    public String getWriteMetadatatoPdf() {
        return this.cl.hasOption("writeMetadatatoPdf") ? this.cl.getOptionValue("writeMetadatatoPdf") : (this.cl.hasOption("writeXMPtoPdf") ? this.cl.getOptionValue("writeXMPtoPdf") : (this.cl.hasOption("embeddBibfileInPdf") ? this.cl.getOptionValue("embeddBibfileInPdf") : null));
    }

    public String getJumpToKey() {
        return this.cl.getOptionValue("jumpToKey");
    }

    public boolean isJumpToKey() {
        return this.cl.hasOption("jumpToKey");
    }

    private static Options getOptions() {
        Options options = new Options();
        options.addOption("h", "help", false, Localization.lang("Display help on command line options", new Object[0]));
        options.addOption("n", "nogui", false, Localization.lang("No GUI. Only process command line options", new Object[0]));
        options.addOption("asfl", "automaticallySetFileLinks", false, Localization.lang("Automatically set file links", new Object[0]));
        options.addOption("g", "generateCitationKeys", false, Localization.lang("Regenerate all keys for the entries in a BibTeX file", new Object[0]));
        options.addOption("b", "blank", false, Localization.lang("Do not open any files at startup", new Object[0]));
        options.addOption("v", "version", false, Localization.lang("Display version", new Object[0]));
        options.addOption(null, "debug", false, Localization.lang("Show debug level messages", new Object[0]));
        options.addOption(Option.builder((String)"i").longOpt("import").desc("%s: '%s'".formatted(Localization.lang("Import file", new Object[0]), "-i library.bib")).hasArg().argName("FILE[,FORMAT]").build());
        options.addOption(Option.builder().longOpt("importToOpen").desc(Localization.lang("Same as --import, but will be imported to the opened tab", new Object[0])).hasArg().argName("FILE[,FORMAT]").build());
        options.addOption(Option.builder((String)"ib").longOpt("importBibtex").desc("%s: '%s'".formatted(Localization.lang("Import BibTeX", new Object[0]), "-ib @article{entry}")).hasArg().argName("BIBTEXT_STRING").build());
        options.addOption(Option.builder((String)"o").longOpt("output").desc("%s: '%s'".formatted(Localization.lang("Export an input to a file", new Object[0]), "-i db.bib -o db.htm,html")).hasArg().argName("FILE[,FORMAT]").build());
        options.addOption(Option.builder((String)"m").longOpt("exportMatches").desc("%s: '%s'".formatted(Localization.lang("Matching", new Object[0]), "-i db.bib -m author=Newton,search.htm,html")).hasArg().argName("QUERY,FILE[,FORMAT]").build());
        options.addOption(Option.builder((String)"f").longOpt("fetch").desc("%s: '%s'".formatted(Localization.lang("Run fetcher", new Object[0]), "-f Medline/PubMed:cancer")).hasArg().argName("FETCHER:QUERY").build());
        options.addOption(Option.builder((String)"a").longOpt("aux").desc("%s: '%s'".formatted(Localization.lang("Sublibrary from AUX to BibTeX", new Object[0]), "-a thesis.aux,new.bib")).hasArg().argName("FILE[.aux],FILE[.bib] FILE").build());
        options.addOption(Option.builder((String)"x").longOpt("prexp").desc("%s: '%s'".formatted(Localization.lang("Export preferences to a file", new Object[0]), "-x prefs.xml")).hasArg().argName("[FILE]").build());
        options.addOption(Option.builder((String)"p").longOpt("primp").desc("%s: '%s'".formatted(Localization.lang("Import preferences from a file", new Object[0]), "-p prefs.xml")).hasArg().argName("[FILE]").build());
        options.addOption(Option.builder((String)"d").longOpt("prdef").desc("%s: '%s'".formatted(Localization.lang("Reset preferences", new Object[0]), "-d mainFontSize,newline' or '-d all")).hasArg().argName("KEY1[,KEY2][,KEYn] | all").build());
        options.addOption(Option.builder().longOpt("writeXMPtoPdf").desc("%s: '%s'".formatted(Localization.lang("Write BibTeXEntry as XMP metadata to PDF.", new Object[0]), "-w pathToMyOwnPaper.pdf")).hasArg().argName("CITEKEY1[,CITEKEY2][,CITEKEYn] | PDF1[,PDF2][,PDFn] | all").build());
        options.addOption(Option.builder().longOpt("embeddBibfileInPdf").desc("%s: '%s'".formatted(Localization.lang("Embed BibTeX as attached file in PDF.", new Object[0]), "-w pathToMyOwnPaper.pdf")).hasArg().argName("CITEKEY1[,CITEKEY2][,CITEKEYn] | PDF1[,PDF2][,PDFn] | all").build());
        options.addOption(Option.builder((String)"w").longOpt("writeMetadatatoPdf").desc("%s: '%s'".formatted(Localization.lang("Write BibTeXEntry as metadata to PDF.", new Object[0]), "-w pathToMyOwnPaper.pdf")).hasArg().argName("CITEKEY1[,CITEKEY2][,CITEKEYn] | PDF1[,PDF2][,PDFn] | all").build());
        options.addOption(Option.builder((String)"j").longOpt("jumpToKey").desc("%s: '%s'".formatted(Localization.lang("Jump to the entry of the given citation key.", new Object[0]), "-j key")).hasArg().argName("CITATIONKEY").build());
        return options;
    }

    public void displayVersion() {
        System.out.println(this.getVersionInfo());
    }

    public static void printUsage(PreferencesService preferencesService) {
        String header = WRAPPED_LINE_PREFIX;
        ImportFormatReader importFormatReader = new ImportFormatReader(preferencesService.getImporterPreferences(), preferencesService.getImportFormatPreferences(), preferencesService.getCitationKeyPatternPreferences(), new DummyFileUpdateMonitor());
        List<Pair<String, String>> importFormats = importFormatReader.getImportFormats().stream().map(format -> new Pair((Object)format.getName(), (Object)format.getId())).toList();
        String importFormatsIntro = Localization.lang("Available import formats", new Object[0]);
        String importFormatsList = "%s:%n%s%n".formatted(importFormatsIntro, JabRefCLI.alignStringTable(importFormats));
        ExporterFactory exporterFactory = ExporterFactory.create(preferencesService, (BibEntryTypesManager)Injector.instantiateModelOrService(BibEntryTypesManager.class));
        List<Pair<String, String>> exportFormats = exporterFactory.getExporters().stream().map(format -> new Pair((Object)format.getName(), (Object)format.getId())).toList();
        String outFormatsIntro = Localization.lang("Available export formats", new Object[0]);
        String outFormatsList = "%s:%n%s%n".formatted(outFormatsIntro, JabRefCLI.alignStringTable(exportFormats));
        String footer = "\n" + importFormatsList + outFormatsList + "\nPlease report issues at https://github.com/JabRef/jabref/issues.";
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(100, "jabref [OPTIONS] [BIBTEX_FILE]\n\nOptions:", header, JabRefCLI.getOptions(), footer, true);
    }

    private String getVersionInfo() {
        BuildInfo buildInfo = (BuildInfo)Injector.instantiateModelOrService(BuildInfo.class);
        return "JabRef %s".formatted(buildInfo.version);
    }

    public List<String> getLeftOver() {
        return this.leftOver;
    }

    protected static String alignStringTable(List<Pair<String, String>> table) {
        StringBuilder sb = new StringBuilder();
        int maxLength = table.stream().mapToInt(pair -> Objects.requireNonNullElse((String)pair.getKey(), WRAPPED_LINE_PREFIX).length()).max().orElse(0);
        for (Pair<String, String> pair2 : table) {
            int padding = Math.max(0, maxLength - ((String)pair2.getKey()).length());
            sb.append(WRAPPED_LINE_PREFIX);
            sb.append((String)pair2.getKey());
            sb.append(StringUtil.repeatSpaces(padding));
            sb.append(STRING_TABLE_DELIMITER);
            sb.append((String)pair2.getValue());
            sb.append(OS.NEWLINE);
        }
        return sb.toString();
    }
}

