/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.actions;

import com.tobiasdiez.easybind.EasyBind;
import com.tobiasdiez.easybind.EasyBinding;
import java.nio.file.Path;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanExpression;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.control.TabPane;
import org.jabref.gui.StateManager;
import org.jabref.logic.shared.DatabaseLocation;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.LinkedFile;
import org.jabref.model.entry.field.Field;
import org.jabref.preferences.PreferencesService;

public class ActionHelper {
    public static BooleanExpression needsDatabase(StateManager stateManager) {
        return stateManager.activeDatabaseProperty().isPresent();
    }

    public static BooleanExpression needsSharedDatabase(StateManager stateManager) {
        EasyBinding binding = EasyBind.map(stateManager.activeDatabaseProperty(), context -> context.filter(c -> c.getLocation() == DatabaseLocation.SHARED).isPresent());
        return BooleanExpression.booleanExpression((ObservableValue)binding);
    }

    public static BooleanExpression needsMultipleDatabases(TabPane tabbedPane) {
        return Bindings.size((ObservableList)tabbedPane.getTabs()).greaterThan(1);
    }

    public static BooleanExpression needsStudyDatabase(StateManager stateManager) {
        EasyBinding binding = EasyBind.map(stateManager.activeDatabaseProperty(), context -> context.filter(BibDatabaseContext::isStudy).isPresent());
        return BooleanExpression.booleanExpression((ObservableValue)binding);
    }

    public static BooleanExpression needsEntriesSelected(StateManager stateManager) {
        return Bindings.isNotEmpty(stateManager.getSelectedEntries());
    }

    public static BooleanExpression needsEntriesSelected(int numberOfEntries, StateManager stateManager) {
        return Bindings.createBooleanBinding(() -> stateManager.getSelectedEntries().size() == numberOfEntries, (Observable[])new Observable[]{stateManager.getSelectedEntries()});
    }

    public static BooleanExpression isFieldSetForSelectedEntry(Field field, StateManager stateManager) {
        return ActionHelper.isAnyFieldSetForSelectedEntry(Collections.singletonList(field), stateManager);
    }

    public static BooleanExpression isAnyFieldSetForSelectedEntry(List<Field> fields, StateManager stateManager) {
        ObservableList<BibEntry> selectedEntries = stateManager.getSelectedEntries();
        EasyBinding fieldsAreSet = EasyBind.valueAt(selectedEntries, (int)0).mapObservable(entry -> Bindings.createBooleanBinding(() -> entry.getFields().stream().anyMatch(fields::contains), (Observable[])new Observable[]{entry.getFieldsObservable()})).orElseOpt((Object)false);
        return BooleanExpression.booleanExpression((ObservableValue)fieldsAreSet);
    }

    public static BooleanExpression isFilePresentForSelectedEntry(StateManager stateManager, PreferencesService preferencesService) {
        ObservableList<BibEntry> selectedEntries = stateManager.getSelectedEntries();
        EasyBinding fileIsPresent = EasyBind.valueAt(selectedEntries, (int)0).mapOpt(entry -> {
            List<LinkedFile> files = entry.getFiles();
            if (!entry.getFiles().isEmpty() && stateManager.getActiveDatabase().isPresent()) {
                if (files.getFirst().isOnlineLink()) {
                    return true;
                }
                Optional<Path> filename = FileUtil.find(stateManager.getActiveDatabase().get(), files.getFirst().getLink(), preferencesService.getFilePreferences());
                return filename.isPresent();
            }
            return false;
        }).orElseOpt((Object)false);
        return BooleanExpression.booleanExpression((ObservableValue)fileIsPresent);
    }

    public static BooleanExpression hasLinkedFileForSelectedEntries(StateManager stateManager) {
        return BooleanExpression.booleanExpression((ObservableValue)EasyBind.reduce(stateManager.getSelectedEntries(), entries -> entries.anyMatch(entry -> !entry.getFiles().isEmpty())));
    }
}

