/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.edit;

import java.util.function.Supplier;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.TextInputControl;
import javafx.scene.web.WebView;
import javax.swing.undo.UndoManager;
import org.fxmisc.richtext.CodeArea;
import org.jabref.gui.LibraryTab;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionHelper;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.actions.StandardActions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EditAction
extends SimpleCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(EditAction.class);
    private final Supplier<LibraryTab> tabSupplier;
    private final StandardActions action;
    private final StateManager stateManager;
    private final UndoManager undoManager;

    public EditAction(StandardActions action, Supplier<LibraryTab> tabSupplier, StateManager stateManager, UndoManager undoManager) {
        this.action = action;
        this.tabSupplier = tabSupplier;
        this.stateManager = stateManager;
        this.undoManager = undoManager;
        if (action == StandardActions.PASTE) {
            this.executable.bind((ObservableValue)ActionHelper.needsDatabase(stateManager));
        } else {
            this.executable.bind((ObservableValue)ActionHelper.needsEntriesSelected(stateManager));
        }
    }

    public String toString() {
        return this.action.toString();
    }

    public void execute() {
        this.stateManager.getFocusOwner().ifPresent(focusOwner -> {
            block20: {
                block19: {
                    LOGGER.debug("focusOwner: {}; Action: {}", focusOwner, (Object)this.action.getText());
                    if (!(focusOwner instanceof TextInputControl)) break block19;
                    TextInputControl textInput = (TextInputControl)focusOwner;
                    switch (this.action) {
                        case SELECT_ALL: {
                            textInput.selectAll();
                            break block20;
                        }
                        case COPY: {
                            textInput.copy();
                            break block20;
                        }
                        case CUT: {
                            textInput.cut();
                            break block20;
                        }
                        case PASTE: {
                            textInput.paste();
                            break block20;
                        }
                        case DELETE: {
                            textInput.clear();
                            break block20;
                        }
                        case DELETE_ENTRY: {
                            textInput.deleteNextChar();
                            break block20;
                        }
                        case UNDO: {
                            textInput.undo();
                            break block20;
                        }
                        case REDO: {
                            textInput.redo();
                            break block20;
                        }
                        default: {
                            String message = "Only cut/copy/paste supported in TextInputControl but got " + String.valueOf(this.action);
                            LOGGER.error(message);
                            throw new IllegalStateException(message);
                        }
                    }
                }
                if (focusOwner instanceof CodeArea || focusOwner instanceof WebView) {
                    LOGGER.debug("Ignoring request in CodeArea or WebView");
                    return;
                }
                LOGGER.debug("Else: {}", (Object)focusOwner.getClass().getSimpleName());
                switch (this.action) {
                    case COPY: {
                        this.tabSupplier.get().copy();
                        break;
                    }
                    case CUT: {
                        this.tabSupplier.get().cut();
                        break;
                    }
                    case PASTE: {
                        this.tabSupplier.get().paste();
                        break;
                    }
                    case DELETE_ENTRY: {
                        this.tabSupplier.get().delete(StandardActions.DELETE_ENTRY);
                        break;
                    }
                    case UNDO: {
                        if (!this.undoManager.canUndo()) break;
                        this.undoManager.undo();
                        break;
                    }
                    case REDO: {
                        if (!this.undoManager.canRedo()) break;
                        this.undoManager.redo();
                        break;
                    }
                    default: {
                        LOGGER.debug("Only cut/copy/paste/deleteEntry supported but got: {} and focus owner {}", (Object)this.action, focusOwner);
                    }
                }
            }
        });
    }
}

