/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.entryeditor;

import java.util.Map;
import java.util.Set;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.MapProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleMapProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableMap;
import org.jabref.model.entry.field.Field;

public class EntryEditorPreferences {
    private final MapProperty<String, Set<Field>> entryEditorTabList;
    private final MapProperty<String, Set<Field>> defaultEntryEditorTabList;
    private final BooleanProperty shouldOpenOnNewEntry;
    private final BooleanProperty shouldShowRecommendationsTab;
    private final BooleanProperty shouldShowLatexCitationsTab;
    private final BooleanProperty showSourceTabByDefault;
    private final BooleanProperty enableValidation;
    private final BooleanProperty allowIntegerEditionBibtex;
    private final DoubleProperty dividerPosition;
    private final BooleanProperty autoLinkFiles;
    private final ObjectProperty<JournalPopupEnabled> enablementStatus;
    private final BooleanProperty shouldShowSciteTab;
    private final BooleanProperty showUserCommentsFields;
    private final DoubleProperty previewWidthDividerPosition;

    public EntryEditorPreferences(Map<String, Set<Field>> entryEditorTabList, Map<String, Set<Field>> defaultEntryEditorTabList, boolean shouldOpenOnNewEntry, boolean shouldShowRecommendationsTab, boolean shouldShowLatexCitationsTab, boolean showSourceTabByDefault, boolean enableValidation, boolean allowIntegerEditionBibtex, double dividerPosition, boolean autolinkFilesEnabled, JournalPopupEnabled journalPopupEnabled, boolean showSciteTab, boolean showUserCommentsFields, double previewWidthDividerPosition) {
        this.entryEditorTabList = new SimpleMapProperty(FXCollections.observableMap(entryEditorTabList));
        this.defaultEntryEditorTabList = new SimpleMapProperty(FXCollections.observableMap(defaultEntryEditorTabList));
        this.shouldOpenOnNewEntry = new SimpleBooleanProperty(shouldOpenOnNewEntry);
        this.shouldShowRecommendationsTab = new SimpleBooleanProperty(shouldShowRecommendationsTab);
        this.shouldShowLatexCitationsTab = new SimpleBooleanProperty(shouldShowLatexCitationsTab);
        this.showSourceTabByDefault = new SimpleBooleanProperty(showSourceTabByDefault);
        this.enableValidation = new SimpleBooleanProperty(enableValidation);
        this.allowIntegerEditionBibtex = new SimpleBooleanProperty(allowIntegerEditionBibtex);
        this.dividerPosition = new SimpleDoubleProperty(dividerPosition);
        this.autoLinkFiles = new SimpleBooleanProperty(autolinkFilesEnabled);
        this.enablementStatus = new SimpleObjectProperty((Object)journalPopupEnabled);
        this.shouldShowSciteTab = new SimpleBooleanProperty(showSciteTab);
        this.showUserCommentsFields = new SimpleBooleanProperty(showUserCommentsFields);
        this.previewWidthDividerPosition = new SimpleDoubleProperty(previewWidthDividerPosition);
    }

    public ObservableMap<String, Set<Field>> getEntryEditorTabs() {
        return (ObservableMap)this.entryEditorTabList.get();
    }

    public MapProperty<String, Set<Field>> entryEditorTabs() {
        return this.entryEditorTabList;
    }

    public void setEntryEditorTabList(Map<String, Set<Field>> entryEditorTabList) {
        this.entryEditorTabList.set((Object)FXCollections.observableMap(entryEditorTabList));
    }

    public ObservableMap<String, Set<Field>> getDefaultEntryEditorTabs() {
        return (ObservableMap)this.defaultEntryEditorTabList.get();
    }

    public boolean shouldOpenOnNewEntry() {
        return this.shouldOpenOnNewEntry.get();
    }

    public BooleanProperty shouldOpenOnNewEntryProperty() {
        return this.shouldOpenOnNewEntry;
    }

    public void setShouldOpenOnNewEntry(boolean shouldOpenOnNewEntry) {
        this.shouldOpenOnNewEntry.set(shouldOpenOnNewEntry);
    }

    public boolean shouldShowRecommendationsTab() {
        return this.shouldShowRecommendationsTab.get();
    }

    public BooleanProperty shouldShowRecommendationsTabProperty() {
        return this.shouldShowRecommendationsTab;
    }

    public void setShouldShowRecommendationsTab(boolean shouldShowRecommendationsTab) {
        this.shouldShowRecommendationsTab.set(shouldShowRecommendationsTab);
    }

    public boolean shouldShowLatexCitationsTab() {
        return this.shouldShowLatexCitationsTab.get();
    }

    public BooleanProperty shouldShowLatexCitationsTabProperty() {
        return this.shouldShowLatexCitationsTab;
    }

    public void setShouldShowLatexCitationsTab(boolean shouldShowLatexCitationsTab) {
        this.shouldShowLatexCitationsTab.set(shouldShowLatexCitationsTab);
    }

    public boolean showSourceTabByDefault() {
        return this.showSourceTabByDefault.get();
    }

    public BooleanProperty showSourceTabByDefaultProperty() {
        return this.showSourceTabByDefault;
    }

    public void setShowSourceTabByDefault(boolean showSourceTabByDefault) {
        this.showSourceTabByDefault.set(showSourceTabByDefault);
    }

    public boolean shouldEnableValidation() {
        return this.enableValidation.get();
    }

    public BooleanProperty enableValidationProperty() {
        return this.enableValidation;
    }

    public void setEnableValidation(boolean enableValidation) {
        this.enableValidation.set(enableValidation);
    }

    public boolean shouldAllowIntegerEditionBibtex() {
        return this.allowIntegerEditionBibtex.get();
    }

    public BooleanProperty allowIntegerEditionBibtexProperty() {
        return this.allowIntegerEditionBibtex;
    }

    public void setAllowIntegerEditionBibtex(boolean allowIntegerEditionBibtex) {
        this.allowIntegerEditionBibtex.set(allowIntegerEditionBibtex);
    }

    public double getDividerPosition() {
        return this.dividerPosition.get();
    }

    public DoubleProperty dividerPositionProperty() {
        return this.dividerPosition;
    }

    public void setDividerPosition(double dividerPosition) {
        this.dividerPosition.set(dividerPosition);
    }

    public boolean autoLinkFilesEnabled() {
        return this.autoLinkFiles.getValue();
    }

    public BooleanProperty autoLinkEnabledProperty() {
        return this.autoLinkFiles;
    }

    public void setAutoLinkFilesEnabled(boolean enabled) {
        this.autoLinkFiles.setValue(Boolean.valueOf(enabled));
    }

    public JournalPopupEnabled shouldEnableJournalPopup() {
        return (JournalPopupEnabled)((Object)this.enablementStatus.get());
    }

    public ObjectProperty<JournalPopupEnabled> enableJournalPopupProperty() {
        return this.enablementStatus;
    }

    public void setEnableJournalPopup(JournalPopupEnabled journalPopupEnabled) {
        this.enablementStatus.set((Object)journalPopupEnabled);
    }

    public boolean shouldShowSciteTab() {
        return this.shouldShowSciteTab.get();
    }

    public BooleanProperty shouldShowLSciteTabProperty() {
        return this.shouldShowSciteTab;
    }

    public void setShouldShowSciteTab(boolean shouldShowSciteTab) {
        this.shouldShowSciteTab.set(shouldShowSciteTab);
    }

    public boolean shouldShowUserCommentsFields() {
        return this.showUserCommentsFields.get();
    }

    public BooleanProperty showUserCommentsFieldsProperty() {
        return this.showUserCommentsFields;
    }

    public void setShowUserCommentsFields(boolean showUserCommentsFields) {
        this.showUserCommentsFields.set(showUserCommentsFields);
    }

    public void setPreviewWidthDividerPosition(double previewWidthDividerPosition) {
        this.previewWidthDividerPosition.set(previewWidthDividerPosition);
    }

    public DoubleProperty previewWidthDividerPositionProperty() {
        return this.previewWidthDividerPosition;
    }

    public Double getPreviewWidthDividerPosition() {
        return this.previewWidthDividerPosition.get();
    }

    public static enum JournalPopupEnabled {
        FIRST_START,
        ENABLED,
        DISABLED;


        public static JournalPopupEnabled fromString(String status) {
            for (JournalPopupEnabled value : JournalPopupEnabled.values()) {
                if (!value.toString().equalsIgnoreCase(status)) continue;
                return value;
            }
            throw new IllegalArgumentException("No enum found with value: " + status);
        }
    }
}

