/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.entryeditor;

import java.util.LinkedHashSet;
import java.util.Optional;
import java.util.SequencedSet;
import javafx.scene.control.Tooltip;
import javax.swing.undo.UndoManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.autocompleter.SuggestionProviders;
import org.jabref.gui.entryeditor.FieldsEditorTab;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.theme.ThemeManager;
import org.jabref.gui.undo.RedoAction;
import org.jabref.gui.undo.UndoAction;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.pdf.search.IndexingTaskManager;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibEntryType;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.entry.field.Field;
import org.jabref.preferences.PreferencesService;

public class OptionalFieldsTabBase
extends FieldsEditorTab {
    private final BibEntryTypesManager entryTypesManager;
    private final boolean isImportantOptionalFields;

    public OptionalFieldsTabBase(String title, boolean isImportantOptionalFields, BibDatabaseContext databaseContext, SuggestionProviders suggestionProviders, UndoManager undoManager, UndoAction undoAction, RedoAction redoAction, DialogService dialogService, PreferencesService preferences, StateManager stateManager, ThemeManager themeManager, IndexingTaskManager indexingTaskManager, BibEntryTypesManager entryTypesManager, TaskExecutor taskExecutor, JournalAbbreviationRepository journalAbbreviationRepository) {
        super(true, databaseContext, suggestionProviders, undoManager, undoAction, redoAction, dialogService, preferences, stateManager, themeManager, taskExecutor, journalAbbreviationRepository, indexingTaskManager);
        this.entryTypesManager = entryTypesManager;
        this.isImportantOptionalFields = isImportantOptionalFields;
        this.setText(title);
        this.setTooltip(new Tooltip(Localization.lang("Show optional fields", new Object[0])));
        this.setGraphic(IconTheme.JabRefIcons.OPTIONAL.getGraphicNode());
    }

    @Override
    protected SequencedSet<Field> determineFieldsToShow(BibEntry entry) {
        BibDatabaseMode mode = this.databaseContext.getMode();
        Optional<BibEntryType> entryType = this.entryTypesManager.enrich(entry.getType(), mode);
        if (entryType.isPresent()) {
            if (this.isImportantOptionalFields) {
                return entryType.get().getImportantOptionalFields();
            }
            return entryType.get().getDetailOptionalNotDeprecatedFields(mode);
        }
        return new LinkedHashSet<Field>();
    }
}

