/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.entryeditor;

import java.io.IOException;
import java.util.Collection;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.ProgressIndicator;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tooltip;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Font;
import javafx.scene.text.FontPosture;
import javafx.scene.text.Text;
import org.jabref.gui.DialogService;
import org.jabref.gui.desktop.JabRefDesktop;
import org.jabref.gui.entryeditor.EntryEditorPreferences;
import org.jabref.gui.entryeditor.EntryEditorTab;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.importer.ImportCleanup;
import org.jabref.logic.importer.fetcher.MrDLibFetcher;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.BuildInfo;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.StandardField;
import org.jabref.preferences.MrDlibPreferences;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelatedArticlesTab
extends EntryEditorTab {
    public static final String NAME = "Related articles";
    private static final Logger LOGGER = LoggerFactory.getLogger(RelatedArticlesTab.class);
    private final DialogService dialogService;
    private final BuildInfo buildInfo;
    private final TaskExecutor taskExecutor;
    private final BibDatabaseContext databaseContext;
    private final PreferencesService preferencesService;

    public RelatedArticlesTab(BuildInfo buildInfo, BibDatabaseContext databaseContext, PreferencesService preferencesService, DialogService dialogService, TaskExecutor taskExecutor) {
        this.databaseContext = databaseContext;
        this.dialogService = dialogService;
        this.buildInfo = buildInfo;
        this.taskExecutor = taskExecutor;
        this.preferencesService = preferencesService;
        this.setText(Localization.lang(NAME, new Object[0]));
        this.setTooltip(new Tooltip(Localization.lang(NAME, new Object[0])));
    }

    private StackPane getRelatedArticlesPane(BibEntry entry) {
        StackPane root = new StackPane();
        root.setId("related-articles-tab");
        ProgressIndicator progress = new ProgressIndicator();
        progress.setMaxSize(100.0, 100.0);
        MrDLibFetcher fetcher = new MrDLibFetcher(this.preferencesService.getWorkspacePreferences().getLanguage().name(), this.buildInfo.version, this.preferencesService.getMrDlibPreferences());
        BackgroundTask.wrap(() -> fetcher.performSearch(entry)).onRunning(() -> progress.setVisible(true)).onSuccess(relatedArticles -> {
            ImportCleanup cleanup = ImportCleanup.targeting(this.databaseContext.getMode(), this.preferencesService.getFieldPreferences());
            cleanup.doPostCleanup((Collection<BibEntry>)relatedArticles);
            progress.setVisible(false);
            root.getChildren().add((Object)this.getRelatedArticleInfo((List<BibEntry>)relatedArticles, fetcher));
        }).onFailure(exception -> {
            LOGGER.error("Error while fetching from Mr. DLib", (Throwable)exception);
            progress.setVisible(false);
            root.getChildren().add((Object)this.getErrorInfo());
        }).executeWith(this.taskExecutor);
        root.getChildren().add((Object)progress);
        return root;
    }

    private ScrollPane getRelatedArticleInfo(List<BibEntry> list, MrDLibFetcher fetcher) {
        ScrollPane scrollPane = new ScrollPane();
        VBox vBox = new VBox();
        vBox.setSpacing(20.0);
        String heading = fetcher.getHeading();
        Text headingText = new Text(heading);
        headingText.getStyleClass().add((Object)"heading");
        String description = fetcher.getDescription();
        Text descriptionText = new Text(description);
        descriptionText.getStyleClass().add((Object)"description");
        vBox.getChildren().add((Object)headingText);
        vBox.getChildren().add((Object)descriptionText);
        for (BibEntry entry : list) {
            HBox hBox = new HBox();
            hBox.setSpacing(5.0);
            hBox.getStyleClass().add((Object)"recommendation-item");
            String title = entry.getTitle().orElse("");
            String journal = entry.getField(StandardField.JOURNAL).orElse("");
            String authors = entry.getField(StandardField.AUTHOR).orElse("");
            String year = entry.getField(StandardField.YEAR).orElse("");
            Hyperlink titleLink = new Hyperlink(title);
            Text journalText = new Text(journal);
            journalText.setFont(Font.font((String)Font.getDefault().getFamily(), (FontPosture)FontPosture.ITALIC, (double)Font.getDefault().getSize()));
            Text authorsText = new Text(authors);
            Text yearText = new Text("(" + year + ")");
            titleLink.setOnAction(event -> {
                if (entry.getField(StandardField.URL).isPresent()) {
                    try {
                        JabRefDesktop.openBrowser(entry.getField(StandardField.URL).get(), this.preferencesService.getFilePreferences());
                    }
                    catch (IOException e) {
                        LOGGER.error("Error opening the browser to: " + entry.getField(StandardField.URL).get(), (Throwable)e);
                        this.dialogService.showErrorDialogAndWait(e);
                    }
                }
            });
            hBox.getChildren().addAll((Object[])new Node[]{titleLink, journalText, authorsText, yearText});
            vBox.getChildren().add((Object)hBox);
        }
        scrollPane.setContent((Node)vBox);
        return scrollPane;
    }

    private ScrollPane getErrorInfo() {
        ScrollPane scrollPane = new ScrollPane();
        VBox vBox = new VBox();
        vBox.setSpacing(20.0);
        Text descriptionText = new Text(Localization.lang("No recommendations received from Mr. DLib for this entry.", new Object[0]));
        descriptionText.getStyleClass().add((Object)"description");
        vBox.getChildren().add((Object)descriptionText);
        scrollPane.setContent((Node)vBox);
        return scrollPane;
    }

    private ScrollPane getPrivacyDialog(BibEntry entry) {
        ScrollPane root = new ScrollPane();
        root.setId("related-articles-tab");
        VBox vbox = new VBox();
        vbox.setId("gdpr-dialog");
        vbox.setSpacing(20.0);
        Text title = new Text(Localization.lang("Mr. DLib Privacy settings", new Object[0]));
        title.getStyleClass().add((Object)"heading");
        Button button = new Button(Localization.lang("I Agree", new Object[0]));
        button.setDefaultButton(true);
        DoubleBinding rootWidth = Bindings.subtract((ObservableNumberValue)root.widthProperty(), (double)88.0);
        Text line1 = new Text(Localization.lang("JabRef requests recommendations from Mr. DLib, which is an external service. To enable Mr. DLib to calculate recommendations, some of your data must be shared with Mr. DLib. Generally, the more data is shared the better recommendations can be calculated. However, we understand that some of your data in JabRef is sensitive, and you may not want to share it. Therefore, Mr. DLib offers a choice of which data you would like to share.", new Object[0]));
        line1.wrappingWidthProperty().bind((ObservableValue)rootWidth);
        Text line2 = new Text(Localization.lang("Whatever option you choose, Mr. DLib may share its data with research partners to further improve recommendation quality as part of a 'living lab'. Mr. DLib may also release public datasets that may contain anonymized information about you and the recommendations (sensitive information such as metadata of your articles will be anonymised through e.g. hashing). Research partners are obliged to adhere to the same strict data protection policy as Mr. DLib.", new Object[0]));
        line2.wrappingWidthProperty().bind((ObservableValue)rootWidth);
        Text line3 = new Text(Localization.lang("This setting may be changed in preferences at any time.", new Object[0]));
        line3.wrappingWidthProperty().bind((ObservableValue)rootWidth);
        Hyperlink mdlLink = new Hyperlink(Localization.lang("Further information about Mr. DLib for JabRef users.", new Object[0]));
        mdlLink.setOnAction(event -> {
            try {
                JabRefDesktop.openBrowser("http://mr-dlib.org/information-for-users/information-about-mr-dlib-for-jabref-users/", this.preferencesService.getFilePreferences());
            }
            catch (IOException e) {
                LOGGER.error("Error opening the browser to Mr. DLib information page.", (Throwable)e);
                this.dialogService.showErrorDialogAndWait(e);
            }
        });
        VBox vb = new VBox();
        CheckBox cbTitle = new CheckBox(Localization.lang("Entry Title (Required to deliver recommendations.)", new Object[0]));
        cbTitle.setSelected(true);
        cbTitle.setDisable(true);
        CheckBox cbVersion = new CheckBox(Localization.lang("JabRef Version (Required to ensure backwards compatibility with Mr. DLib's Web Service)", new Object[0]));
        cbVersion.setSelected(true);
        cbVersion.setDisable(true);
        CheckBox cbLanguage = new CheckBox(Localization.lang("JabRef Language (Provides for better recommendations by giving an indication of user's preferred language.)", new Object[0]));
        CheckBox cbOS = new CheckBox(Localization.lang("Operating System (Provides for better recommendations by giving an indication of user's system set-up.)", new Object[0]));
        CheckBox cbTimezone = new CheckBox(Localization.lang("Timezone (Provides for better recommendations by indicating the time of day the request is being made.)", new Object[0]));
        vb.getChildren().addAll((Object[])new Node[]{cbTitle, cbVersion, cbLanguage, cbOS, cbTimezone});
        vb.setSpacing(10.0);
        button.setOnAction(event -> {
            MrDlibPreferences mrDlibPreferences = this.preferencesService.getMrDlibPreferences();
            mrDlibPreferences.setAcceptRecommendations(true);
            mrDlibPreferences.setSendLanguage(cbLanguage.isSelected());
            mrDlibPreferences.setSendOs(cbOS.isSelected());
            mrDlibPreferences.setSendTimezone(cbTimezone.isSelected());
            this.dialogService.showWarningDialogAndWait(Localization.lang("Restart", new Object[0]), Localization.lang("Please restart JabRef for preferences to take effect.", new Object[0]));
            this.setContent((Node)this.getRelatedArticlesPane(entry));
        });
        vbox.getChildren().addAll((Object[])new Node[]{title, line1, line2, mdlLink, line3, vb, button});
        root.setContent((Node)vbox);
        return root;
    }

    @Override
    public boolean shouldShow(BibEntry entry) {
        EntryEditorPreferences entryEditorPreferences = this.preferencesService.getEntryEditorPreferences();
        return entryEditorPreferences.shouldShowRecommendationsTab();
    }

    @Override
    protected void bindToEntry(BibEntry entry) {
        if (this.preferencesService.getMrDlibPreferences().shouldAcceptRecommendations()) {
            this.setContent((Node)this.getRelatedArticlesPane(entry));
        } else {
            this.setContent((Node)this.getPrivacyDialog(entry));
        }
    }
}

