/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.entryeditor;

import de.saxsys.mvvmfx.utils.commands.Command;
import de.saxsys.mvvmfx.utils.validation.ObservableRuleBasedValidator;
import de.saxsys.mvvmfx.utils.validation.ValidationMessage;
import de.saxsys.mvvmfx.utils.validation.ValidationStatus;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.Tooltip;
import javafx.scene.input.InputMethodRequests;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.Region;
import javax.swing.undo.UndoManager;
import org.fxmisc.flowless.VirtualizedScrollPane;
import org.fxmisc.richtext.CodeArea;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionFactory;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.actions.StandardActions;
import org.jabref.gui.entryeditor.EntryEditorTab;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.keyboard.CodeAreaKeyBindings;
import org.jabref.gui.keyboard.KeyBindingRepository;
import org.jabref.gui.undo.CountingUndoManager;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.undo.UndoableChangeType;
import org.jabref.gui.undo.UndoableFieldChange;
import org.jabref.gui.util.UiTaskExecutor;
import org.jabref.logic.bibtex.BibEntryWriter;
import org.jabref.logic.bibtex.FieldPreferences;
import org.jabref.logic.bibtex.FieldWriter;
import org.jabref.logic.bibtex.InvalidFieldValueException;
import org.jabref.logic.exporter.BibWriter;
import org.jabref.logic.importer.ImportFormatPreferences;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.importer.fileformat.BibtexParser;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.search.SearchQuery;
import org.jabref.logic.util.OS;
import org.jabref.model.database.BibDatabase;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.database.BibDatabaseMode;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.entry.field.Field;
import org.jabref.model.util.FileUpdateMonitor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceTab
extends EntryEditorTab {
    private static final Logger LOGGER = LoggerFactory.getLogger(SourceTab.class);
    private final FieldPreferences fieldPreferences;
    private final BibDatabaseMode mode;
    private final UndoManager undoManager;
    private final ObjectProperty<ValidationMessage> sourceIsValid = new SimpleObjectProperty();
    private final ObservableRuleBasedValidator sourceValidator = new ObservableRuleBasedValidator();
    private final ImportFormatPreferences importFormatPreferences;
    private final FileUpdateMonitor fileMonitor;
    private final DialogService dialogService;
    private final BibEntryTypesManager entryTypesManager;
    private final KeyBindingRepository keyBindingRepository;
    private Optional<Pattern> searchHighlightPattern = Optional.empty();
    private CodeArea codeArea;
    private BibEntry previousEntry;

    public SourceTab(BibDatabaseContext bibDatabaseContext, CountingUndoManager undoManager, FieldPreferences fieldPreferences, ImportFormatPreferences importFormatPreferences, FileUpdateMonitor fileMonitor, DialogService dialogService, StateManager stateManager, BibEntryTypesManager entryTypesManager, KeyBindingRepository keyBindingRepository) {
        this.mode = bibDatabaseContext.getMode();
        this.setText(Localization.lang("%0 source", this.mode.getFormattedName()));
        this.setTooltip(new Tooltip(Localization.lang("Show/edit %0 source", this.mode.getFormattedName())));
        this.setGraphic(IconTheme.JabRefIcons.SOURCE.getGraphicNode());
        this.undoManager = undoManager;
        this.fieldPreferences = fieldPreferences;
        this.importFormatPreferences = importFormatPreferences;
        this.fileMonitor = fileMonitor;
        this.dialogService = dialogService;
        this.entryTypesManager = entryTypesManager;
        this.keyBindingRepository = keyBindingRepository;
        stateManager.activeSearchQueryProperty().addListener((observable, oldValue, newValue) -> {
            this.searchHighlightPattern = newValue.flatMap(SearchQuery::getPatternForWords);
            this.highlightSearchPattern();
        });
        stateManager.activeGlobalSearchQueryProperty().addListener((observable, oldValue, newValue) -> {
            this.searchHighlightPattern = newValue.flatMap(SearchQuery::getPatternForWords);
            this.highlightSearchPattern();
        });
    }

    private void highlightSearchPattern() {
        if (this.searchHighlightPattern.isPresent() && this.codeArea != null) {
            this.codeArea.setStyleClass(0, this.codeArea.getLength(), "text");
            Matcher matcher = this.searchHighlightPattern.get().matcher(this.codeArea.getText());
            while (matcher.find()) {
                for (int i = 0; i <= matcher.groupCount(); ++i) {
                    this.codeArea.setStyleClass(matcher.start(), matcher.end(), "search");
                }
            }
        }
    }

    private String getSourceString(BibEntry entry, BibDatabaseMode type, FieldPreferences fieldPreferences) throws IOException {
        StringWriter writer = new StringWriter();
        BibWriter bibWriter = new BibWriter(writer, OS.NEWLINE);
        FieldWriter fieldWriter = FieldWriter.buildIgnoreHashes(fieldPreferences);
        new BibEntryWriter(fieldWriter, this.entryTypesManager).write(entry, bibWriter, type);
        return writer.toString();
    }

    private void setupSourceEditor() {
        this.codeArea = new CodeArea();
        this.codeArea.setWrapText(true);
        this.codeArea.setInputMethodRequests((InputMethodRequests)new InputMethodRequestsObject());
        this.codeArea.setOnInputMethodTextChanged(event -> {
            String committed = event.getCommitted();
            if (!committed.isEmpty()) {
                this.codeArea.insertText(this.codeArea.getCaretPosition(), committed);
            }
        });
        this.codeArea.setId("bibtexSourceCodeArea");
        this.codeArea.addEventFilter(KeyEvent.KEY_PRESSED, event -> CodeAreaKeyBindings.call(this.codeArea, event, this.keyBindingRepository));
        this.codeArea.addEventFilter(KeyEvent.KEY_PRESSED, this::listenForSaveKeybinding);
        ActionFactory factory = new ActionFactory();
        ContextMenu contextMenu = new ContextMenu();
        contextMenu.getItems().addAll((Object[])new MenuItem[]{factory.createMenuItem(StandardActions.CUT, (Command)new EditAction(StandardActions.CUT)), factory.createMenuItem(StandardActions.COPY, (Command)new EditAction(StandardActions.COPY)), factory.createMenuItem(StandardActions.PASTE, (Command)new EditAction(StandardActions.PASTE)), factory.createMenuItem(StandardActions.SELECT_ALL, (Command)new EditAction(StandardActions.SELECT_ALL))});
        contextMenu.getStyleClass().add((Object)"context-menu");
        this.codeArea.setContextMenu(contextMenu);
        this.sourceValidator.addRule(this.sourceIsValid);
        this.sourceValidator.getValidationStatus().getMessages().addListener(c -> {
            ValidationStatus sourceValidationStatus = this.sourceValidator.getValidationStatus();
            if (!sourceValidationStatus.isValid()) {
                sourceValidationStatus.getHighestMessage().ifPresent(message -> {
                    String content = Localization.lang("User input via entry-editor in `{}bibtex source` tab led to failure.", new Object[0]) + "\n" + Localization.lang("Please check your library file for wrong syntax.", new Object[0]) + "\n\n" + message.getMessage();
                    this.dialogService.showWarningDialogAndWait(Localization.lang("SourceTab error", new Object[0]), content);
                });
            }
        });
        this.codeArea.focusedProperty().addListener((obs, oldValue, onFocus) -> {
            if (!onFocus.booleanValue() && this.currentEntry != null) {
                this.storeSource(this.currentEntry, (String)this.codeArea.textProperty().getValue());
            }
        });
        VirtualizedScrollPane scrollableCodeArea = new VirtualizedScrollPane((Region)this.codeArea);
        this.setContent((Node)scrollableCodeArea);
    }

    @Override
    public boolean shouldShow(BibEntry entry) {
        return true;
    }

    private void updateCodeArea() {
        UiTaskExecutor.runAndWaitInJavaFXThread(() -> {
            if (this.codeArea == null) {
                this.setupSourceEditor();
            }
            this.codeArea.clear();
            try {
                this.codeArea.appendText(this.getSourceString(this.currentEntry, this.mode, this.fieldPreferences));
                this.codeArea.setEditable(true);
                this.highlightSearchPattern();
            }
            catch (IOException ex) {
                this.codeArea.setEditable(false);
                this.codeArea.appendText(ex.getMessage() + "\n\n" + Localization.lang("Correct the entry, and reopen editor to display/edit source.", new Object[0]));
                LOGGER.debug("Incorrect entry", (Throwable)ex);
            }
        });
    }

    @Override
    protected void bindToEntry(BibEntry entry) {
        if (this.previousEntry != null && this.codeArea != null) {
            this.storeSource(this.previousEntry, (String)this.codeArea.textProperty().getValue());
        }
        this.previousEntry = entry;
        this.updateCodeArea();
        entry.typeProperty().addListener(listener -> this.updateCodeArea());
        entry.getFieldsObservable().addListener(listener -> this.updateCodeArea());
    }

    private void storeSource(BibEntry outOfFocusEntry, String text) {
        if (outOfFocusEntry == null || text.isEmpty()) {
            return;
        }
        BibtexParser bibtexParser = new BibtexParser(this.importFormatPreferences, this.fileMonitor);
        try {
            Field fieldName;
            ParserResult parserResult = bibtexParser.parse(new StringReader(text));
            BibDatabase database = parserResult.getDatabase();
            if (database.getEntryCount() > 1) {
                throw new IllegalStateException("More than one entry found.");
            }
            if (!database.hasEntries()) {
                if (parserResult.hasWarnings()) {
                    throw new IllegalStateException(parserResult.warnings().getFirst());
                }
                throw new IllegalStateException("No entries found.");
            }
            if (parserResult.hasWarnings()) {
                throw new IllegalStateException(parserResult.getErrorMessage());
            }
            NamedCompound compound = new NamedCompound(Localization.lang("source edit", new Object[0]));
            BibEntry newEntry = (BibEntry)database.getEntries().getFirst();
            String newKey = newEntry.getCitationKey().orElse(null);
            if (newKey != null) {
                outOfFocusEntry.setCitationKey(newKey);
            } else {
                outOfFocusEntry.clearCiteKey();
            }
            for (Map.Entry<Field, String> field : outOfFocusEntry.getFieldMap().entrySet()) {
                fieldName = field.getKey();
                String fieldValue = field.getValue();
                if (newEntry.hasField(fieldName)) continue;
                compound.addEdit(new UndoableFieldChange(outOfFocusEntry, fieldName, fieldValue, null));
                outOfFocusEntry.clearField(fieldName);
            }
            for (Map.Entry<Field, String> field : newEntry.getFieldMap().entrySet()) {
                String newValue;
                fieldName = field.getKey();
                String oldValue = outOfFocusEntry.getField(fieldName).orElse(null);
                if (Objects.equals(oldValue, newValue = field.getValue())) continue;
                new FieldWriter(this.fieldPreferences).write(fieldName, newValue);
                compound.addEdit(new UndoableFieldChange(outOfFocusEntry, fieldName, oldValue, newValue));
                outOfFocusEntry.setField(fieldName, newValue);
            }
            if (!Objects.equals(newEntry.getType(), outOfFocusEntry.getType())) {
                compound.addEdit(new UndoableChangeType(outOfFocusEntry, outOfFocusEntry.getType(), newEntry.getType()));
                outOfFocusEntry.setType(newEntry.getType());
            }
            compound.end();
            this.undoManager.addEdit(compound);
            this.sourceIsValid.setValue(null);
        }
        catch (IOException | IllegalStateException | InvalidFieldValueException ex) {
            this.sourceIsValid.setValue((Object)ValidationMessage.error((String)(Localization.lang("Problem with parsing entry", new Object[0]) + ": " + ex.getMessage())));
            LOGGER.debug("Incorrect source", (Throwable)ex);
        }
    }

    private void listenForSaveKeybinding(KeyEvent event) {
        this.keyBindingRepository.mapToKeyBinding(event).ifPresent(binding -> {
            switch (binding) {
                case SAVE_DATABASE: 
                case SAVE_ALL: 
                case SAVE_DATABASE_AS: {
                    this.storeSource(this.currentEntry, (String)this.codeArea.textProperty().getValue());
                }
            }
        });
    }

    private static class InputMethodRequestsObject
    implements InputMethodRequests {
        private InputMethodRequestsObject() {
        }

        public String getSelectedText() {
            return "";
        }

        public int getLocationOffset(int x, int y) {
            return 0;
        }

        public void cancelLatestCommittedText() {
        }

        public Point2D getTextLocation(int offset) {
            return new Point2D(0.0, 0.0);
        }
    }

    private class EditAction
    extends SimpleCommand {
        private final StandardActions command;

        public EditAction(StandardActions command) {
            this.command = command;
        }

        public void execute() {
            switch (this.command) {
                case COPY: {
                    SourceTab.this.codeArea.copy();
                    break;
                }
                case CUT: {
                    SourceTab.this.codeArea.cut();
                    break;
                }
                case PASTE: {
                    SourceTab.this.codeArea.paste();
                    break;
                }
                case SELECT_ALL: {
                    SourceTab.this.codeArea.selectAll();
                }
            }
            SourceTab.this.codeArea.requestFocus();
        }
    }
}

