/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.entryeditor.fileannotationtab;

import com.airhacks.afterburner.views.ViewLoader;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Tooltip;
import org.jabref.gui.entryeditor.EntryEditorTab;
import org.jabref.gui.entryeditor.fileannotationtab.FileAnnotationTabView;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.pdf.FileAnnotationCache;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.StandardField;

public class FileAnnotationTab
extends EntryEditorTab {
    public static final String NAME = "File annotations";
    private final FileAnnotationCache fileAnnotationCache;

    public FileAnnotationTab(FileAnnotationCache cache) {
        this.fileAnnotationCache = cache;
        this.setText(Localization.lang(NAME, new Object[0]));
        this.setTooltip(new Tooltip(Localization.lang("Show file annotations", new Object[0])));
    }

    @Override
    public boolean shouldShow(BibEntry entry) {
        return entry.getField(StandardField.FILE).isPresent();
    }

    @Override
    protected void bindToEntry(BibEntry entry) {
        Parent content = ViewLoader.view((Object)new FileAnnotationTabView(entry, this.fileAnnotationCache)).load().getView();
        this.setContent((Node)content);
    }
}

