/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.exporter;

import java.nio.file.Path;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import org.jabref.gui.AbstractViewModel;
import org.jabref.gui.DialogService;
import org.jabref.gui.exporter.ExporterViewModel;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.logic.exporter.TemplateExporter;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.FileType;
import org.jabref.logic.util.StandardFileType;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateModifyExporterDialogViewModel
extends AbstractViewModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateModifyExporterDialogViewModel.class);
    private final DialogService dialogService;
    private final PreferencesService preferences;
    private final StringProperty name = new SimpleStringProperty("");
    private final StringProperty layoutFile = new SimpleStringProperty("");
    private final StringProperty extension = new SimpleStringProperty("");

    public CreateModifyExporterDialogViewModel(ExporterViewModel exporter, DialogService dialogService, PreferencesService preferences) {
        this.dialogService = dialogService;
        this.preferences = preferences;
        if (exporter != null) {
            this.name.setValue((String)exporter.name().get());
            this.layoutFile.setValue((String)exporter.layoutFileName().get());
            this.extension.setValue((String)exporter.extension().get());
        }
    }

    public ExporterViewModel saveExporter() {
        Path layoutFileDir = Path.of((String)this.layoutFile.get(), new String[0]).getParent();
        if (layoutFileDir != null) {
            this.preferences.getExportPreferences().setExportWorkingDirectory(layoutFileDir);
        }
        if (((String)this.layoutFile.get()).isEmpty() || ((String)this.name.get()).isEmpty() || ((String)this.extension.get()).isEmpty() || !((String)this.layoutFile.get()).endsWith(".layout")) {
            LOGGER.info("One of the fields is empty or invalid.");
            return null;
        }
        TemplateExporter format = new TemplateExporter((String)this.name.get(), (String)this.layoutFile.get(), (String)this.extension.get(), this.preferences.getLayoutFormatterPreferences(), this.preferences.getSelfContainedExportConfiguration().getSelfContainedSaveOrder());
        format.setCustomExport(true);
        return new ExporterViewModel(format);
    }

    public void browse() {
        FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().addExtensionFilter(Localization.lang("Custom layout file", new Object[0]), (FileType)StandardFileType.LAYOUT).withDefaultExtension(Localization.lang("Custom layout file", new Object[0]), StandardFileType.LAYOUT).withInitialDirectory(this.preferences.getExportPreferences().getExportWorkingDirectory()).build();
        this.dialogService.showFileOpenDialog(fileDialogConfiguration).ifPresent(f -> this.layoutFile.set((Object)f.toAbsolutePath().toString()));
    }

    public StringProperty getName() {
        return this.name;
    }

    public StringProperty getLayoutFileName() {
        return this.layoutFile;
    }

    public StringProperty getExtension() {
        return this.extension;
    }
}

