/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.function.Supplier;
import javafx.fxml.Initializable;
import javafx.scene.Node;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.MenuItem;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputControl;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import org.jabref.gui.ClipBoardManager;
import org.jabref.gui.fieldeditors.ContextMenuAddable;
import org.jabref.gui.fieldeditors.contextmenu.EditorContextAction;
import org.jabref.gui.keyboard.KeyBindingRepository;

public class EditorTextField
extends TextField
implements Initializable,
ContextMenuAddable {
    private final ContextMenu contextMenu = new ContextMenu();

    public EditorTextField() {
        this("");
    }

    public EditorTextField(String text) {
        super(text);
        this.setPrefHeight(Double.POSITIVE_INFINITY);
        HBox.setHgrow((Node)this, (Priority)Priority.ALWAYS);
        ClipBoardManager.addX11Support((TextInputControl)this);
    }

    @Override
    public void initContextMenu(Supplier<List<MenuItem>> items, KeyBindingRepository keyBindingRepository) {
        this.setOnContextMenuRequested(event -> {
            this.contextMenu.getItems().setAll(EditorContextAction.getDefaultContextMenuItems((TextInputControl)this));
            this.contextMenu.getItems().addAll(0, (Collection)items.get());
            this.contextMenu.show((Node)this, event.getScreenX(), event.getScreenY());
        });
    }

    public void initialize(URL location, ResourceBundle resources) {
    }
}

