/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.control.Label;
import javafx.scene.control.Tooltip;
import javafx.stage.Screen;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.InternalField;
import org.jabref.model.entry.field.SpecialField;
import org.jabref.model.entry.field.StandardField;
import org.jabref.model.strings.StringUtil;

public class FieldNameLabel
extends Label {
    public FieldNameLabel(Field field) {
        super(field.getDisplayName());
        this.setPadding(new Insets(4.0, 0.0, 0.0, 0.0));
        this.setAlignment(Pos.CENTER);
        this.setPrefHeight(Double.POSITIVE_INFINITY);
        String description = this.getDescription(field);
        if (StringUtil.isNotBlank(description)) {
            Screen currentScreen = Screen.getPrimary();
            double maxWidth = currentScreen.getBounds().getWidth();
            Tooltip tooltip = new Tooltip(description);
            tooltip.setMaxWidth(maxWidth * 2.0 / 3.0);
            tooltip.setWrapText(true);
            this.setTooltip(tooltip);
        }
    }

    public String getDescription(Field field) {
        if (field.isStandardField()) {
            StandardField standardField = (StandardField)field;
            switch (standardField) {
                case ABSTRACT: {
                    return Localization.lang("This field is intended for recording abstracts, to be printed by a special bibliography style.", new Object[0]);
                }
                case ADDENDUM: {
                    return Localization.lang("Miscellaneous bibliographic data usually printed at the end of the entry.", new Object[0]);
                }
                case AFTERWORD: {
                    return Localization.lang("Author(s) of an afterword to the work.", new Object[0]);
                }
                case ANNOTATION: 
                case ANNOTE: {
                    return Localization.lang("This field may be useful when implementing a style for annotated bibliographies.", new Object[0]);
                }
                case ANNOTATOR: {
                    return Localization.lang("Author(s) of annotations to the work.", new Object[0]);
                }
                case AUTHOR: {
                    return Localization.lang("Author(s) of the work.", new Object[0]);
                }
                case BOOKSUBTITLE: {
                    return Localization.lang("Subtitle related to the \"Booktitle\".", new Object[0]);
                }
                case BOOKTITLE: {
                    return Localization.lang("Title of the main publication this work is part of.", new Object[0]);
                }
                case BOOKTITLEADDON: {
                    return Localization.lang("Annex to the \"Booktitle\", to be printed in a different font.", new Object[0]);
                }
                case CHAPTER: {
                    return Localization.lang("Chapter or section or any other unit of a work.", new Object[0]);
                }
                case COMMENT: {
                    return Localization.lang("Comment to this entry.", new Object[0]);
                }
                case COMMENTATOR: {
                    return Localization.lang("Author(s) of a commentary to the work.", new Object[0]) + "\n" + Localization.lang("Note that this field is intended for commented editions which have a commentator in addition to the author. If the work is a stand-alone commentary, the commentator should be given in the author field.", new Object[0]);
                }
                case DATE: {
                    return Localization.lang("Publication date of the work.", new Object[0]);
                }
                case DOI: {
                    return Localization.lang("Digital Object Identifier of the work.", new Object[0]);
                }
                case EDITION: {
                    return Localization.lang("Edition of a printed publication.", new Object[0]);
                }
                case EDITOR: {
                    return Localization.lang("Editor(s) of the work or the main publication, depending on the type of the entry.", new Object[0]);
                }
                case EDITORA: {
                    return Localization.lang("Secondary editor performing a different editorial role, such as compiling, redacting, etc.", new Object[0]);
                }
                case EDITORB: {
                    return Localization.lang("Another secondary editor performing a different role.", new Object[0]);
                }
                case EDITORC: {
                    return Localization.lang("Another secondary editor performing a different role.", new Object[0]);
                }
                case EDITORTYPE: {
                    return Localization.lang("Type of editorial role performed by the \"Editor\".", new Object[0]);
                }
                case EDITORATYPE: {
                    return Localization.lang("Type of editorial role performed by the \"Editora\".", new Object[0]);
                }
                case EDITORBTYPE: {
                    return Localization.lang("Type of editorial role performed by the \"Editorb\".", new Object[0]);
                }
                case EDITORCTYPE: {
                    return Localization.lang("Type of editorial role performed by the \"Editorc\".", new Object[0]);
                }
                case EID: {
                    return Localization.lang("Electronic identifier of a work.", new Object[0]) + "\n" + Localization.lang("This field may replace the pages field for journals deviating from the classic pagination scheme of printed journals by only enumerating articles or papers and not pages.", new Object[0]);
                }
                case EPRINT: {
                    return Localization.lang("Electronic identifier of an online publication.", new Object[0]) + "\n" + Localization.lang("This is roughly comparable to a DOI but specific to a certain archive, repository, service, or system.", new Object[0]);
                }
                case EPRINTCLASS: 
                case PRIMARYCLASS: {
                    return Localization.lang("Additional information related to the resource indicated by the eprint field.", new Object[0]) + "\n" + Localization.lang("This could be a section of an archive, a path indicating a service, a classification of some sort.", new Object[0]);
                }
                case EPRINTTYPE: 
                case ARCHIVEPREFIX: {
                    return Localization.lang("Type of the eprint identifier, e. g., the name of the archive, repository, service, or system the eprint field refers to.", new Object[0]);
                }
                case EVENTDATE: {
                    return Localization.lang("Date of a conference, a symposium, or some other event.", new Object[0]);
                }
                case EVENTTITLE: {
                    return Localization.lang("Title of a conference, a symposium, or some other event.", new Object[0]) + "\n" + Localization.lang("Note that this field holds the plain title of the event. Things like \"Proceedings of the Fifth XYZ Conference\" go into the titleaddon or booktitleaddon field.", new Object[0]);
                }
                case EVENTTITLEADDON: {
                    return Localization.lang("Annex to the eventtitle field.", new Object[0]) + "\n" + Localization.lang("Can be used for known event acronyms.", new Object[0]);
                }
                case FILE: 
                case PDF: {
                    return Localization.lang("Link(s) to a local PDF or other document of the work.", new Object[0]);
                }
                case FOREWORD: {
                    return Localization.lang("Author(s) of a foreword to the work.", new Object[0]);
                }
                case HOWPUBLISHED: {
                    return Localization.lang("Publication notice for unusual publications which do not fit into any of the common categories.", new Object[0]);
                }
                case INSTITUTION: 
                case SCHOOL: {
                    return Localization.lang("Name of a university or some other institution.", new Object[0]);
                }
                case INTRODUCTION: {
                    return Localization.lang("Author(s) of an introduction to the work.", new Object[0]);
                }
                case ISBN: {
                    return Localization.lang("International Standard Book Number of a book.", new Object[0]);
                }
                case ISRN: {
                    return Localization.lang("International Standard Technical Report Number of a technical report.", new Object[0]);
                }
                case ISSN: {
                    return Localization.lang("International Standard Serial Number of a periodical.", new Object[0]);
                }
                case ISSUE: {
                    return Localization.lang("Issue of a journal.", new Object[0]) + "\n" + Localization.lang("This field is intended for journals whose individual issues are identified by a designation such as \"Spring\" or \"Summer\" rather than the month or a number. Integer ranges and short designators are better written to the number field.", new Object[0]);
                }
                case ISSUESUBTITLE: {
                    return Localization.lang("Subtitle of a specific issue of a journal or other periodical.", new Object[0]);
                }
                case ISSUETITLE: {
                    return Localization.lang("Title of a specific issue of a journal or other periodical.", new Object[0]);
                }
                case JOURNALSUBTITLE: {
                    return Localization.lang("Subtitle of a journal, a newspaper, or some other periodical.", new Object[0]);
                }
                case JOURNALTITLE: 
                case JOURNAL: {
                    return Localization.lang("Name of a journal, a newspaper, or some other periodical.", new Object[0]);
                }
                case LABEL: {
                    return Localization.lang("Designation to be used by the citation style as a substitute for the regular label if any data required to generate the regular label is missing.", new Object[0]);
                }
                case LANGUAGE: {
                    return Localization.lang("Language(s) of the work. Languages may be specified literally or as localisation keys.", new Object[0]);
                }
                case LIBRARY: {
                    return Localization.lang("Information such as a library name and a call number.", new Object[0]);
                }
                case LOCATION: 
                case ADDRESS: {
                    return Localization.lang("Place(s) of publication, i. e., the location of the publisher or institution, depending on the entry type.", new Object[0]);
                }
                case MAINSUBTITLE: {
                    return Localization.lang("Subtitle related to the \"Maintitle\".", new Object[0]);
                }
                case MAINTITLE: {
                    return Localization.lang("Main title of a multi-volume book, such as \"Collected Works\".", new Object[0]);
                }
                case MAINTITLEADDON: {
                    return Localization.lang("Annex to the \"Maintitle\", to be printed in a different font.", new Object[0]);
                }
                case MONTH: {
                    return Localization.lang("Publication month.", new Object[0]);
                }
                case NAMEADDON: {
                    return Localization.lang("Addon to be printed immediately after the author name in the bibliography.", new Object[0]);
                }
                case NOTE: {
                    return Localization.lang("Miscellaneous bibliographic data which does not fit into any other field.", new Object[0]);
                }
                case NUMBER: {
                    return Localization.lang("Number of a journal or the volume/number of a book in a series.", new Object[0]);
                }
                case ORGANIZATION: {
                    return Localization.lang("Organization(s) that published a manual or an online resource, or sponsored a conference.", new Object[0]);
                }
                case ORIGDATE: {
                    return Localization.lang("If the work is a translation, a reprint, or something similar, the publication date of the original edition.", new Object[0]);
                }
                case ORIGLANGUAGE: {
                    return Localization.lang("If the work is a translation, the language(s) of the original work.", new Object[0]);
                }
                case PAGES: {
                    return Localization.lang("One or more page numbers or page ranges.", new Object[0]) + "\n" + Localization.lang("If the work is published as part of another one, such as an article in a journal or a collection, this field holds the relevant page range in that other work. It may also be used to limit the reference to a specific part of a work (a chapter in a book, for example). For papers in electronic journals with anon-classical pagination setup the eid field may be more suitable.", new Object[0]);
                }
                case PAGETOTAL: {
                    return Localization.lang("Total number of pages of the work.", new Object[0]);
                }
                case PAGINATION: {
                    return Localization.lang("Pagination of the work. The key should be given in the singular form.", new Object[0]);
                }
                case PART: {
                    return Localization.lang("Number of a partial volume. This field applies to books only, not to journals. It may be used when a logical volume consists of two or more physical ones.", new Object[0]);
                }
                case PUBLISHER: {
                    return Localization.lang("Name(s) of the publisher(s).", new Object[0]);
                }
                case PUBSTATE: {
                    return Localization.lang("Publication state of the work, e. g., \"in press\".", new Object[0]);
                }
                case SERIES: {
                    return Localization.lang("Name of a publication series, such as \"Studies in...\", or the number of a journal series.", new Object[0]);
                }
                case SHORTTITLE: {
                    return Localization.lang("Title in an abridged form.", new Object[0]);
                }
                case SUBTITLE: {
                    return Localization.lang("Subtitle of the work.", new Object[0]);
                }
                case TITLE: {
                    return Localization.lang("Title of the work.", new Object[0]);
                }
                case TITLEADDON: {
                    return Localization.lang("Annex to the \"Title\", to be printed in a different font.", new Object[0]);
                }
                case TRANSLATOR: {
                    return Localization.lang("Translator(s) of the \"Title\" or \"Booktitle\", depending on the entry type. If the translator is identical to the \"Editor\", the standard styles will automatically concatenate these fields in the bibliography.", new Object[0]);
                }
                case TYPE: {
                    return Localization.lang("Type of a \"Manual\", \"Patent\", \"Report\", or \"Thesis\".", new Object[0]);
                }
                case URL: {
                    return Localization.lang("URL of an online publication.", new Object[0]);
                }
                case URLDATE: {
                    return Localization.lang("Access date of the address specified in the url field.", new Object[0]);
                }
                case VENUE: {
                    return Localization.lang("Location of a conference, a symposium, or some other event.", new Object[0]);
                }
                case VERSION: {
                    return Localization.lang("Revision number of a piece of software, a manual, etc.", new Object[0]);
                }
                case VOLUME: {
                    return Localization.lang("Volume of a multi-volume book or a periodical.", new Object[0]);
                }
                case VOLUMES: {
                    return Localization.lang("Total number of volumes of a multi-volume work.", new Object[0]);
                }
                case YEAR: {
                    return Localization.lang("Year of publication.", new Object[0]);
                }
                case CROSSREF: {
                    return Localization.lang("This field holds an entry key for the cross-referencing feature. Child entries with a \"Crossref\" field inherit data from the parent entry specified in the \"Crossref\" field.", new Object[0]);
                }
                case GENDER: {
                    return Localization.lang("Gender of the author or gender of the editor, if there is no author.", new Object[0]);
                }
                case KEYWORDS: {
                    return Localization.lang("Separated list of keywords.", new Object[0]);
                }
                case RELATED: {
                    return Localization.lang("Citation keys of other entries which have a relationship to this entry.", new Object[0]);
                }
                case XREF: {
                    return Localization.lang("This field is an alternative cross-referencing mechanism. It differs from \"Crossref\" in that the child entry will not inherit any data from the parent entry specified in the \"Xref\" field.", new Object[0]);
                }
                case GROUPS: {
                    return Localization.lang("Name(s) of the (manual) groups the entry belongs to.", new Object[0]);
                }
                case OWNER: {
                    return Localization.lang("Owner/creator of this entry.", new Object[0]);
                }
                case TIMESTAMP: {
                    return Localization.lang("Timestamp of this entry, when it has been created or last modified.", new Object[0]);
                }
            }
        } else if (field instanceof InternalField) {
            InternalField internalField = (InternalField)field;
            switch (internalField) {
                case KEY_FIELD: {
                    return Localization.lang("Key by which the work may be cited.", new Object[0]);
                }
            }
        } else if (field instanceof SpecialField) {
            SpecialField specialField = (SpecialField)field;
            switch (specialField) {
                case PRINTED: {
                    return Localization.lang("User-specific printed flag, in case the entry has been printed.", new Object[0]);
                }
                case PRIORITY: {
                    return Localization.lang("User-specific priority.", new Object[0]);
                }
                case QUALITY: {
                    return Localization.lang("User-specific quality flag, in case its quality is assured.", new Object[0]);
                }
                case RANKING: {
                    return Localization.lang("User-specific ranking.", new Object[0]);
                }
                case READ_STATUS: {
                    return Localization.lang("User-specific read status.", new Object[0]);
                }
                case RELEVANCE: {
                    return Localization.lang("User-specific relevance flag, in case the entry is relevant.", new Object[0]);
                }
            }
        }
        return "";
    }
}

