/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import javafx.scene.control.Button;
import javax.swing.undo.UndoManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.autocompleter.SuggestionProvider;
import org.jabref.gui.fieldeditors.AbstractEditorViewModel;
import org.jabref.gui.fieldeditors.PopOverUtil;
import org.jabref.gui.mergeentries.FetchAndMergeEntry;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.StandardField;
import org.jabref.preferences.PreferencesService;

public class ISSNEditorViewModel
extends AbstractEditorViewModel {
    private final TaskExecutor taskExecutor;
    private final DialogService dialogService;
    private final UndoManager undoManager;
    private final StateManager stateManager;
    private final PreferencesService preferencesService;

    public ISSNEditorViewModel(Field field, SuggestionProvider<?> suggestionProvider, FieldCheckers fieldCheckers, TaskExecutor taskExecutor, DialogService dialogService, UndoManager undoManager, StateManager stateManager, PreferencesService preferencesService) {
        super(field, suggestionProvider, fieldCheckers, undoManager);
        this.taskExecutor = taskExecutor;
        this.dialogService = dialogService;
        this.undoManager = undoManager;
        this.stateManager = stateManager;
        this.preferencesService = preferencesService;
    }

    public void showJournalInfo(Button journalInfoButton) {
        PopOverUtil.showJournalInfo(journalInfoButton, this.entry, this.dialogService, this.taskExecutor);
    }

    public void fetchBibliographyInformation(BibEntry bibEntry) {
        this.stateManager.getActiveDatabase().ifPresentOrElse(databaseContext -> new FetchAndMergeEntry((BibDatabaseContext)databaseContext, this.taskExecutor, this.preferencesService, this.dialogService, this.undoManager).fetchAndMerge(bibEntry, StandardField.ISSN), () -> this.dialogService.notify(Localization.lang("No library selected", new Object[0])));
    }
}

