/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import com.airhacks.afterburner.views.ViewLoader;
import com.dlsc.gemsfx.TagsField;
import de.saxsys.mvvmfx.utils.commands.Command;
import jakarta.inject.Inject;
import java.util.Comparator;
import javafx.beans.binding.Bindings;
import javafx.collections.ObservableList;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.ContextMenu;
import javafx.scene.control.Label;
import javafx.scene.control.MenuItem;
import javafx.scene.layout.HBox;
import javax.swing.undo.UndoManager;
import org.jabref.gui.ClipBoardManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.JabRefDialogService;
import org.jabref.gui.actions.ActionFactory;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.actions.StandardActions;
import org.jabref.gui.autocompleter.SuggestionProvider;
import org.jabref.gui.fieldeditors.FieldEditorFX;
import org.jabref.gui.fieldeditors.KeywordsEditorViewModel;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.util.ViewModelListCellFactory;
import org.jabref.logic.integrity.FieldCheckers;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.Keyword;
import org.jabref.model.entry.field.Field;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeywordsEditor
extends HBox
implements FieldEditorFX {
    private static final Logger LOGGER = LoggerFactory.getLogger(KeywordsEditor.class);
    @FXML
    private TagsField<Keyword> keywordTagsField;
    @Inject
    private PreferencesService preferencesService;
    @Inject
    private DialogService dialogService;
    @Inject
    private UndoManager undoManager;
    @Inject
    private ClipBoardManager clipBoardManager;
    private final KeywordsEditorViewModel viewModel;

    public KeywordsEditor(Field field, SuggestionProvider<?> suggestionProvider, FieldCheckers fieldCheckers) {
        ViewLoader.view((Object)this).root((Object)this).load();
        this.viewModel = new KeywordsEditorViewModel(field, suggestionProvider, fieldCheckers, this.preferencesService, this.undoManager);
        this.keywordTagsField.setCellFactory(new ViewModelListCellFactory().withText(Keyword::get));
        this.keywordTagsField.setTagViewFactory(this::createTag);
        this.keywordTagsField.setSuggestionProvider(request -> this.viewModel.getSuggestions(request.getUserText()));
        this.keywordTagsField.setConverter(this.viewModel.getStringConverter());
        this.keywordTagsField.setMatcher((keyword, searchText) -> keyword.get().toLowerCase().startsWith(searchText.toLowerCase()));
        this.keywordTagsField.setComparator(Comparator.comparing(Keyword::get));
        this.keywordTagsField.setNewItemProducer(searchText -> (Keyword)this.viewModel.getStringConverter().fromString(searchText));
        this.keywordTagsField.setShowSearchIcon(false);
        this.keywordTagsField.getEditor().getStyleClass().clear();
        this.keywordTagsField.getEditor().getStyleClass().add((Object)"tags-field-editor");
        String keywordSeparator = String.valueOf(this.viewModel.getKeywordSeparator());
        this.keywordTagsField.getEditor().setOnKeyReleased(event -> {
            if (event.getText().equals(keywordSeparator)) {
                this.keywordTagsField.commit();
                event.consume();
            }
        });
        Bindings.bindContentBidirectional((ObservableList)this.keywordTagsField.getTags(), this.viewModel.keywordListProperty());
    }

    private Node createTag(Keyword keyword) {
        Label tagLabel = new Label();
        tagLabel.setText(this.keywordTagsField.getConverter().toString((Object)keyword));
        tagLabel.setGraphic(IconTheme.JabRefIcons.REMOVE_TAGS.getGraphicNode());
        tagLabel.getGraphic().setOnMouseClicked(event -> this.keywordTagsField.removeTags((Object[])new Keyword[]{keyword}));
        tagLabel.setContentDisplay(ContentDisplay.RIGHT);
        ContextMenu contextMenu = new ContextMenu();
        ActionFactory factory = new ActionFactory();
        contextMenu.getItems().addAll((Object[])new MenuItem[]{factory.createMenuItem(StandardActions.COPY, (Command)new TagContextAction(StandardActions.COPY, keyword)), factory.createMenuItem(StandardActions.CUT, (Command)new TagContextAction(StandardActions.CUT, keyword)), factory.createMenuItem(StandardActions.DELETE, (Command)new TagContextAction(StandardActions.DELETE, keyword))});
        tagLabel.setContextMenu(contextMenu);
        return tagLabel;
    }

    public KeywordsEditorViewModel getViewModel() {
        return this.viewModel;
    }

    @Override
    public void bindToEntry(BibEntry entry) {
        this.viewModel.bindToEntry(entry);
    }

    @Override
    public Parent getNode() {
        return this;
    }

    public void requestFocus() {
        this.keywordTagsField.requestFocus();
    }

    @Override
    public double getWeight() {
        return 2.0;
    }

    private class TagContextAction
    extends SimpleCommand {
        private final StandardActions command;
        private final Keyword keyword;

        public TagContextAction(StandardActions command, Keyword keyword) {
            this.command = command;
            this.keyword = keyword;
        }

        public void execute() {
            switch (this.command) {
                case COPY: {
                    KeywordsEditor.this.clipBoardManager.setContent(this.keyword.get());
                    KeywordsEditor.this.dialogService.notify(Localization.lang("Copied '%0' to clipboard.", JabRefDialogService.shortenDialogMessage(this.keyword.get())));
                    break;
                }
                case CUT: {
                    KeywordsEditor.this.clipBoardManager.setContent(this.keyword.get());
                    KeywordsEditor.this.dialogService.notify(Localization.lang("Copied '%0' to clipboard.", JabRefDialogService.shortenDialogMessage(this.keyword.get())));
                    KeywordsEditor.this.keywordTagsField.removeTags((Object[])new Keyword[]{this.keyword});
                    break;
                }
                case DELETE: {
                    KeywordsEditor.this.keywordTagsField.removeTags((Object[])new Keyword[]{this.keyword});
                    break;
                }
                default: {
                    LOGGER.info("Action {} not defined", (Object)this.command.getText());
                }
            }
        }
    }
}

