/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.fieldeditors;

import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.Optional;
import org.jabref.gui.externalfiletype.ExternalFileTypes;
import org.jabref.preferences.FilePreferences;

public class URLUtil {
    private static final String URL_EXP = "^(https?|ftp)://.+";
    private static final String GOOGLE_SEARCH_EXP = "^https?://(?:www\\.)?google\\.[\\.a-z]+?/url.*";

    private URLUtil() {
    }

    public static String cleanGoogleSearchURL(String url) {
        Objects.requireNonNull(url);
        if (!url.matches(GOOGLE_SEARCH_EXP)) {
            return url;
        }
        try {
            String[] pairs;
            URL searchURL = new URL(url);
            String query = searchURL.getQuery();
            if (query == null) {
                return url;
            }
            for (String pair : pairs = query.split("&")) {
                String value;
                String decode;
                if (!pair.startsWith("url=") || !(decode = URLDecoder.decode(value = pair.substring(pair.indexOf(61) + 1), StandardCharsets.UTF_8)).matches(URL_EXP)) continue;
                return decode;
            }
            return url;
        }
        catch (MalformedURLException e) {
            return url;
        }
    }

    public static boolean isURL(String url) {
        try {
            new URL(url);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public static Optional<String> getSuffix(String link, FilePreferences filePreferences) {
        String strippedLink = link;
        try {
            URL url = new URL(link);
            if (url.getQuery() != null && url.getQuery().length() < link.length() - 1) {
                strippedLink = link.substring(0, link.length() - url.getQuery().length() - 1);
            }
        }
        catch (MalformedURLException url) {
            // empty catch block
        }
        int strippedLinkIndex = strippedLink.lastIndexOf(46);
        String suffix = strippedLinkIndex <= 0 || strippedLinkIndex == strippedLink.length() - 1 ? null : strippedLink.substring(strippedLinkIndex + 1);
        if (!ExternalFileTypes.isExternalFileTypeByExt(suffix, filePreferences)) {
            int index = link.lastIndexOf(46);
            if (index <= 0 || index == link.length() - 1) {
                if (strippedLink.substring(strippedLinkIndex + 1).indexOf(47) >= 1) {
                    return Optional.empty();
                }
                return Optional.of(suffix);
            }
            if (link.substring(index + 1).indexOf(47) >= 1) {
                return Optional.empty();
            }
            return Optional.of(link.substring(index + 1));
        }
        return Optional.ofNullable(suffix);
    }
}

