/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.journals;

import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javafx.beans.value.ObservableValue;
import javax.swing.undo.UndoManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTab;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionHelper;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.actions.StandardActions;
import org.jabref.gui.journals.AbbreviationType;
import org.jabref.gui.journals.UndoableAbbreviator;
import org.jabref.gui.journals.UndoableUnabbreviator;
import org.jabref.gui.undo.NamedCompound;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.journals.JournalAbbreviationPreferences;
import org.jabref.logic.journals.JournalAbbreviationRepository;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.HeadlessExecutorService;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbbreviateAction
extends SimpleCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbbreviateAction.class);
    private final StandardActions action;
    private final Supplier<LibraryTab> tabSupplier;
    private final DialogService dialogService;
    private final StateManager stateManager;
    private final JournalAbbreviationPreferences journalAbbreviationPreferences;
    private final JournalAbbreviationRepository abbreviationRepository;
    private final TaskExecutor taskExecutor;
    private final UndoManager undoManager;
    private AbbreviationType abbreviationType;

    public AbbreviateAction(StandardActions action, Supplier<LibraryTab> tabSupplier, DialogService dialogService, StateManager stateManager, JournalAbbreviationPreferences abbreviationPreferences, JournalAbbreviationRepository abbreviationRepository, TaskExecutor taskExecutor, UndoManager undoManager) {
        this.action = action;
        this.tabSupplier = tabSupplier;
        this.dialogService = dialogService;
        this.stateManager = stateManager;
        this.journalAbbreviationPreferences = abbreviationPreferences;
        this.abbreviationRepository = abbreviationRepository;
        this.taskExecutor = taskExecutor;
        this.undoManager = undoManager;
        switch (action) {
            case ABBREVIATE_DEFAULT: {
                this.abbreviationType = AbbreviationType.DEFAULT;
                break;
            }
            case ABBREVIATE_DOTLESS: {
                this.abbreviationType = AbbreviationType.DOTLESS;
                break;
            }
            case ABBREVIATE_SHORTEST_UNIQUE: {
                this.abbreviationType = AbbreviationType.SHORTEST_UNIQUE;
                break;
            }
            default: {
                LOGGER.debug("Unknown action: " + action.name());
            }
        }
        this.executable.bind((ObservableValue)ActionHelper.needsEntriesSelected(stateManager));
    }

    public void execute() {
        if (this.action == StandardActions.ABBREVIATE_DEFAULT || this.action == StandardActions.ABBREVIATE_DOTLESS || this.action == StandardActions.ABBREVIATE_SHORTEST_UNIQUE) {
            this.dialogService.notify(Localization.lang("Abbreviating...", new Object[0]));
            this.stateManager.getActiveDatabase().ifPresent(databaseContext -> BackgroundTask.wrap(() -> this.abbreviate(this.stateManager.getActiveDatabase().get(), (List<BibEntry>)this.stateManager.getSelectedEntries())).onSuccess(this.dialogService::notify).executeWith(this.taskExecutor));
        } else if (this.action == StandardActions.UNABBREVIATE) {
            this.dialogService.notify(Localization.lang("Unabbreviating...", new Object[0]));
            this.stateManager.getActiveDatabase().ifPresent(databaseContext -> BackgroundTask.wrap(() -> this.unabbreviate(this.stateManager.getActiveDatabase().get(), (List<BibEntry>)this.stateManager.getSelectedEntries())).onSuccess(this.dialogService::notify).executeWith(this.taskExecutor));
        } else {
            LOGGER.debug("Unknown action: " + this.action.name());
        }
    }

    private String abbreviate(BibDatabaseContext databaseContext, List<BibEntry> entries) {
        UndoableAbbreviator undoableAbbreviator = new UndoableAbbreviator(this.abbreviationRepository, this.abbreviationType, this.journalAbbreviationPreferences.shouldUseFJournalField());
        NamedCompound ce = new NamedCompound(Localization.lang("Abbreviate journal names", new Object[0]));
        Set tasks = entries.stream().map(entry -> () -> FieldFactory.getJournalNameFields().stream().anyMatch(journalField -> undoableAbbreviator.abbreviate(databaseContext.getDatabase(), (BibEntry)entry, (Field)journalField, ce))).collect(Collectors.toSet());
        List futures = HeadlessExecutorService.INSTANCE.executeAll(tasks);
        long count = futures.stream().filter(future -> {
            try {
                return (Boolean)future.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                LOGGER.error("Unable to retrieve value.", (Throwable)exception);
                return false;
            }
        }).count();
        if (count == 0L) {
            return Localization.lang("No journal names could be abbreviated.", new Object[0]);
        }
        ce.end();
        this.undoManager.addEdit(ce);
        this.tabSupplier.get().markBaseChanged();
        return Localization.lang("Abbreviated %0 journal names.", String.valueOf(count));
    }

    private String unabbreviate(BibDatabaseContext databaseContext, List<BibEntry> entries) {
        UndoableUnabbreviator undoableAbbreviator = new UndoableUnabbreviator(this.abbreviationRepository);
        NamedCompound ce = new NamedCompound(Localization.lang("Unabbreviate journal names", new Object[0]));
        int count = entries.stream().mapToInt(entry -> (int)FieldFactory.getJournalNameFields().stream().filter(journalField -> undoableAbbreviator.unabbreviate(databaseContext.getDatabase(), (BibEntry)entry, (Field)journalField, ce)).count()).sum();
        if (count == 0) {
            return Localization.lang("No journal names could be unabbreviated.", new Object[0]);
        }
        ce.end();
        this.undoManager.addEdit(ce);
        this.tabSupplier.get().markBaseChanged();
        return Localization.lang("Unabbreviated %0 journal names.", String.valueOf(count));
    }
}

