/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.keyboard;

import org.jabref.gui.keyboard.KeyBindingCategory;
import org.jabref.logic.l10n.Localization;

public enum KeyBinding {
    EDITOR_DELETE("Delete", Localization.lang("Delete text", new Object[0]), "", KeyBindingCategory.EDITOR),
    EDITOR_BACKWARD("Move caret left", Localization.lang("Move caret left", new Object[0]), "", KeyBindingCategory.EDITOR),
    EDITOR_FORWARD("Move caret right", Localization.lang("Move caret right", new Object[0]), "", KeyBindingCategory.EDITOR),
    EDITOR_WORD_BACKWARD("Move caret to previous word", Localization.lang("Move caret to previous word", new Object[0]), "", KeyBindingCategory.EDITOR),
    EDITOR_WORD_FORWARD("Move caret to next word", Localization.lang("Move caret to next word", new Object[0]), "", KeyBindingCategory.EDITOR),
    EDITOR_BEGINNING("Move caret to beginning of line", Localization.lang("Move caret to beginning of line", new Object[0]), "", KeyBindingCategory.EDITOR),
    EDITOR_END("Move caret to  of line", Localization.lang("Move caret to end of line", new Object[0]), "", KeyBindingCategory.EDITOR),
    EDITOR_BEGINNING_DOC("Move caret to beginning of text", Localization.lang("Move the caret to the beginning of text", new Object[0]), "", KeyBindingCategory.EDITOR),
    EDITOR_END_DOC("Move caret to end of text", Localization.lang("Move the caret to the end of text", new Object[0]), "", KeyBindingCategory.EDITOR),
    EDITOR_UP("Move caret up", Localization.lang("Move the caret up", new Object[0]), "", KeyBindingCategory.EDITOR),
    EDITOR_DOWN("Move caret down", Localization.lang("Move the caret down", new Object[0]), "", KeyBindingCategory.EDITOR),
    EDITOR_CAPITALIZE("Capitalize word", Localization.lang("Capitalize current word", new Object[0]), "", KeyBindingCategory.EDITOR),
    EDITOR_LOWERCASE("Lowercase word", Localization.lang("Make current word lowercase", new Object[0]), "", KeyBindingCategory.EDITOR),
    EDITOR_UPPERCASE("Uppercase word", Localization.lang("Make current word uppercase", new Object[0]), "", KeyBindingCategory.EDITOR),
    EDITOR_KILL_LINE("Remove all characters caret to end of line", Localization.lang("Remove line after caret", new Object[0]), "", KeyBindingCategory.EDITOR),
    EDITOR_KILL_WORD("Remove characters until next word", Localization.lang("Remove characters until next word", new Object[0]), "", KeyBindingCategory.EDITOR),
    EDITOR_KILL_WORD_BACKWARD("Characters until previous word", Localization.lang("Remove the current word backwards", new Object[0]), "", KeyBindingCategory.EDITOR),
    ABBREVIATE("Abbreviate", Localization.lang("Abbreviate journal names", new Object[0]), "ctrl+alt+A", KeyBindingCategory.TOOLS),
    AUTOGENERATE_CITATION_KEYS("Autogenerate citation keys", Localization.lang("Autogenerate citation keys", new Object[0]), "ctrl+G", KeyBindingCategory.QUALITY),
    ACCEPT("Accept", Localization.lang("Accept", new Object[0]), "ctrl+ENTER", KeyBindingCategory.EDIT),
    AUTOMATICALLY_LINK_FILES("Automatically link files", Localization.lang("Automatically set file links", new Object[0]), "F7", KeyBindingCategory.QUALITY),
    CHECK_INTEGRITY("Check integrity", Localization.lang("Check integrity", new Object[0]), "ctrl+F8", KeyBindingCategory.QUALITY),
    CLEANUP("Cleanup", Localization.lang("Cleanup entries", new Object[0]), "alt+F8", KeyBindingCategory.QUALITY),
    CLOSE_DATABASE("Close library", Localization.lang("Close library", new Object[0]), "ctrl+W", KeyBindingCategory.FILE),
    CLOSE("Close dialog", Localization.lang("Close dialog", new Object[0]), "Esc", KeyBindingCategory.VIEW),
    COPY("Copy", Localization.lang("Copy", new Object[0]), "ctrl+C", KeyBindingCategory.EDIT),
    COPY_TITLE("Copy title", Localization.lang("Copy title", new Object[0]), "ctrl+shift+alt+T", KeyBindingCategory.EDIT),
    COPY_CITE_CITATION_KEY("Copy \\cite{citation key}", Localization.lang("Copy citation key with configured cite command", new Object[0]), "ctrl+K", KeyBindingCategory.EDIT),
    COPY_CITATION_KEY("Copy citation key", Localization.lang("Copy citation key", new Object[0]), "ctrl+shift+K", KeyBindingCategory.EDIT),
    COPY_CITATION_KEY_AND_TITLE("Copy citation key and title", Localization.lang("Copy citation key and title", new Object[0]), "ctrl+shift+alt+K", KeyBindingCategory.EDIT),
    COPY_CITATION_KEY_AND_LINK("Copy citation key and link", Localization.lang("Copy citation key and link", new Object[0]), "ctrl+alt+K", KeyBindingCategory.EDIT),
    COPY_PREVIEW("Copy preview", Localization.lang("Copy preview", new Object[0]), "ctrl+shift+C", KeyBindingCategory.VIEW),
    CUT("Cut", Localization.lang("Cut", new Object[0]), "ctrl+X", KeyBindingCategory.EDIT),
    ENTRY_EDITOR_PREVIOUS_PANEL_2("Entry editor, previous panel 2", Localization.lang("Entry editor, previous panel 2", new Object[0]), "ctrl+MINUS", KeyBindingCategory.VIEW),
    DELETE_ENTRY("Delete entry", Localization.lang("Delete entry", new Object[0]), "DELETE", KeyBindingCategory.BIBTEX),
    DEFAULT_DIALOG_ACTION("Execute default action in dialog", Localization.lang("Execute default action in dialog", new Object[0]), "ctrl+ENTER", KeyBindingCategory.VIEW),
    DOWNLOAD_FULL_TEXT("Download full text documents", Localization.lang("Download full text documents", new Object[0]), "alt+F7", KeyBindingCategory.QUALITY),
    OPEN_CLOSE_ENTRY_EDITOR("Open / close entry editor", Localization.lang("Open / close entry editor", new Object[0]), "ctrl+E", KeyBindingCategory.VIEW),
    EXPORT("Export", Localization.lang("Export", new Object[0]), "ctrl+alt+e", KeyBindingCategory.FILE),
    EXPORT_SELECTED("Export Selected", Localization.lang("Export selected entries", new Object[0]), "ctrl+shift+e", KeyBindingCategory.FILE),
    EDIT_STRINGS("Edit strings", Localization.lang("Edit strings", new Object[0]), "ctrl+T", KeyBindingCategory.BIBTEX),
    ENTRY_EDITOR_NEXT_ENTRY("Entry editor, next entry", Localization.lang("Entry editor, next entry", new Object[0]), "alt+DOWN", KeyBindingCategory.VIEW),
    ENTRY_EDITOR_NEXT_PANEL("Entry editor, next panel", Localization.lang("Entry editor, next panel", new Object[0]), "ctrl+TAB", KeyBindingCategory.VIEW),
    ENTRY_EDITOR_NEXT_PANEL_2("Entry editor, next panel 2", Localization.lang("Entry editor, next panel 2", new Object[0]), "ctrl+PLUS", KeyBindingCategory.VIEW),
    ENTRY_EDITOR_PREVIOUS_ENTRY("Entry editor, previous entry", Localization.lang("Entry editor, previous entry", new Object[0]), "alt+UP", KeyBindingCategory.VIEW),
    ENTRY_EDITOR_PREVIOUS_PANEL("Entry editor, previous panel", Localization.lang("Entry editor, previous panel", new Object[0]), "ctrl+shift+TAB", KeyBindingCategory.VIEW),
    FILE_LIST_EDITOR_MOVE_ENTRY_DOWN("File list editor, move entry down", Localization.lang("File list editor, move entry down", new Object[0]), "ctrl+DOWN", KeyBindingCategory.VIEW),
    FILE_LIST_EDITOR_MOVE_ENTRY_UP("File list editor, move entry up", Localization.lang("File list editor, move entry up", new Object[0]), "ctrl+UP", KeyBindingCategory.VIEW),
    FIND_UNLINKED_FILES("Search for unlinked local files", Localization.lang("Search for unlinked local files", new Object[0]), "shift+F7", KeyBindingCategory.QUALITY),
    FOCUS_ENTRY_TABLE("Focus entry table", Localization.lang("Focus entry table", new Object[0]), "alt+1", KeyBindingCategory.VIEW),
    FOCUS_GROUP_LIST("Focus group list", Localization.lang("Focus group list", new Object[0]), "alt+s", KeyBindingCategory.VIEW),
    HELP("Help", Localization.lang("Help", new Object[0]), "F1", KeyBindingCategory.FILE),
    IMPORT_INTO_CURRENT_DATABASE("Import into current library", Localization.lang("Import into current library", new Object[0]), "ctrl+I", KeyBindingCategory.FILE),
    IMPORT_INTO_NEW_DATABASE("Import into new library", Localization.lang("Import into new library", new Object[0]), "ctrl+alt+I", KeyBindingCategory.FILE),
    MERGE_ENTRIES("Merge entries", Localization.lang("Merge entries", new Object[0]), "ctrl+M", KeyBindingCategory.TOOLS),
    NEW_ARTICLE("New article", Localization.lang("New article", new Object[0]), "ctrl+shift+A", KeyBindingCategory.BIBTEX),
    NEW_BOOK("New book", Localization.lang("New book", new Object[0]), "ctrl+shift+B", KeyBindingCategory.BIBTEX),
    NEW_ENTRY("New entry", Localization.lang("New entry", new Object[0]), "ctrl+N", KeyBindingCategory.BIBTEX),
    NEW_ENTRY_FROM_PLAIN_TEXT("New entry from plain text", Localization.lang("New entry from plain text", new Object[0]), "ctrl+shift+N", KeyBindingCategory.BIBTEX),
    NEW_INBOOK("New inbook", Localization.lang("New inbook", new Object[0]), "ctrl+shift+I", KeyBindingCategory.BIBTEX),
    NEW_MASTERSTHESIS("New mastersthesis", Localization.lang("New mastersthesis", new Object[0]), "ctrl+shift+M", KeyBindingCategory.BIBTEX),
    NEW_PHDTHESIS("New phdthesis", Localization.lang("New phdthesis", new Object[0]), "ctrl+shift+T", KeyBindingCategory.BIBTEX),
    NEW_PROCEEDINGS("New proceedings", Localization.lang("New proceedings", new Object[0]), "ctrl+shift+P", KeyBindingCategory.BIBTEX),
    NEW_UNPUBLISHED("New unpublished", Localization.lang("New unpublished", new Object[0]), "ctrl+shift+U", KeyBindingCategory.BIBTEX),
    NEW_TECHREPORT("New technical report", Localization.lang("New technical report", new Object[0]), "", KeyBindingCategory.BIBTEX),
    NEW_INPROCEEDINGS("New inproceesings", Localization.lang("New inproceedings", new Object[0]), "", KeyBindingCategory.BIBTEX),
    NEXT_PREVIEW_LAYOUT("Next preview layout", Localization.lang("Next preview layout", new Object[0]), "F9", KeyBindingCategory.VIEW),
    NEXT_LIBRARY("Next library", Localization.lang("Next library", new Object[0]), "ctrl+PAGE_DOWN", KeyBindingCategory.VIEW),
    OPEN_CONSOLE("Open terminal here", Localization.lang("Open terminal here", new Object[0]), "ctrl+shift+L", KeyBindingCategory.TOOLS),
    OPEN_DATABASE("Open library", Localization.lang("Open library", new Object[0]), "ctrl+O", KeyBindingCategory.FILE),
    OPEN_FILE("Open file", Localization.lang("Open file", new Object[0]), "F4", KeyBindingCategory.TOOLS),
    OPEN_FOLDER("Open folder", Localization.lang("Open folder", new Object[0]), "ctrl+shift+O", KeyBindingCategory.TOOLS),
    OPEN_OPEN_OFFICE_LIBRE_OFFICE_CONNECTION("Open OpenOffice/LibreOffice connection", Localization.lang("Open OpenOffice/LibreOffice connection", new Object[0]), "alt+0", KeyBindingCategory.TOOLS),
    SHOW_PREFS("Preferences", Localization.lang("Preferences", new Object[0]), "ctrl+,", KeyBindingCategory.FILE),
    OPEN_URL_OR_DOI("Open URL or DOI", Localization.lang("Open URL or DOI", new Object[0]), "F3", KeyBindingCategory.TOOLS),
    PASTE("Paste", Localization.lang("Paste", new Object[0]), "ctrl+V", KeyBindingCategory.EDIT),
    PULL_CHANGES_FROM_SHARED_DATABASE("Pull changes from shared database", Localization.lang("Pull changes from shared database", new Object[0]), "ctrl+shift+R", KeyBindingCategory.FILE),
    PREVIOUS_PREVIEW_LAYOUT("Previous preview layout", Localization.lang("Previous preview layout", new Object[0]), "shift+F9", KeyBindingCategory.VIEW),
    PREVIOUS_LIBRARY("Previous library", Localization.lang("Previous library", new Object[0]), "ctrl+PAGE_UP", KeyBindingCategory.VIEW),
    PUSH_TO_APPLICATION("Push to application", Localization.lang("Push to application", new Object[0]), "ctrl+L", KeyBindingCategory.TOOLS),
    QUIT_JABREF("Quit JabRef", Localization.lang("Quit JabRef", new Object[0]), "ctrl+Q", KeyBindingCategory.FILE),
    REDO("Redo", Localization.lang("Redo", new Object[0]), "ctrl+Y", KeyBindingCategory.EDIT),
    REFRESH_OO("Refresh OO", Localization.lang("Refresh OpenOffice/LibreOffice", new Object[0]), "ctrl+alt+O", KeyBindingCategory.TOOLS),
    REPLACE_STRING("Replace string", Localization.lang("Replace string", new Object[0]), "ctrl+R", KeyBindingCategory.SEARCH),
    RESOLVE_DUPLICATE_CITATION_KEYS("Resolve duplicate citation keys", Localization.lang("Resolve duplicate citation keys", new Object[0]), "ctrl+shift+D", KeyBindingCategory.BIBTEX),
    SAVE_ALL("Save all", Localization.lang("Save all", new Object[0]), "ctrl+alt+S", KeyBindingCategory.FILE),
    SAVE_DATABASE("Save library", Localization.lang("Save library", new Object[0]), "ctrl+S", KeyBindingCategory.FILE),
    SAVE_DATABASE_AS("Save library as ...", Localization.lang("Save library as...", new Object[0]), "ctrl+shift+S", KeyBindingCategory.FILE),
    SEARCH("Search", Localization.lang("Search", new Object[0]), "ctrl+F", KeyBindingCategory.SEARCH),
    SELECT_ALL("Select all", Localization.lang("Select all", new Object[0]), "ctrl+A", KeyBindingCategory.EDIT),
    SELECT_FIRST_ENTRY("Select first entry", Localization.lang("Select first entry", new Object[0]), "HOME", KeyBindingCategory.EDIT),
    SELECT_LAST_ENTRY("Select last entry", Localization.lang("Select last entry", new Object[0]), "END", KeyBindingCategory.EDIT),
    STRING_DIALOG_ADD_STRING("String dialog, add string", Localization.lang("String dialog, add string", new Object[0]), "ctrl+N", KeyBindingCategory.FILE),
    STRING_DIALOG_REMOVE_STRING("String dialog, remove string", Localization.lang("String dialog, remove string", new Object[0]), "shift+DELETE", KeyBindingCategory.FILE),
    SYNCHRONIZE_FILES("Synchronize files", Localization.lang("Synchronize files", new Object[0]), "ctrl+shift+F7", KeyBindingCategory.QUALITY),
    TOGGLE_GROUPS_INTERFACE("Toggle groups interface", Localization.lang("Toggle groups interface", new Object[0]), "alt+3", KeyBindingCategory.VIEW),
    UNABBREVIATE("Unabbreviate", Localization.lang("Unabbreviate", new Object[0]), "ctrl+alt+shift+A", KeyBindingCategory.TOOLS),
    UNDO("Undo", Localization.lang("Undo", new Object[0]), "ctrl+Z", KeyBindingCategory.EDIT),
    WEB_SEARCH("Web search", Localization.lang("Web search", new Object[0]), "alt+4", KeyBindingCategory.SEARCH),
    WRITE_METADATA_TO_PDF("Write metadata to PDF files", Localization.lang("Write metadata to PDF files", new Object[0]), "F6", KeyBindingCategory.TOOLS),
    CLEAR_SEARCH("Clear search", Localization.lang("Clear search", new Object[0]), "Esc", KeyBindingCategory.SEARCH),
    CLEAR_READ_STATUS("Clear read status", Localization.lang("Clear read status", new Object[0]), "", KeyBindingCategory.EDIT),
    READ("Set read status to read", Localization.lang("Set read status to read", new Object[0]), "", KeyBindingCategory.EDIT),
    SKIMMED("Set read status to skimmed", Localization.lang("Set read status to skimmed", new Object[0]), "", KeyBindingCategory.EDIT);

    private final String constant;
    private final String localization;
    private final String defaultBinding;
    private final KeyBindingCategory category;

    private KeyBinding(String constantName, String localization, String defaultKeyBinding, KeyBindingCategory category) {
        this.constant = constantName;
        this.localization = localization;
        this.defaultBinding = defaultKeyBinding;
        this.category = category;
    }

    public String getConstant() {
        return this.constant;
    }

    public String getLocalization() {
        return this.localization;
    }

    public String getDefaultKeyBinding() {
        return this.defaultBinding;
    }

    public KeyBindingCategory getCategory() {
        return this.category;
    }
}

