/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.linkedfile;

import com.airhacks.afterburner.views.ViewLoader;
import jakarta.inject.Inject;
import javafx.beans.property.Property;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ComboBox;
import javafx.scene.control.TextField;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.externalfiletype.ExternalFileType;
import org.jabref.gui.linkedfile.LinkedFilesEditDialogViewModel;
import org.jabref.gui.util.BaseDialog;
import org.jabref.gui.util.ViewModelListCellFactory;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.entry.LinkedFile;
import org.jabref.preferences.PreferencesService;

public class LinkedFileEditDialogView
extends BaseDialog<LinkedFile> {
    @FXML
    private TextField link;
    @FXML
    private TextField description;
    @FXML
    private ComboBox<ExternalFileType> fileType;
    @FXML
    private TextField sourceUrl;
    @Inject
    private DialogService dialogService;
    @Inject
    private StateManager stateManager;
    @Inject
    private PreferencesService preferences;
    private LinkedFilesEditDialogViewModel viewModel;
    private final LinkedFile linkedFile;

    public LinkedFileEditDialogView(LinkedFile linkedFile) {
        this.linkedFile = linkedFile;
        ViewLoader.view((Object)((Object)this)).load().setAsContent(this.getDialogPane());
        this.getDialogPane().getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.APPLY, ButtonType.CANCEL});
        this.setResizable(false);
        this.setTitle(Localization.lang("Edit file link", new Object[0]));
        this.setResultConverter(button -> {
            if (button == ButtonType.APPLY) {
                return this.viewModel.getNewLinkedFile();
            }
            return null;
        });
    }

    @FXML
    private void initialize() {
        this.viewModel = new LinkedFilesEditDialogViewModel(this.linkedFile, this.stateManager.getActiveDatabase().get(), this.dialogService, this.preferences.getFilePreferences());
        this.fileType.itemsProperty().bindBidirectional(this.viewModel.externalFileTypeProperty());
        new ViewModelListCellFactory().withIcon(ExternalFileType::getIcon).withText(ExternalFileType::getName).install(this.fileType);
        this.description.textProperty().bindBidirectional((Property)this.viewModel.descriptionProperty());
        this.link.textProperty().bindBidirectional((Property)this.viewModel.linkProperty());
        this.fileType.valueProperty().bindBidirectional(this.viewModel.selectedExternalFileTypeProperty());
        this.sourceUrl.textProperty().bindBidirectional((Property)this.viewModel.sourceUrlProperty());
    }

    @FXML
    private void openBrowseDialog(ActionEvent event) {
        this.viewModel.openBrowseDialog();
        this.link.requestFocus();
    }
}

