/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.maintable;

import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.concurrent.Callable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import org.jabref.gui.DialogService;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionHelper;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.gui.importer.ImportEntriesDialog;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.importer.fileformat.BibliographyFromPdfImporter;
import org.jabref.logic.importer.util.GrobidService;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.io.FileUtil;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.LinkedFile;
import org.jabref.model.entry.field.StandardField;
import org.jabref.preferences.PreferencesService;
import org.jspecify.annotations.NonNull;
import org.jspecify.annotations.Nullable;

public class ExtractReferencesAction
extends SimpleCommand {
    private final int FILES_LIMIT = 10;
    private final boolean online;
    private final DialogService dialogService;
    private final StateManager stateManager;
    private final PreferencesService preferencesService;
    private final BibEntry entry;
    private final LinkedFile linkedFile;
    private final TaskExecutor taskExecutor;
    private final BibliographyFromPdfImporter bibliographyFromPdfImporter;

    public ExtractReferencesAction(boolean online, DialogService dialogService, StateManager stateManager, PreferencesService preferencesService, TaskExecutor taskExecutor) {
        this(online, dialogService, stateManager, preferencesService, null, null, taskExecutor);
    }

    private ExtractReferencesAction(boolean online, @NonNull DialogService dialogService, @NonNull StateManager stateManager, @NonNull PreferencesService preferencesService, @Nullable BibEntry entry, @Nullable LinkedFile linkedFile, @NonNull TaskExecutor taskExecutor) {
        this.online = online;
        this.dialogService = dialogService;
        this.stateManager = stateManager;
        this.preferencesService = preferencesService;
        this.entry = entry;
        this.linkedFile = linkedFile;
        this.taskExecutor = taskExecutor;
        this.bibliographyFromPdfImporter = new BibliographyFromPdfImporter(preferencesService.getCitationKeyPatternPreferences());
        if (this.linkedFile == null) {
            this.executable.bind((ObservableValue)ActionHelper.needsEntriesSelected(stateManager).and((ObservableBooleanValue)ActionHelper.hasLinkedFileForSelectedEntries(stateManager)));
        } else {
            this.setExecutable(true);
        }
    }

    public void execute() {
        this.extractReferences();
    }

    private void extractReferences() {
        this.stateManager.getActiveDatabase().ifPresent(databaseContext -> {
            Callable<ParserResult> parserResultCallable;
            assert (this.online == this.preferencesService.getGrobidPreferences().isGrobidEnabled());
            Object selectedEntries = this.entry == null ? this.stateManager.getSelectedEntries() : List.of(this.entry);
            if (this.online) {
                Optional<Callable<ParserResult>> parserResultCallableOnline = this.getParserResultCallableOnline((BibDatabaseContext)databaseContext, (List<BibEntry>)selectedEntries);
                if (parserResultCallableOnline.isEmpty()) {
                    return;
                }
                parserResultCallable = parserResultCallableOnline.get();
            } else {
                parserResultCallable = this.getParserResultCallableOffline((BibDatabaseContext)databaseContext, (List<BibEntry>)selectedEntries);
            }
            BackgroundTask<ParserResult> task = BackgroundTask.wrap(parserResultCallable).withInitialMessage(Localization.lang("Processing PDF(s)", new Object[0]));
            task.onFailure(this.dialogService::showErrorDialogAndWait);
            ImportEntriesDialog dialog = new ImportEntriesDialog(this.stateManager.getActiveDatabase().get(), task);
            String title = this.online ? Localization.lang("Extract References (online)", new Object[0]) : Localization.lang("Extract References (offline)", new Object[0]);
            dialog.setTitle(title);
            this.dialogService.showCustomDialogAndWait(dialog);
        });
    }

    private @NonNull Callable<ParserResult> getParserResultCallableOffline(BibDatabaseContext databaseContext, List<BibEntry> selectedEntries) {
        return () -> {
            BibEntry currentEntry = (BibEntry)selectedEntries.getFirst();
            List<Path> fileList = FileUtil.getListOfLinkedFiles(selectedEntries, databaseContext.getFileDirectories(this.preferencesService.getFilePreferences()));
            ParserResult result = this.bibliographyFromPdfImporter.importDatabase(fileList.getFirst());
            Iterator<Path> fileListIterator = fileList.iterator();
            fileListIterator.next();
            this.extractReferences(fileListIterator, result, currentEntry);
            Iterator selectedEntriesIterator = selectedEntries.iterator();
            selectedEntriesIterator.next();
            while (selectedEntriesIterator.hasNext()) {
                currentEntry = (BibEntry)selectedEntriesIterator.next();
                fileList = FileUtil.getListOfLinkedFiles(List.of(currentEntry), databaseContext.getFileDirectories(this.preferencesService.getFilePreferences()));
                fileListIterator = fileList.iterator();
                this.extractReferences(fileListIterator, result, currentEntry);
            }
            return result;
        };
    }

    private void extractReferences(Iterator<Path> fileListIterator, ParserResult result, BibEntry currentEntry) {
        while (fileListIterator.hasNext()) {
            result.getDatabase().insertEntries((List<BibEntry>)this.bibliographyFromPdfImporter.importDatabase(fileListIterator.next()).getDatabase().getEntries());
        }
        StringJoiner cites = new StringJoiner(",");
        int count = 0;
        for (BibEntry importedEntry : result.getDatabase().getEntries()) {
            Object citationKeyToAdd;
            ++count;
            Optional<String> citationKey = importedEntry.getCitationKey();
            if (citationKey.isPresent()) {
                citationKeyToAdd = citationKey.get();
            } else {
                String sourceCitationKey = currentEntry.getCitationKey().orElse("unknown");
                Pattern pattern = Pattern.compile("^\\[(\\d+)\\]");
                Matcher matcher = pattern.matcher(importedEntry.getField(StandardField.COMMENT).orElse(""));
                String newCitationKey = matcher.hasMatch() ? sourceCitationKey + "-" + matcher.group(1) : sourceCitationKey + "-" + count;
                importedEntry.setCitationKey(newCitationKey);
                citationKeyToAdd = newCitationKey;
            }
            cites.add((CharSequence)citationKeyToAdd);
        }
        currentEntry.setField(StandardField.CITES, cites.toString());
    }

    private Optional<Callable<ParserResult>> getParserResultCallableOnline(BibDatabaseContext databaseContext, List<BibEntry> selectedEntries) {
        boolean continueOpening;
        List<Path> fileList = FileUtil.getListOfLinkedFiles(selectedEntries, databaseContext.getFileDirectories(this.preferencesService.getFilePreferences()));
        if (fileList.size() > 10 && !(continueOpening = this.dialogService.showConfirmationDialogAndWait(Localization.lang("Processing a large number of files", new Object[0]), Localization.lang("You are about to process %0 files. Continue?", fileList.size()), Localization.lang("Continue", new Object[0]), Localization.lang("Cancel", new Object[0])))) {
            return Optional.empty();
        }
        return Optional.of(() -> new ParserResult(new GrobidService(this.preferencesService.getGrobidPreferences()).processReferences(fileList, this.preferencesService.getImportFormatPreferences())));
    }
}

