/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.maintable;

import java.util.List;
import java.util.stream.Collectors;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import org.jabref.gui.maintable.BibEntryTableViewModel;
import org.jabref.gui.maintable.ColumnPreferences;
import org.jabref.gui.maintable.MainTableColumnModel;
import org.jabref.gui.maintable.columns.MainTableColumn;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PersistenceVisualStateTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(PersistenceVisualStateTable.class);
    protected final TableView<BibEntryTableViewModel> table;
    protected final ColumnPreferences preferences;

    public PersistenceVisualStateTable(TableView<BibEntryTableViewModel> table, ColumnPreferences preferences) {
        this.table = table;
        this.preferences = preferences;
    }

    public void addListeners() {
        this.table.getColumns().addListener(obs -> this.updateColumns());
        this.table.getSortOrder().addListener(obs -> this.updateSortOrder());
        this.table.getColumns().stream().map(col -> ((MainTableColumn)((Object)col)).getModel()).forEach(model -> {
            model.widthProperty().addListener(obs -> this.updateColumns());
            model.sortTypeProperty().addListener(obs -> this.updateColumns());
        });
    }

    private void updateColumns() {
        List<MainTableColumnModel> list = this.toList((List<TableColumn<BibEntryTableViewModel, ?>>)this.table.getColumns());
        LOGGER.debug("Updating columns to {}", list);
        this.preferences.setColumns(list);
    }

    private void updateSortOrder() {
        LOGGER.debug("Updating sort order");
        this.preferences.setColumnSortOrder(this.toList((List<TableColumn<BibEntryTableViewModel, ?>>)this.table.getSortOrder()));
    }

    private List<MainTableColumnModel> toList(List<TableColumn<BibEntryTableViewModel, ?>> columns) {
        return columns.stream().filter(col -> col instanceof MainTableColumn).map(column -> ((MainTableColumn)((Object)column)).getModel()).collect(Collectors.toList());
    }
}

