/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.mergeentries.newmergedialog;

import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.layout.GridPane;
import org.jabref.gui.mergeentries.newmergedialog.cell.HeaderCell;
import org.jabref.logic.l10n.Localization;

public class ThreeWayMergeHeaderView
extends GridPane {
    public static final String DEFAULT_STYLE_CLASS = "merge-header";
    private final HeaderCell leftHeaderCell;
    private final HeaderCell rightHeaderCell;
    private final HeaderCell mergedHeaderCell;

    public ThreeWayMergeHeaderView(String leftHeader, String rightHeader) {
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.leftHeaderCell = new HeaderCell(leftHeader);
        this.rightHeaderCell = new HeaderCell(rightHeader);
        this.mergedHeaderCell = new HeaderCell(Localization.lang("Merged entry", new Object[0]));
        this.addRow(0, new Node[]{new HeaderCell(""), this.leftHeaderCell, this.rightHeaderCell, this.mergedHeaderCell});
        this.setPrefHeight(-1.0);
        this.setMaxHeight(Double.NEGATIVE_INFINITY);
        this.setMinHeight(Double.NEGATIVE_INFINITY);
        this.setPadding(new Insets(0.0, 8.0, 0.0, 0.0));
    }

    public void setLeftHeader(String leftHeader) {
        this.leftHeaderCell.setText(leftHeader);
    }

    public void setRightHeader(String rightHeader) {
        this.rightHeaderCell.setText(rightHeader);
    }
}

