/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.mergeentries.newmergedialog;

import java.util.Comparator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.jabref.gui.AbstractViewModel;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldFactory;
import org.jabref.model.entry.field.InternalField;

public class ThreeWayMergeViewModel
extends AbstractViewModel {
    private final ObjectProperty<BibEntry> leftEntry = new SimpleObjectProperty();
    private final ObjectProperty<BibEntry> rightEntry = new SimpleObjectProperty();
    private final ObjectProperty<BibEntry> mergedEntry = new SimpleObjectProperty();
    private final StringProperty leftHeader = new SimpleStringProperty();
    private final StringProperty rightHeader = new SimpleStringProperty();
    private final ObservableList<Field> visibleFields = FXCollections.observableArrayList();

    public ThreeWayMergeViewModel(BibEntry leftEntry, BibEntry rightEntry, String leftHeader, String rightHeader) {
        Objects.requireNonNull(leftEntry, "Left entry is required");
        Objects.requireNonNull(rightEntry, "Right entry is required");
        Objects.requireNonNull(leftHeader, "Left header entry is required");
        Objects.requireNonNull(rightHeader, "Right header is required");
        this.setLeftEntry(leftEntry);
        this.setRightEntry(rightEntry);
        this.setLeftHeader(leftHeader);
        this.setRightHeader(rightHeader);
        this.mergedEntry.set((Object)new BibEntry());
        this.setVisibleFields(Stream.concat(leftEntry.getFields().stream(), rightEntry.getFields().stream()).collect(Collectors.toSet()));
    }

    public StringProperty leftHeaderProperty() {
        return this.leftHeader;
    }

    public String getLeftHeader() {
        return (String)this.leftHeader.get();
    }

    public void setLeftHeader(String leftHeader) {
        this.leftHeaderProperty().set((Object)leftHeader);
    }

    public StringProperty rightHeaderProperty() {
        return this.rightHeader;
    }

    public String getRightHeader() {
        return (String)this.rightHeaderProperty().get();
    }

    public void setRightHeader(String rightHeader) {
        this.rightHeaderProperty().set((Object)rightHeader);
    }

    public BibEntry getLeftEntry() {
        return (BibEntry)this.leftEntry.get();
    }

    private void setLeftEntry(BibEntry bibEntry) {
        this.leftEntry.set((Object)bibEntry);
    }

    public BibEntry getRightEntry() {
        return (BibEntry)this.rightEntry.get();
    }

    private void setRightEntry(BibEntry bibEntry) {
        this.rightEntry.set((Object)bibEntry);
    }

    public BibEntry getMergedEntry() {
        return (BibEntry)this.mergedEntry.get();
    }

    public ObservableList<Field> getVisibleFields() {
        return this.visibleFields;
    }

    public int numberOfVisibleFields() {
        return this.visibleFields.size();
    }

    private void setVisibleFields(Set<Field> fields) {
        this.visibleFields.clear();
        this.visibleFields.addAll(fields);
        this.visibleFields.removeIf(FieldFactory::isInternalField);
        this.visibleFields.sort(Comparator.comparing(Field::getName));
        this.visibleFields.addFirst((Object)InternalField.TYPE_HEADER);
    }
}

