/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences;

import com.airhacks.afterburner.injection.Injector;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.prefs.BackingStoreException;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.jabref.gui.AbstractViewModel;
import org.jabref.gui.DialogService;
import org.jabref.gui.preferences.PreferencesFilterDialog;
import org.jabref.gui.preferences.PreferencesTab;
import org.jabref.gui.preferences.autocompletion.AutoCompletionTab;
import org.jabref.gui.preferences.citationkeypattern.CitationKeyPatternTab;
import org.jabref.gui.preferences.customentrytypes.CustomEntryTypesTab;
import org.jabref.gui.preferences.customexporter.CustomExporterTab;
import org.jabref.gui.preferences.customimporter.CustomImporterTab;
import org.jabref.gui.preferences.entry.EntryTab;
import org.jabref.gui.preferences.entryeditor.EntryEditorTab;
import org.jabref.gui.preferences.export.ExportTab;
import org.jabref.gui.preferences.external.ExternalTab;
import org.jabref.gui.preferences.externalfiletypes.ExternalFileTypesTab;
import org.jabref.gui.preferences.general.GeneralTab;
import org.jabref.gui.preferences.groups.GroupsTab;
import org.jabref.gui.preferences.journals.JournalAbbreviationsTab;
import org.jabref.gui.preferences.keybindings.KeyBindingsTab;
import org.jabref.gui.preferences.linkedfiles.LinkedFilesTab;
import org.jabref.gui.preferences.nameformatter.NameFormatterTab;
import org.jabref.gui.preferences.network.NetworkTab;
import org.jabref.gui.preferences.preview.PreviewTab;
import org.jabref.gui.preferences.protectedterms.ProtectedTermsTab;
import org.jabref.gui.preferences.table.TableTab;
import org.jabref.gui.preferences.websearch.WebSearchTab;
import org.jabref.gui.preferences.xmp.XmpPrivacyTab;
import org.jabref.gui.util.FileDialogConfiguration;
import org.jabref.logic.JabRefException;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.util.StandardFileType;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.preferences.PreferencesFilter;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreferencesDialogViewModel
extends AbstractViewModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreferencesDialogViewModel.class);
    private final SimpleBooleanProperty memoryStickProperty = new SimpleBooleanProperty();
    private final DialogService dialogService;
    private final PreferencesService preferences;
    private final ObservableList<PreferencesTab> preferenceTabs;

    public PreferencesDialogViewModel(DialogService dialogService, PreferencesService preferences) {
        this.dialogService = dialogService;
        this.preferences = preferences;
        this.preferenceTabs = FXCollections.observableArrayList((Object[])new PreferencesTab[]{new GeneralTab(), new KeyBindingsTab(), new GroupsTab(), new WebSearchTab(), new EntryTab(), new TableTab(), new PreviewTab(), new EntryEditorTab(), new CustomEntryTypesTab(), new CitationKeyPatternTab(), new LinkedFilesTab(), new ExportTab(), new AutoCompletionTab(), new ProtectedTermsTab(), new ExternalTab(), new ExternalFileTypesTab(), new JournalAbbreviationsTab(), new NameFormatterTab(), new XmpPrivacyTab(), new CustomImporterTab(), new CustomExporterTab(), new NetworkTab()});
    }

    public ObservableList<PreferencesTab> getPreferenceTabs() {
        return new ReadOnlyListWrapper(this.preferenceTabs);
    }

    public void importPreferences() {
        FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().addExtensionFilter(StandardFileType.XML).withDefaultExtension(StandardFileType.XML).withInitialDirectory(this.preferences.getInternalPreferences().getLastPreferencesExportPath()).build();
        this.dialogService.showFileOpenDialog(fileDialogConfiguration).ifPresent(file -> {
            try {
                this.preferences.importPreferences((Path)file);
                this.setValues();
                this.dialogService.showWarningDialogAndWait(Localization.lang("Import preferences", new Object[0]), Localization.lang("You must restart JabRef for this to come into effect.", new Object[0]));
            }
            catch (JabRefException ex) {
                LOGGER.error("Error while importing preferences", (Throwable)ex);
                this.dialogService.showErrorDialogAndWait(Localization.lang("Import preferences", new Object[0]), ex);
            }
        });
    }

    public void exportPreferences() {
        FileDialogConfiguration fileDialogConfiguration = new FileDialogConfiguration.Builder().addExtensionFilter(StandardFileType.XML).withDefaultExtension(StandardFileType.XML).withInitialDirectory(this.preferences.getInternalPreferences().getLastPreferencesExportPath()).build();
        this.dialogService.showFileSaveDialog(fileDialogConfiguration).ifPresent(exportFile -> {
            try {
                this.storeAllSettings();
                this.preferences.exportPreferences((Path)exportFile);
                this.preferences.getInternalPreferences().setLastPreferencesExportPath((Path)exportFile);
            }
            catch (JabRefException ex) {
                LOGGER.warn(ex.getMessage(), (Throwable)ex);
                this.dialogService.showErrorDialogAndWait(Localization.lang("Export preferences", new Object[0]), ex);
            }
        });
    }

    public void showPreferences() {
        this.dialogService.showCustomDialogAndWait(new PreferencesFilterDialog(new PreferencesFilter(this.preferences)));
    }

    public void resetPreferences() {
        boolean resetPreferencesConfirmed = this.dialogService.showConfirmationDialogAndWait(Localization.lang("Reset preferences", new Object[0]), Localization.lang("Are you sure you want to reset all settings to default values?", new Object[0]), Localization.lang("Reset preferences", new Object[0]), Localization.lang("Cancel", new Object[0]));
        if (resetPreferencesConfirmed) {
            try {
                this.preferences.clear();
                this.dialogService.showWarningDialogAndWait(Localization.lang("Reset preferences", new Object[0]), Localization.lang("You must restart JabRef for this to come into effect.", new Object[0]));
            }
            catch (BackingStoreException ex) {
                LOGGER.error("Error while resetting preferences", (Throwable)ex);
                this.dialogService.showErrorDialogAndWait(Localization.lang("Reset preferences", new Object[0]), ex);
            }
            this.setValues();
        }
    }

    public boolean validSettings() {
        for (PreferencesTab tab : this.preferenceTabs) {
            if (tab.validateSettings()) continue;
            return false;
        }
        return true;
    }

    public void storeAllSettings() {
        ArrayList<String> restartWarnings = new ArrayList<String>();
        if (!this.validSettings()) {
            return;
        }
        this.preferences.getInternalPreferences().setMemoryStickMode(this.memoryStickProperty.get());
        for (PreferencesTab tab : this.preferenceTabs) {
            tab.storeSettings();
            restartWarnings.addAll(tab.getRestartWarnings());
        }
        this.preferences.flush();
        if (!restartWarnings.isEmpty()) {
            this.dialogService.showWarningDialogAndWait(Localization.lang("Restart required", new Object[0]), String.join((CharSequence)",\n", restartWarnings) + "\n\n" + Localization.lang("You must restart JabRef for this to come into effect.", new Object[0]));
        }
        Injector.setModelOrService(BibEntryTypesManager.class, (Object)this.preferences.getCustomEntryTypesRepository());
        this.dialogService.notify(Localization.lang("Preferences recorded.", new Object[0]));
        this.setValues();
    }

    public void setValues() {
        this.memoryStickProperty.setValue(Boolean.valueOf(this.preferences.getInternalPreferences().isMemoryStickMode()));
        for (PreferencesTab preferencesTab : this.preferenceTabs) {
            preferencesTab.setValues();
        }
    }

    public BooleanProperty getMemoryStickProperty() {
        return this.memoryStickProperty;
    }
}

