/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences;

import com.airhacks.afterburner.views.ViewLoader;
import com.tobiasdiez.easybind.EasyBind;
import java.util.Locale;
import java.util.Objects;
import javafx.beans.binding.Bindings;
import javafx.beans.property.ReadOnlyObjectWrapper;
import javafx.beans.property.ReadOnlyStringWrapper;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.collections.transformation.FilteredList;
import javafx.fxml.FXML;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import org.jabref.gui.util.BaseDialog;
import org.jabref.logic.l10n.Localization;
import org.jabref.preferences.PreferencesFilter;

public class PreferencesFilterDialog
extends BaseDialog<Void> {
    private final PreferencesFilter preferencesFilter;
    private final ObservableList<PreferencesFilter.PreferenceOption> preferenceOptions;
    private final FilteredList<PreferencesFilter.PreferenceOption> filteredOptions;
    @FXML
    private TableView<PreferencesFilter.PreferenceOption> table;
    @FXML
    private TableColumn<PreferencesFilter.PreferenceOption, PreferencesFilter.PreferenceType> columnType;
    @FXML
    private TableColumn<PreferencesFilter.PreferenceOption, String> columnKey;
    @FXML
    private TableColumn<PreferencesFilter.PreferenceOption, Object> columnValue;
    @FXML
    private TableColumn<PreferencesFilter.PreferenceOption, Object> columnDefaultValue;
    @FXML
    private CheckBox showOnlyDeviatingPreferenceOptions;
    @FXML
    private Label count;
    @FXML
    private TextField searchField;

    public PreferencesFilterDialog(PreferencesFilter preferencesFilter) {
        this.preferencesFilter = Objects.requireNonNull(preferencesFilter);
        this.preferenceOptions = FXCollections.observableArrayList();
        this.filteredOptions = new FilteredList(this.preferenceOptions);
        ViewLoader.view((Object)((Object)this)).load().setAsDialogPane((Dialog)this);
        this.setTitle(Localization.lang("Preferences", new Object[0]));
    }

    @FXML
    private void initialize() {
        this.showOnlyDeviatingPreferenceOptions.setOnAction(event -> this.updateModel());
        this.filteredOptions.predicateProperty().bind((ObservableValue)EasyBind.map((ObservableValue)this.searchField.textProperty(), searchText -> {
            if (searchText == null || searchText.isEmpty()) {
                return null;
            }
            String lowerCaseSearchText = searchText.toLowerCase(Locale.ROOT);
            return option -> option.getKey().toLowerCase(Locale.ROOT).contains(lowerCaseSearchText);
        }));
        this.columnType.setCellValueFactory(data -> new ReadOnlyObjectWrapper((Object)((PreferencesFilter.PreferenceOption)data.getValue()).getType()));
        this.columnKey.setCellValueFactory(data -> new ReadOnlyStringWrapper(((PreferencesFilter.PreferenceOption)data.getValue()).getKey()));
        this.columnValue.setCellValueFactory(data -> new ReadOnlyObjectWrapper(((PreferencesFilter.PreferenceOption)data.getValue()).getValue()));
        this.columnDefaultValue.setCellValueFactory(data -> new ReadOnlyObjectWrapper(((PreferencesFilter.PreferenceOption)data.getValue()).getDefaultValue().orElse("")));
        this.table.setItems(this.filteredOptions);
        this.count.textProperty().bind((ObservableValue)Bindings.size((ObservableList)this.table.getItems()).asString("(%d)"));
        this.updateModel();
    }

    private void updateModel() {
        if (this.showOnlyDeviatingPreferenceOptions.isSelected()) {
            this.preferenceOptions.setAll(this.preferencesFilter.getDeviatingPreferences());
        } else {
            this.preferenceOptions.setAll(this.preferencesFilter.getPreferenceOptions());
        }
    }
}

