/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.externalfiletypes;

import de.saxsys.mvvmfx.utils.validation.CompositeValidator;
import de.saxsys.mvvmfx.utils.validation.FunctionBasedValidator;
import de.saxsys.mvvmfx.utils.validation.ValidationMessage;
import de.saxsys.mvvmfx.utils.validation.ValidationStatus;
import de.saxsys.mvvmfx.utils.validation.Validator;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.Node;
import org.jabref.gui.icon.JabRefIcon;
import org.jabref.gui.preferences.externalfiletypes.ExternalFileTypeItemViewModel;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.strings.StringUtil;

public class EditExternalFileTypeViewModel {
    private final ExternalFileTypeItemViewModel fileTypeViewModel;
    private final StringProperty nameProperty = new SimpleStringProperty("");
    private final StringProperty mimeTypeProperty = new SimpleStringProperty("");
    private final StringProperty extensionProperty = new SimpleStringProperty("");
    private final StringProperty selectedApplicationProperty = new SimpleStringProperty("");
    private final BooleanProperty defaultApplicationSelectedProperty = new SimpleBooleanProperty(false);
    private final BooleanProperty customApplicationSelectedProperty = new SimpleBooleanProperty(false);
    private final ObservableList<ExternalFileTypeItemViewModel> fileTypes;
    private final String originalExtension;
    private final String originalName;
    private final String originalMimeType;
    private CompositeValidator extensionValidator;
    private CompositeValidator nameValidator;
    private CompositeValidator mimeTypeValidator;
    private CompositeValidator validator;

    public EditExternalFileTypeViewModel(ExternalFileTypeItemViewModel fileTypeViewModel, ObservableList<ExternalFileTypeItemViewModel> fileTypes) {
        this.fileTypeViewModel = fileTypeViewModel;
        this.fileTypes = fileTypes;
        this.originalExtension = fileTypeViewModel.extensionProperty().getValue();
        this.originalName = fileTypeViewModel.nameProperty().getValue();
        this.originalMimeType = fileTypeViewModel.mimetypeProperty().getValue();
        this.extensionProperty.setValue(fileTypeViewModel.extensionProperty().getValue());
        this.nameProperty.setValue(fileTypeViewModel.nameProperty().getValue());
        this.mimeTypeProperty.setValue(fileTypeViewModel.mimetypeProperty().getValue());
        if (fileTypeViewModel.applicationProperty().getValue().isEmpty()) {
            this.defaultApplicationSelectedProperty.setValue(Boolean.valueOf(true));
        } else {
            this.customApplicationSelectedProperty.setValue(Boolean.valueOf(true));
            this.selectedApplicationProperty.setValue(fileTypeViewModel.applicationProperty().getValue());
        }
        this.setupValidation();
    }

    private void setupValidation() {
        this.validator = new CompositeValidator();
        this.extensionValidator = new CompositeValidator();
        FunctionBasedValidator extensionisNotBlankValidator = new FunctionBasedValidator((ObservableValue)this.extensionProperty, StringUtil::isNotBlank, ValidationMessage.error((String)Localization.lang("Please enter a name for the extension.", new Object[0])));
        FunctionBasedValidator sameExtensionValidator = new FunctionBasedValidator((ObservableValue)this.extensionProperty, extension -> {
            for (ExternalFileTypeItemViewModel fileTypeItem : this.fileTypes) {
                if (!extension.equalsIgnoreCase((String)fileTypeItem.extensionProperty().get()) || extension.equalsIgnoreCase(this.originalExtension)) continue;
                return false;
            }
            return true;
        }, ValidationMessage.error((String)Localization.lang("There already exists an external file type with the same extension", new Object[0])));
        this.extensionValidator.addValidators(new Validator[]{sameExtensionValidator, extensionisNotBlankValidator});
        this.nameValidator = new CompositeValidator();
        FunctionBasedValidator sameNameValidator = new FunctionBasedValidator((ObservableValue)this.nameProperty, name -> {
            for (ExternalFileTypeItemViewModel fileTypeItem : this.fileTypes) {
                if (!name.equalsIgnoreCase((String)fileTypeItem.nameProperty().get()) || name.equalsIgnoreCase(this.originalName)) continue;
                return false;
            }
            return true;
        }, ValidationMessage.error((String)Localization.lang("There already exists an external file type with the same name", new Object[0])));
        FunctionBasedValidator nameIsNotBlankValidator = new FunctionBasedValidator((ObservableValue)this.nameProperty, StringUtil::isNotBlank, ValidationMessage.error((String)Localization.lang("Please enter a name.", new Object[0])));
        this.nameValidator.addValidators(new Validator[]{sameNameValidator, nameIsNotBlankValidator});
        this.mimeTypeValidator = new CompositeValidator();
        FunctionBasedValidator mimeTypeIsNotBlankValidator = new FunctionBasedValidator((ObservableValue)this.mimeTypeProperty, StringUtil::isNotBlank, ValidationMessage.error((String)Localization.lang("Please enter a name for the MIME type.", new Object[0])));
        FunctionBasedValidator sameMimeTypeValidator = new FunctionBasedValidator((ObservableValue)this.mimeTypeProperty, mimeType -> {
            for (ExternalFileTypeItemViewModel fileTypeItem : this.fileTypes) {
                if (!mimeType.equalsIgnoreCase((String)fileTypeItem.mimetypeProperty().get()) || mimeType.equalsIgnoreCase(this.originalMimeType)) continue;
                return false;
            }
            return true;
        }, ValidationMessage.error((String)Localization.lang("There already exists an external file type with the same MIME type", new Object[0])));
        this.mimeTypeValidator.addValidators(new Validator[]{sameMimeTypeValidator, mimeTypeIsNotBlankValidator});
        this.validator.addValidators(new Validator[]{this.extensionValidator, sameExtensionValidator, this.nameValidator, sameNameValidator, this.mimeTypeValidator, sameMimeTypeValidator});
    }

    public ValidationStatus validationStatus() {
        return this.validator.getValidationStatus();
    }

    public ValidationStatus extensionValidation() {
        return this.extensionValidator.getValidationStatus();
    }

    public ValidationStatus mimeTypeValidation() {
        return this.mimeTypeValidator.getValidationStatus();
    }

    public ValidationStatus nameValidation() {
        return this.nameValidator.getValidationStatus();
    }

    public Node getIcon() {
        return ((JabRefIcon)this.fileTypeViewModel.iconProperty().getValue()).getGraphicNode();
    }

    public StringProperty nameProperty() {
        return this.nameProperty;
    }

    public StringProperty extensionProperty() {
        return this.extensionProperty;
    }

    public StringProperty mimeTypeProperty() {
        return this.mimeTypeProperty;
    }

    public StringProperty selectedApplicationProperty() {
        return this.selectedApplicationProperty;
    }

    public BooleanProperty defaultApplicationSelectedProperty() {
        return this.defaultApplicationSelectedProperty;
    }

    public BooleanProperty customApplicationSelectedProperty() {
        return this.customApplicationSelectedProperty;
    }

    public BooleanProperty validExtensionTypeProperty() {
        return this.defaultApplicationSelectedProperty;
    }

    public void storeSettings() {
        this.fileTypeViewModel.nameProperty().setValue(this.nameProperty.getValue().trim());
        this.fileTypeViewModel.mimetypeProperty().setValue(this.mimeTypeProperty.getValue().trim());
        String ext = this.extensionProperty.getValue().trim();
        if (!ext.isEmpty() && ext.charAt(0) == '.') {
            this.fileTypeViewModel.extensionProperty().setValue(ext.substring(1));
        } else {
            this.fileTypeViewModel.extensionProperty().setValue(ext);
        }
        String application = this.selectedApplicationProperty.getValue().trim();
        if (this.defaultApplicationSelectedProperty.getValue().booleanValue() || application.isEmpty()) {
            this.fileTypeViewModel.applicationProperty().setValue("");
            this.selectedApplicationProperty.setValue("");
        } else {
            this.fileTypeViewModel.applicationProperty().setValue(application);
        }
    }
}

