/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.network;

import com.airhacks.afterburner.views.ViewLoader;
import com.tobiasdiez.easybind.EasyBind;
import de.saxsys.mvvmfx.utils.validation.visualization.ControlsFxVisualizer;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import javafx.application.Platform;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Control;
import javafx.scene.control.Label;
import javafx.scene.control.SplitPane;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.input.MouseEvent;
import org.controlsfx.control.textfield.CustomPasswordField;
import org.controlsfx.validation.decoration.ValidationDecoration;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.preferences.AbstractPreferenceTabView;
import org.jabref.gui.preferences.PreferencesTab;
import org.jabref.gui.preferences.network.CustomCertificateViewModel;
import org.jabref.gui.preferences.network.NetworkTabViewModel;
import org.jabref.gui.util.IconValidationDecorator;
import org.jabref.gui.util.ValueTableCellFactory;
import org.jabref.logic.l10n.Localization;

public class NetworkTab
extends AbstractPreferenceTabView<NetworkTabViewModel>
implements PreferencesTab {
    @FXML
    private CheckBox versionCheck;
    @FXML
    private CheckBox proxyUse;
    @FXML
    private Label proxyHostnameLabel;
    @FXML
    private TextField proxyHostname;
    @FXML
    private Label proxyPortLabel;
    @FXML
    private TextField proxyPort;
    @FXML
    private CheckBox proxyUseAuthentication;
    @FXML
    private Label proxyUsernameLabel;
    @FXML
    private TextField proxyUsername;
    @FXML
    private Label proxyPasswordLabel;
    @FXML
    private CustomPasswordField proxyPassword;
    @FXML
    private Button checkConnectionButton;
    @FXML
    private CheckBox proxyPersistPassword;
    @FXML
    private SplitPane persistentTooltipWrapper;
    @FXML
    private TableView<CustomCertificateViewModel> customCertificatesTable;
    @FXML
    private TableColumn<CustomCertificateViewModel, String> certIssuer;
    @FXML
    private TableColumn<CustomCertificateViewModel, String> certSerialNumber;
    @FXML
    private TableColumn<CustomCertificateViewModel, String> certSignatureAlgorithm;
    @FXML
    private TableColumn<CustomCertificateViewModel, String> certValidFrom;
    @FXML
    private TableColumn<CustomCertificateViewModel, String> certValidTo;
    @FXML
    private TableColumn<CustomCertificateViewModel, String> certVersion;
    @FXML
    private TableColumn<CustomCertificateViewModel, String> actionsColumn;
    private String proxyPasswordText = "";
    private int proxyPasswordCaretPosition = 0;
    private final ControlsFxVisualizer validationVisualizer = new ControlsFxVisualizer();

    public NetworkTab() {
        ViewLoader.view((Object)this).root((Object)this).load();
    }

    @Override
    public String getTabName() {
        return Localization.lang("Network", new Object[0]);
    }

    public void initialize() {
        this.viewModel = new NetworkTabViewModel(this.dialogService, this.preferencesService);
        this.versionCheck.selectedProperty().bindBidirectional((Property)((NetworkTabViewModel)this.viewModel).versionCheckProperty());
        this.proxyUse.selectedProperty().bindBidirectional((Property)((NetworkTabViewModel)this.viewModel).proxyUseProperty());
        this.proxyHostnameLabel.disableProperty().bind((ObservableValue)this.proxyUse.selectedProperty().not());
        this.proxyHostname.textProperty().bindBidirectional((Property)((NetworkTabViewModel)this.viewModel).proxyHostnameProperty());
        this.proxyHostname.disableProperty().bind((ObservableValue)this.proxyUse.selectedProperty().not());
        this.proxyPortLabel.disableProperty().bind((ObservableValue)this.proxyUse.selectedProperty().not());
        this.proxyPort.textProperty().bindBidirectional((Property)((NetworkTabViewModel)this.viewModel).proxyPortProperty());
        this.proxyPort.disableProperty().bind((ObservableValue)this.proxyUse.selectedProperty().not());
        this.proxyUseAuthentication.selectedProperty().bindBidirectional((Property)((NetworkTabViewModel)this.viewModel).proxyUseAuthenticationProperty());
        this.proxyUseAuthentication.disableProperty().bind((ObservableValue)this.proxyUse.selectedProperty().not());
        BooleanBinding proxyCustomAndAuthentication = this.proxyUse.selectedProperty().and((ObservableBooleanValue)this.proxyUseAuthentication.selectedProperty());
        this.proxyUsernameLabel.disableProperty().bind((ObservableValue)proxyCustomAndAuthentication.not());
        this.proxyUsername.textProperty().bindBidirectional((Property)((NetworkTabViewModel)this.viewModel).proxyUsernameProperty());
        this.proxyUsername.disableProperty().bind((ObservableValue)proxyCustomAndAuthentication.not());
        this.proxyPasswordLabel.disableProperty().bind((ObservableValue)proxyCustomAndAuthentication.not());
        this.proxyPassword.textProperty().bindBidirectional((Property)((NetworkTabViewModel)this.viewModel).proxyPasswordProperty());
        this.proxyPassword.disableProperty().bind((ObservableValue)proxyCustomAndAuthentication.not());
        this.proxyPersistPassword.selectedProperty().bindBidirectional((Property)((NetworkTabViewModel)this.viewModel).proxyPersistPasswordProperty());
        this.proxyPersistPassword.disableProperty().bind((ObservableValue)proxyCustomAndAuthentication.and((ObservableBooleanValue)((NetworkTabViewModel)this.viewModel).passwordPersistAvailable()).not());
        EasyBind.subscribe((ObservableValue)((NetworkTabViewModel)this.viewModel).passwordPersistAvailable(), available -> {
            if (!available.booleanValue()) {
                this.persistentTooltipWrapper.setTooltip(new Tooltip(Localization.lang("Credential store not available.", new Object[0])));
            } else {
                this.persistentTooltipWrapper.setTooltip(null);
            }
        });
        this.proxyPassword.setRight(IconTheme.JabRefIcons.PASSWORD_REVEALED.getGraphicNode());
        this.proxyPassword.getRight().addEventFilter(MouseEvent.MOUSE_PRESSED, this::proxyPasswordReveal);
        this.proxyPassword.getRight().addEventFilter(MouseEvent.MOUSE_RELEASED, this::proxyPasswordMask);
        this.proxyPassword.getRight().addEventFilter(MouseEvent.MOUSE_EXITED, this::proxyPasswordMask);
        this.validationVisualizer.setDecoration((ValidationDecoration)new IconValidationDecorator());
        Platform.runLater(() -> {
            this.validationVisualizer.initVisualization(((NetworkTabViewModel)this.viewModel).proxyHostnameValidationStatus(), (Control)this.proxyHostname);
            this.validationVisualizer.initVisualization(((NetworkTabViewModel)this.viewModel).proxyPortValidationStatus(), (Control)this.proxyPort);
            this.validationVisualizer.initVisualization(((NetworkTabViewModel)this.viewModel).proxyUsernameValidationStatus(), (Control)this.proxyUsername);
            this.validationVisualizer.initVisualization(((NetworkTabViewModel)this.viewModel).proxyPasswordValidationStatus(), (Control)this.proxyPassword);
        });
        this.certSerialNumber.setCellValueFactory(data -> ((CustomCertificateViewModel)data.getValue()).serialNumberProperty());
        this.certIssuer.setCellValueFactory(data -> ((CustomCertificateViewModel)data.getValue()).issuerProperty());
        this.certSignatureAlgorithm.setCellValueFactory(data -> ((CustomCertificateViewModel)data.getValue()).signatureAlgorithmProperty());
        this.certVersion.setCellValueFactory(data -> EasyBind.map((ObservableValue)((CustomCertificateViewModel)data.getValue()).versionProperty(), this::formatVersion));
        this.certValidFrom.setCellValueFactory(data -> EasyBind.map(((CustomCertificateViewModel)data.getValue()).validFromProperty(), this::formatDate));
        this.certValidTo.setCellValueFactory(data -> EasyBind.map(((CustomCertificateViewModel)data.getValue()).validToProperty(), this::formatDate));
        this.customCertificatesTable.itemsProperty().set(((NetworkTabViewModel)this.viewModel).customCertificateListProperty());
        this.actionsColumn.setCellValueFactory(cellData -> new SimpleStringProperty(((CustomCertificateViewModel)cellData.getValue()).getThumbprint()));
        new ValueTableCellFactory().withGraphic(name -> IconTheme.JabRefIcons.DELETE_ENTRY.getGraphicNode()).withTooltip(name -> Localization.lang("Remove formatter '%0'", name)).withOnMouseClickedEvent(thumbprint -> evt -> ((NetworkTabViewModel)this.viewModel).customCertificateListProperty().removeIf(cert -> cert.getThumbprint().equals(thumbprint))).install(this.actionsColumn);
    }

    private String formatDate(LocalDate localDate) {
        return localDate.format(DateTimeFormatter.ofPattern("dd-MMM-yyyy"));
    }

    private String formatVersion(String version) {
        return "V%s".formatted(version);
    }

    private void proxyPasswordReveal(MouseEvent event) {
        this.proxyPasswordText = this.proxyPassword.getText();
        this.proxyPasswordCaretPosition = this.proxyPassword.getCaretPosition();
        this.proxyPassword.clear();
        this.proxyPassword.setPromptText(this.proxyPasswordText);
    }

    private void proxyPasswordMask(MouseEvent event) {
        if (!"".equals(this.proxyPasswordText)) {
            this.proxyPassword.setText(this.proxyPasswordText);
            this.proxyPassword.positionCaret(this.proxyPasswordCaretPosition);
            this.proxyPassword.setPromptText("");
            this.proxyPasswordText = "";
            this.proxyPasswordCaretPosition = 0;
        }
    }

    @FXML
    void checkConnection() {
        ((NetworkTabViewModel)this.viewModel).checkConnection();
    }

    @FXML
    void addCertificateFile() {
        ((NetworkTabViewModel)this.viewModel).addCertificateFile();
    }
}

