/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.preview;

import com.airhacks.afterburner.injection.Injector;
import de.saxsys.mvvmfx.utils.validation.FunctionBasedValidator;
import de.saxsys.mvvmfx.utils.validation.ValidationMessage;
import de.saxsys.mvvmfx.utils.validation.ValidationStatus;
import de.saxsys.mvvmfx.utils.validation.Validator;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.collections.FXCollections;
import javafx.collections.transformation.FilteredList;
import javafx.scene.control.MultipleSelectionModel;
import javafx.scene.input.ClipboardContent;
import javafx.scene.input.DragEvent;
import javafx.scene.input.Dragboard;
import javafx.scene.input.TransferMode;
import org.fxmisc.richtext.model.StyleSpans;
import org.fxmisc.richtext.model.StyleSpansBuilder;
import org.jabref.gui.DialogService;
import org.jabref.gui.DragAndDropDataFormats;
import org.jabref.gui.StateManager;
import org.jabref.gui.preferences.PreferenceTabViewModel;
import org.jabref.gui.util.BackgroundTask;
import org.jabref.gui.util.CustomLocalDragboard;
import org.jabref.gui.util.NoSelectionModel;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.bst.BstPreviewLayout;
import org.jabref.logic.citationstyle.CitationStyle;
import org.jabref.logic.citationstyle.CitationStylePreviewLayout;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.layout.TextBasedPreviewLayout;
import org.jabref.logic.preview.PreviewLayout;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.preferences.PreviewPreferences;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PreviewTabViewModel
implements PreferenceTabViewModel {
    private static final Logger LOGGER = LoggerFactory.getLogger(PreviewTabViewModel.class);
    private final BooleanProperty showAsExtraTabProperty = new SimpleBooleanProperty(false);
    private final BooleanProperty showPreviewInEntryTableTooltip = new SimpleBooleanProperty(false);
    private final ListProperty<PreviewLayout> availableListProperty = new SimpleListProperty(FXCollections.observableArrayList());
    private final ObjectProperty<MultipleSelectionModel<PreviewLayout>> availableSelectionModelProperty = new SimpleObjectProperty(new NoSelectionModel());
    private final FilteredList<PreviewLayout> filteredAvailableLayouts = new FilteredList(this.availableListProperty());
    private final ListProperty<PreviewLayout> chosenListProperty = new SimpleListProperty(FXCollections.observableArrayList());
    private final ObjectProperty<MultipleSelectionModel<PreviewLayout>> chosenSelectionModelProperty = new SimpleObjectProperty(new NoSelectionModel());
    private final ListProperty<Path> bstStylesPaths = new SimpleListProperty(FXCollections.observableArrayList());
    private final BooleanProperty selectedIsEditableProperty = new SimpleBooleanProperty(false);
    private final ObjectProperty<PreviewLayout> selectedLayoutProperty = new SimpleObjectProperty();
    private final StringProperty sourceTextProperty = new SimpleStringProperty("");
    private final DialogService dialogService;
    private final PreviewPreferences previewPreferences;
    private final TaskExecutor taskExecutor;
    private final Validator chosenListValidator;
    private final CustomLocalDragboard localDragboard;
    private ListProperty<PreviewLayout> dragSourceList = null;
    private ObjectProperty<MultipleSelectionModel<PreviewLayout>> dragSourceSelectionModel = null;

    public PreviewTabViewModel(DialogService dialogService, PreviewPreferences previewPreferences, TaskExecutor taskExecutor, StateManager stateManager) {
        this.dialogService = dialogService;
        this.taskExecutor = taskExecutor;
        this.localDragboard = stateManager.getLocalDragboard();
        this.previewPreferences = previewPreferences;
        this.sourceTextProperty.addListener((observable, oldValue, newValue) -> {
            Object patt0$temp = this.selectedLayoutProperty.getValue();
            if (patt0$temp instanceof TextBasedPreviewLayout) {
                TextBasedPreviewLayout layout = (TextBasedPreviewLayout)patt0$temp;
                layout.setText(this.sourceTextProperty.getValue());
            }
        });
        this.chosenListValidator = new FunctionBasedValidator(this.chosenListProperty, input -> !this.chosenListProperty.getValue().isEmpty(), ValidationMessage.error((String)"%s > %s %n %n %s".formatted(Localization.lang("Entry preview", new Object[0]), Localization.lang("Selected", new Object[0]), Localization.lang("Selected Layouts can not be empty", new Object[0]))));
    }

    @Override
    public void setValues() {
        this.showAsExtraTabProperty.set(this.previewPreferences.shouldShowPreviewAsExtraTab());
        this.showPreviewInEntryTableTooltip.set(this.previewPreferences.shouldShowPreviewEntryTableTooltip());
        this.chosenListProperty().getValue().clear();
        this.chosenListProperty.getValue().addAll(this.previewPreferences.getLayoutCycle());
        this.availableListProperty.clear();
        if (this.chosenListProperty.stream().noneMatch(TextBasedPreviewLayout.class::isInstance)) {
            this.availableListProperty.getValue().add((Object)this.previewPreferences.getCustomPreviewLayout());
        }
        BibEntryTypesManager entryTypesManager = (BibEntryTypesManager)Injector.instantiateModelOrService(BibEntryTypesManager.class);
        BackgroundTask.wrap(CitationStyle::discoverCitationStyles).onSuccess(styles -> styles.stream().map(style -> new CitationStylePreviewLayout((CitationStyle)style, entryTypesManager)).filter(style -> this.chosenListProperty.getValue().filtered(item -> item.getName().equals(style.getName())).isEmpty()).sorted(Comparator.comparing(PreviewLayout::getName)).forEach(arg_0 -> this.availableListProperty.add(arg_0))).onFailure(ex -> {
            LOGGER.error("Something went wrong while adding the discovered CitationStyles to the list.", (Throwable)ex);
            this.dialogService.showErrorDialogAndWait(Localization.lang("Error adding discovered CitationStyles", new Object[0]), (Throwable)ex);
        }).executeWith(this.taskExecutor);
        this.bstStylesPaths.clear();
        this.bstStylesPaths.addAll(this.previewPreferences.getBstPreviewLayoutPaths());
        this.bstStylesPaths.forEach(path -> {
            BstPreviewLayout layout = new BstPreviewLayout((Path)path);
            this.availableListProperty.add((Object)layout);
        });
    }

    public void setPreviewLayout(PreviewLayout selectedLayout) {
        if (selectedLayout == null) {
            this.selectedIsEditableProperty.setValue(Boolean.valueOf(false));
            this.selectedLayoutProperty.setValue(null);
            return;
        }
        try {
            this.selectedLayoutProperty.setValue((Object)selectedLayout);
        }
        catch (StringIndexOutOfBoundsException exception) {
            LOGGER.warn("Parsing error.", (Throwable)exception);
            this.dialogService.showErrorDialogAndWait(Localization.lang("Parsing error", new Object[0]), Localization.lang("Parsing error", new Object[0]) + ": " + Localization.lang("illegal backslash expression", new Object[0]), exception);
        }
        boolean isEditingAllowed = selectedLayout instanceof TextBasedPreviewLayout;
        this.setContentForPreview(selectedLayout.getText(), isEditingAllowed);
    }

    private void setContentForPreview(String text, boolean editable) {
        this.sourceTextProperty.setValue(text);
        this.selectedIsEditableProperty.setValue(Boolean.valueOf(editable));
    }

    public void refreshPreview() {
        this.setPreviewLayout(null);
        this.setPreviewLayout((PreviewLayout)((MultipleSelectionModel)this.chosenSelectionModelProperty.getValue()).getSelectedItem());
    }

    private PreviewLayout findLayoutByName(String name) {
        return this.availableListProperty.getValue().stream().filter(layout -> layout.getName().equals(name)).findAny().orElse(this.chosenListProperty.getValue().stream().filter(layout -> layout.getName().equals(name)).findAny().orElse(null));
    }

    @Override
    public void storeSettings() {
        PreviewLayout customLayout;
        if (this.chosenListProperty.isEmpty()) {
            this.chosenListProperty.add((Object)this.previewPreferences.getCustomPreviewLayout());
        }
        if ((customLayout = this.findLayoutByName("PREVIEW")) == null) {
            customLayout = this.previewPreferences.getCustomPreviewLayout();
        }
        this.previewPreferences.getLayoutCycle().clear();
        this.previewPreferences.getLayoutCycle().addAll(this.chosenListProperty);
        this.previewPreferences.setShowPreviewAsExtraTab(this.showAsExtraTabProperty.getValue());
        this.previewPreferences.setShowPreviewEntryTableTooltip(this.showPreviewInEntryTableTooltip.getValue());
        this.previewPreferences.setCustomPreviewLayout((TextBasedPreviewLayout)customLayout);
        this.previewPreferences.setBstPreviewLayoutPaths((List<Path>)this.bstStylesPaths);
        if (!((MultipleSelectionModel)this.chosenSelectionModelProperty.getValue()).getSelectedItems().isEmpty()) {
            this.previewPreferences.setLayoutCyclePosition(this.chosenListProperty.getValue().indexOf(((MultipleSelectionModel)this.chosenSelectionModelProperty.getValue()).getSelectedItems().getFirst()));
        }
    }

    public ValidationStatus chosenListValidationStatus() {
        return this.chosenListValidator.getValidationStatus();
    }

    @Override
    public boolean validateSettings() {
        ValidationStatus validationStatus = this.chosenListValidationStatus();
        if (!validationStatus.isValid()) {
            if (validationStatus.getHighestMessage().isPresent()) {
                validationStatus.getHighestMessage().ifPresent(message -> this.dialogService.showErrorDialogAndWait(message.getMessage()));
            }
            return false;
        }
        return true;
    }

    public void addToChosen() {
        ArrayList selected = new ArrayList(((MultipleSelectionModel)this.availableSelectionModelProperty.getValue()).getSelectedItems());
        ((MultipleSelectionModel)this.availableSelectionModelProperty.getValue()).clearSelection();
        this.availableListProperty.removeAll(selected);
        this.chosenListProperty.addAll(selected);
    }

    public void removeFromChosen() {
        ArrayList selected = new ArrayList(((MultipleSelectionModel)this.chosenSelectionModelProperty.getValue()).getSelectedItems());
        ((MultipleSelectionModel)this.chosenSelectionModelProperty.getValue()).clearSelection();
        this.chosenListProperty.removeAll(selected);
        this.availableListProperty.addAll(selected);
        this.availableListProperty.sort((a, b) -> a.getDisplayName().compareToIgnoreCase(b.getDisplayName()));
    }

    public void selectedInChosenUp() {
        if (((MultipleSelectionModel)this.chosenSelectionModelProperty.getValue()).isEmpty()) {
            return;
        }
        ArrayList selected = new ArrayList(((MultipleSelectionModel)this.chosenSelectionModelProperty.getValue()).getSelectedIndices());
        ArrayList<Integer> newIndices = new ArrayList<Integer>();
        ((MultipleSelectionModel)this.chosenSelectionModelProperty.getValue()).clearSelection();
        Iterator iterator = selected.iterator();
        while (iterator.hasNext()) {
            int oldIndex = (Integer)iterator.next();
            boolean alreadyTaken = newIndices.contains(oldIndex - 1);
            int newIndex = oldIndex > 0 && !alreadyTaken ? oldIndex - 1 : oldIndex;
            this.chosenListProperty.add(newIndex, (Object)((PreviewLayout)this.chosenListProperty.remove(oldIndex)));
            newIndices.add(newIndex);
        }
        newIndices.forEach(index -> ((MultipleSelectionModel)this.chosenSelectionModelProperty.getValue()).select(index.intValue()));
        ((MultipleSelectionModel)this.chosenSelectionModelProperty.getValue()).select(((Integer)newIndices.getFirst()).intValue());
        this.refreshPreview();
    }

    public void selectedInChosenDown() {
        if (((MultipleSelectionModel)this.chosenSelectionModelProperty.getValue()).isEmpty()) {
            return;
        }
        ArrayList selected = new ArrayList(((MultipleSelectionModel)this.chosenSelectionModelProperty.getValue()).getSelectedIndices());
        ArrayList<Integer> newIndices = new ArrayList<Integer>();
        ((MultipleSelectionModel)this.chosenSelectionModelProperty.getValue()).clearSelection();
        for (int i = selected.size() - 1; i >= 0; --i) {
            int oldIndex = (Integer)selected.get(i);
            boolean alreadyTaken = newIndices.contains(oldIndex + 1);
            int newIndex = oldIndex < this.chosenListProperty.size() - 1 && !alreadyTaken ? oldIndex + 1 : oldIndex;
            this.chosenListProperty.add(newIndex, (Object)((PreviewLayout)this.chosenListProperty.remove(oldIndex)));
            newIndices.add(newIndex);
        }
        newIndices.forEach(index -> ((MultipleSelectionModel)this.chosenSelectionModelProperty.getValue()).select(index.intValue()));
        ((MultipleSelectionModel)this.chosenSelectionModelProperty.getValue()).select(((Integer)newIndices.getFirst()).intValue());
        this.refreshPreview();
    }

    public void resetDefaultLayout() {
        PreviewLayout defaultLayout = this.findLayoutByName("PREVIEW");
        if (defaultLayout instanceof TextBasedPreviewLayout) {
            TextBasedPreviewLayout layout = (TextBasedPreviewLayout)defaultLayout;
            layout.setText(this.previewPreferences.getDefaultCustomPreviewLayout());
        }
        this.refreshPreview();
    }

    public StyleSpans<Collection<String>> computeHighlighting(String text) {
        Pattern XML_TAG = Pattern.compile("(?<ELEMENT>(</?\\h*)(\\w+)([^<>]*)(\\h*/?>))|(?<COMMENT><!--[^<>]+-->)");
        Pattern ATTRIBUTES = Pattern.compile("(\\w+\\h*)(=)(\\h*\"[^\"]+\")");
        int GROUP_OPEN_BRACKET = 2;
        int GROUP_ELEMENT_NAME = 3;
        int GROUP_ATTRIBUTES_SECTION = 4;
        int GROUP_CLOSE_BRACKET = 5;
        boolean GROUP_ATTRIBUTE_NAME = true;
        int GROUP_EQUAL_SYMBOL = 2;
        int GROUP_ATTRIBUTE_VALUE = 3;
        Matcher matcher = XML_TAG.matcher(text);
        int lastKeywordEnd = 0;
        StyleSpansBuilder spansBuilder = new StyleSpansBuilder();
        while (matcher.find()) {
            spansBuilder.add(Collections.emptyList(), matcher.start() - lastKeywordEnd);
            if (matcher.group("COMMENT") != null) {
                spansBuilder.add(Collections.singleton("comment"), matcher.end() - matcher.start());
            } else if (matcher.group("ELEMENT") != null) {
                String attributesText = matcher.group(4);
                spansBuilder.add(Collections.singleton("tagmark"), matcher.end(2) - matcher.start(2));
                spansBuilder.add(Collections.singleton("anytag"), matcher.end(3) - matcher.end(2));
                if (!attributesText.isEmpty()) {
                    lastKeywordEnd = 0;
                    Matcher attributesMatcher = ATTRIBUTES.matcher(attributesText);
                    while (attributesMatcher.find()) {
                        spansBuilder.add(Collections.emptyList(), attributesMatcher.start() - lastKeywordEnd);
                        spansBuilder.add(Collections.singleton("attribute"), attributesMatcher.end(1) - attributesMatcher.start(1));
                        spansBuilder.add(Collections.singleton("tagmark"), attributesMatcher.end(2) - attributesMatcher.end(1));
                        spansBuilder.add(Collections.singleton("avalue"), attributesMatcher.end(3) - attributesMatcher.end(2));
                        lastKeywordEnd = attributesMatcher.end();
                    }
                    if (attributesText.length() > lastKeywordEnd) {
                        spansBuilder.add(Collections.emptyList(), attributesText.length() - lastKeywordEnd);
                    }
                }
                lastKeywordEnd = matcher.end(4);
                spansBuilder.add(Collections.singleton("tagmark"), matcher.end(5) - lastKeywordEnd);
            }
            lastKeywordEnd = matcher.end();
        }
        spansBuilder.add(Collections.emptyList(), text.length() - lastKeywordEnd);
        return spansBuilder.create();
    }

    public void dragOver(DragEvent event) {
        if (event.getDragboard().hasContent(DragAndDropDataFormats.PREVIEWLAYOUTS)) {
            event.acceptTransferModes(new TransferMode[]{TransferMode.MOVE});
        }
    }

    public void dragDetected(ListProperty<PreviewLayout> sourceList, ObjectProperty<MultipleSelectionModel<PreviewLayout>> sourceSelectionModel, List<PreviewLayout> selectedLayouts, Dragboard dragboard) {
        ClipboardContent content = new ClipboardContent();
        content.put((Object)DragAndDropDataFormats.PREVIEWLAYOUTS, (Object)"");
        dragboard.setContent((Map)content);
        this.localDragboard.putPreviewLayouts(selectedLayouts);
        this.dragSourceList = sourceList;
        this.dragSourceSelectionModel = sourceSelectionModel;
    }

    public boolean dragDropped(ListProperty<PreviewLayout> targetList, Dragboard dragboard) {
        List<PreviewLayout> draggedLayouts;
        boolean success = false;
        if (dragboard.hasContent(DragAndDropDataFormats.PREVIEWLAYOUTS) && !(draggedLayouts = this.localDragboard.getPreviewLayouts()).isEmpty()) {
            ((MultipleSelectionModel)this.dragSourceSelectionModel.getValue()).clearSelection();
            this.dragSourceList.getValue().removeAll(draggedLayouts);
            targetList.getValue().addAll(draggedLayouts);
            success = true;
            if (targetList == this.availableListProperty) {
                targetList.getValue().sort((a, b) -> a.getDisplayName().compareToIgnoreCase(b.getDisplayName()));
            }
        }
        return success;
    }

    public boolean dragDroppedInChosenCell(PreviewLayout targetLayout, Dragboard dragboard) {
        ArrayList<PreviewLayout> draggedSelectedLayouts;
        boolean success = false;
        if (dragboard.hasContent(DragAndDropDataFormats.PREVIEWLAYOUTS) && !(draggedSelectedLayouts = new ArrayList<PreviewLayout>(this.localDragboard.getPreviewLayouts())).isEmpty()) {
            ((MultipleSelectionModel)this.chosenSelectionModelProperty.getValue()).clearSelection();
            int targetId = this.chosenListProperty.getValue().indexOf((Object)targetLayout);
            int onSelectedDelta = 0;
            while (draggedSelectedLayouts.contains(targetLayout)) {
                onSelectedDelta = 1;
                if (--targetId < 0) {
                    targetId = 0;
                    targetLayout = null;
                    break;
                }
                targetLayout = (PreviewLayout)this.chosenListProperty.getValue().get(targetId);
            }
            ((MultipleSelectionModel)this.dragSourceSelectionModel.getValue()).clearSelection();
            this.dragSourceList.getValue().removeAll(draggedSelectedLayouts);
            if (targetLayout != null) {
                targetId = this.chosenListProperty.getValue().indexOf((Object)targetLayout) + onSelectedDelta;
            } else if (targetId != 0) {
                targetId = this.chosenListProperty.getValue().size();
            }
            this.chosenListProperty.getValue().addAll(targetId, draggedSelectedLayouts);
            draggedSelectedLayouts.forEach(layout -> ((MultipleSelectionModel)this.chosenSelectionModelProperty.getValue()).select(layout));
            success = true;
        }
        return success;
    }

    public BooleanProperty showAsExtraTabProperty() {
        return this.showAsExtraTabProperty;
    }

    public BooleanProperty showPreviewInEntryTableTooltip() {
        return this.showPreviewInEntryTableTooltip;
    }

    public ListProperty<PreviewLayout> availableListProperty() {
        return this.availableListProperty;
    }

    public FilteredList<PreviewLayout> getFilteredAvailableLayouts() {
        return this.filteredAvailableLayouts;
    }

    public void setAvailableFilter(String searchTerm) {
        this.filteredAvailableLayouts.setPredicate(preview -> searchTerm.isEmpty() || preview.containsCaseIndependent(searchTerm));
    }

    public ObjectProperty<MultipleSelectionModel<PreviewLayout>> availableSelectionModelProperty() {
        return this.availableSelectionModelProperty;
    }

    public ListProperty<PreviewLayout> chosenListProperty() {
        return this.chosenListProperty;
    }

    public ObjectProperty<MultipleSelectionModel<PreviewLayout>> chosenSelectionModelProperty() {
        return this.chosenSelectionModelProperty;
    }

    public BooleanProperty selectedIsEditableProperty() {
        return this.selectedIsEditableProperty;
    }

    public ObjectProperty<PreviewLayout> selectedLayoutProperty() {
        return this.selectedLayoutProperty;
    }

    public StringProperty sourceTextProperty() {
        return this.sourceTextProperty;
    }

    public void addBstStyle(Path bstFile) {
        BstPreviewLayout bstPreviewLayout = new BstPreviewLayout(bstFile);
        this.bstStylesPaths.add((Object)bstFile);
        this.availableListProperty().add((Object)bstPreviewLayout);
        this.chosenListProperty().add((Object)bstPreviewLayout);
    }
}

