/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.preferences.xmp;

import de.saxsys.mvvmfx.utils.validation.FunctionBasedValidator;
import de.saxsys.mvvmfx.utils.validation.ValidationMessage;
import de.saxsys.mvvmfx.utils.validation.ValidationStatus;
import de.saxsys.mvvmfx.utils.validation.Validator;
import java.util.Collection;
import java.util.Comparator;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ListProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleListProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.collections.FXCollections;
import org.jabref.gui.DialogService;
import org.jabref.gui.preferences.PreferenceTabViewModel;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.xmp.XmpPreferences;
import org.jabref.model.entry.field.Field;
import org.jabref.model.entry.field.FieldFactory;

public class XmpPrivacyTabViewModel
implements PreferenceTabViewModel {
    private final BooleanProperty xmpFilterEnabledProperty = new SimpleBooleanProperty();
    private final ListProperty<Field> xmpFilterListProperty = new SimpleListProperty(FXCollections.observableArrayList());
    private final ListProperty<Field> availableFieldsProperty = new SimpleListProperty(FXCollections.observableArrayList());
    private final ObjectProperty<Field> addFieldProperty = new SimpleObjectProperty();
    private final DialogService dialogService;
    private final XmpPreferences xmpPreferences;
    private final Validator xmpFilterListValidator;

    XmpPrivacyTabViewModel(DialogService dialogService, XmpPreferences xmpPreferences) {
        this.dialogService = dialogService;
        this.xmpPreferences = xmpPreferences;
        this.xmpFilterListValidator = new FunctionBasedValidator(this.xmpFilterListProperty, input -> !input.isEmpty(), ValidationMessage.error((String)"%s > %s %n %n %s".formatted(Localization.lang("XMP metadata", new Object[0]), Localization.lang("Filter List", new Object[0]), Localization.lang("List must not be empty.", new Object[0]))));
    }

    @Override
    public void setValues() {
        this.xmpFilterEnabledProperty.setValue(Boolean.valueOf(this.xmpPreferences.shouldUseXmpPrivacyFilter()));
        this.xmpFilterListProperty.clear();
        this.xmpFilterListProperty.addAll(this.xmpPreferences.getXmpPrivacyFilter());
        this.availableFieldsProperty.clear();
        this.availableFieldsProperty.addAll(FieldFactory.getCommonFields());
        this.availableFieldsProperty.sort(Comparator.comparing(Field::getDisplayName));
    }

    @Override
    public void storeSettings() {
        this.xmpPreferences.setUseXmpPrivacyFilter(this.xmpFilterEnabledProperty.getValue());
        this.xmpPreferences.getXmpPrivacyFilter().clear();
        this.xmpPreferences.getXmpPrivacyFilter().addAll((Collection)this.xmpFilterListProperty.getValue());
    }

    public void addField() {
        if (this.addFieldProperty.getValue() == null) {
            return;
        }
        if (this.xmpFilterListProperty.getValue().stream().filter(item -> item.equals(this.addFieldProperty.getValue())).findAny().isEmpty()) {
            this.xmpFilterListProperty.add((Object)((Field)this.addFieldProperty.getValue()));
            this.addFieldProperty.setValue(null);
        }
    }

    public void removeFilter(Field filter) {
        this.xmpFilterListProperty.remove((Object)filter);
    }

    public ValidationStatus xmpFilterListValidationStatus() {
        return this.xmpFilterListValidator.getValidationStatus();
    }

    @Override
    public boolean validateSettings() {
        ValidationStatus validationStatus = this.xmpFilterListValidationStatus();
        if (this.xmpFilterEnabledProperty.getValue().booleanValue() && !validationStatus.isValid()) {
            validationStatus.getHighestMessage().ifPresent(message -> this.dialogService.showErrorDialogAndWait(message.getMessage()));
            return false;
        }
        return true;
    }

    public BooleanProperty xmpFilterEnabledProperty() {
        return this.xmpFilterEnabledProperty;
    }

    public ListProperty<Field> filterListProperty() {
        return this.xmpFilterListProperty;
    }

    public ListProperty<Field> availableFieldsProperty() {
        return this.availableFieldsProperty;
    }

    public ObjectProperty<Field> addFieldNameProperty() {
        return this.addFieldProperty;
    }
}

