/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.push;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import org.jabref.gui.DialogService;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.icon.JabRefIcon;
import org.jabref.gui.push.AbstractPushToApplication;
import org.jabref.gui.util.StreamGobbler;
import org.jabref.logic.util.HeadlessExecutorService;
import org.jabref.logic.util.OS;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.strings.StringUtil;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PushToSublimeText
extends AbstractPushToApplication {
    public static final String NAME = "Sublime Text";
    private static final Logger LOGGER = LoggerFactory.getLogger(PushToSublimeText.class);

    public PushToSublimeText(DialogService dialogService, PreferencesService preferencesService) {
        super(dialogService, preferencesService);
    }

    @Override
    public String getDisplayName() {
        return NAME;
    }

    @Override
    public JabRefIcon getApplicationIcon() {
        return IconTheme.JabRefIcons.APPLICATION_SUBLIMETEXT;
    }

    @Override
    public void pushEntries(BibDatabaseContext database, List<BibEntry> entries, String keyString) {
        this.couldNotPush = false;
        this.couldNotCall = false;
        this.notDefined = false;
        this.commandPath = (String)this.preferencesService.getPushToApplicationPreferences().getCommandPaths().get((Object)this.getDisplayName());
        if (StringUtil.isNullOrEmpty(this.commandPath)) {
            this.notDefined = true;
            return;
        }
        try {
            LOGGER.debug("Sublime string: {}", (Object)String.join((CharSequence)" ", this.getCommandLine(keyString)));
            ProcessBuilder processBuilder = new ProcessBuilder(this.getCommandLine(keyString));
            processBuilder.inheritIO();
            Map<String, String> envs = processBuilder.environment();
            envs.put("PATH", Path.of(this.commandPath, new String[0]).getParent().toString());
            Process process = processBuilder.start();
            StreamGobbler streamGobblerInput = new StreamGobbler(process.getInputStream(), arg_0 -> ((Logger)LOGGER).info(arg_0));
            StreamGobbler streamGobblerError = new StreamGobbler(process.getErrorStream(), arg_0 -> ((Logger)LOGGER).info(arg_0));
            HeadlessExecutorService.INSTANCE.execute(streamGobblerInput);
            HeadlessExecutorService.INSTANCE.execute(streamGobblerError);
        }
        catch (IOException excep) {
            LOGGER.warn("Error: Could not call executable '{}'", (Object)this.commandPath, (Object)excep);
            this.couldNotCall = true;
        }
    }

    @Override
    protected String[] getCommandLine(String keyString) {
        Object citeCommand = this.getCitePrefix();
        if (this.getCitePrefix().contains("\\")) {
            citeCommand = "\"\\" + this.getCitePrefix();
        }
        if (OS.WINDOWS) {
            return new String[]{"cmd.exe", "/c", "\"" + this.commandPath + "\"--command \"insert {\\\"characters\\\": \"\\" + this.getCitePrefix() + keyString + this.getCiteSuffix() + "\"}\""};
        }
        return new String[]{"sh", "-c", "\"" + this.commandPath + "\" --command 'insert {\"characters\": \"" + (String)citeCommand + keyString + this.getCiteSuffix() + "\"}'"};
    }
}

