/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.shared;

import com.airhacks.afterburner.views.ViewLoader;
import com.tobiasdiez.easybind.EasyBind;
import de.saxsys.mvvmfx.utils.validation.visualization.ControlsFxVisualizer;
import jakarta.inject.Inject;
import javafx.application.Platform;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.CheckBox;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.Dialog;
import javafx.scene.control.PasswordField;
import javafx.scene.control.TextField;
import javax.swing.undo.UndoManager;
import org.controlsfx.validation.decoration.ValidationDecoration;
import org.jabref.gui.ClipBoardManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTabContainer;
import org.jabref.gui.StateManager;
import org.jabref.gui.shared.SharedDatabaseLoginDialogViewModel;
import org.jabref.gui.util.BaseDialog;
import org.jabref.gui.util.ControlHelper;
import org.jabref.gui.util.IconValidationDecorator;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.shared.DBMSType;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.util.FileUpdateMonitor;
import org.jabref.preferences.PreferencesService;

public class SharedDatabaseLoginDialogView
extends BaseDialog<Void> {
    @FXML
    private ComboBox<DBMSType> databaseType;
    @FXML
    private TextField host;
    @FXML
    private TextField database;
    @FXML
    private TextField port;
    @FXML
    private TextField user;
    @FXML
    private PasswordField password;
    @FXML
    private CheckBox rememberPassword;
    @FXML
    private TextField folder;
    @FXML
    private Button browseButton;
    @FXML
    private CheckBox autosave;
    @FXML
    private ButtonType connectButton;
    @FXML
    private CheckBox useSSL;
    @FXML
    private TextField fileKeystore;
    @FXML
    private PasswordField passwordKeystore;
    @FXML
    private Button browseKeystore;
    @FXML
    private TextField serverTimezone;
    @FXML
    private TextField jdbcUrl;
    @FXML
    private CheckBox expertMode;
    @Inject
    private DialogService dialogService;
    @Inject
    private PreferencesService preferencesService;
    @Inject
    private StateManager stateManager;
    @Inject
    private BibEntryTypesManager entryTypesManager;
    @Inject
    private FileUpdateMonitor fileUpdateMonitor;
    @Inject
    private UndoManager undoManager;
    @Inject
    private ClipBoardManager clipBoardManager;
    @Inject
    private TaskExecutor taskExecutor;
    private final LibraryTabContainer tabContainer;
    private SharedDatabaseLoginDialogViewModel viewModel;
    private final ControlsFxVisualizer visualizer = new ControlsFxVisualizer();

    public SharedDatabaseLoginDialogView(LibraryTabContainer tabContainer) {
        this.tabContainer = tabContainer;
        this.setTitle(Localization.lang("Connect to shared database", new Object[0]));
        ViewLoader.view((Object)((Object)this)).load().setAsDialogPane((Dialog)this);
        ControlHelper.setAction(this.connectButton, this.getDialogPane(), event -> this.openDatabase());
        Button btnConnect = (Button)this.getDialogPane().lookupButton(this.connectButton);
        btnConnect.disableProperty().bind((ObservableValue)this.viewModel.formValidation().validProperty().not());
        btnConnect.textProperty().bind((ObservableValue)EasyBind.map((ObservableValue)this.viewModel.loadingProperty(), loading -> loading != false ? Localization.lang("Connecting...", new Object[0]) : Localization.lang("Connect", new Object[0])));
    }

    @FXML
    private void openDatabase() {
        boolean connected = this.viewModel.openDatabase();
        if (connected) {
            this.close();
        }
    }

    @FXML
    private void initialize() {
        this.visualizer.setDecoration((ValidationDecoration)new IconValidationDecorator());
        this.viewModel = new SharedDatabaseLoginDialogViewModel(this.tabContainer, this.dialogService, this.preferencesService, this.stateManager, this.entryTypesManager, this.fileUpdateMonitor, this.undoManager, this.clipBoardManager, this.taskExecutor);
        this.databaseType.getItems().addAll((Object[])DBMSType.values());
        this.databaseType.getSelectionModel().select(0);
        this.database.textProperty().bindBidirectional((Property)this.viewModel.databaseproperty());
        this.host.textProperty().bindBidirectional((Property)this.viewModel.hostProperty());
        this.user.textProperty().bindBidirectional((Property)this.viewModel.userProperty());
        this.password.textProperty().bindBidirectional((Property)this.viewModel.passwordProperty());
        this.port.textProperty().bindBidirectional((Property)this.viewModel.portProperty());
        this.serverTimezone.textProperty().bindBidirectional((Property)this.viewModel.serverTimezoneProperty());
        this.databaseType.valueProperty().bindBidirectional(this.viewModel.selectedDbmstypeProperty());
        this.folder.textProperty().bindBidirectional((Property)this.viewModel.folderProperty());
        this.browseButton.disableProperty().bind((ObservableValue)this.viewModel.autosaveProperty().not());
        this.folder.disableProperty().bind((ObservableValue)this.viewModel.autosaveProperty().not());
        this.autosave.selectedProperty().bindBidirectional((Property)this.viewModel.autosaveProperty());
        this.useSSL.selectedProperty().bindBidirectional((Property)this.viewModel.useSSLProperty());
        this.fileKeystore.textProperty().bindBidirectional((Property)this.viewModel.keyStoreProperty());
        this.expertMode.selectedProperty().bindBidirectional((Property)this.viewModel.expertModeProperty());
        this.jdbcUrl.textProperty().bindBidirectional((Property)this.viewModel.jdbcUrlProperty());
        this.jdbcUrl.disableProperty().bind((ObservableValue)this.viewModel.expertModeProperty().not());
        this.browseKeystore.disableProperty().bind((ObservableValue)this.viewModel.useSSLProperty().not());
        this.passwordKeystore.disableProperty().bind((ObservableValue)this.viewModel.useSSLProperty().not());
        this.passwordKeystore.textProperty().bindBidirectional((Property)this.viewModel.keyStorePasswordProperty());
        this.rememberPassword.selectedProperty().bindBidirectional((Property)this.viewModel.rememberPasswordProperty());
        Platform.runLater(() -> {
            this.visualizer.initVisualization(this.viewModel.dbValidation(), (Control)this.database, true);
            this.visualizer.initVisualization(this.viewModel.hostValidation(), (Control)this.host, true);
            this.visualizer.initVisualization(this.viewModel.portValidation(), (Control)this.port, true);
            this.visualizer.initVisualization(this.viewModel.userValidation(), (Control)this.user, true);
            EasyBind.subscribe((ObservableValue)this.autosave.selectedProperty(), selected -> this.visualizer.initVisualization(this.viewModel.folderValidation(), (Control)this.folder, true));
            EasyBind.subscribe((ObservableValue)this.useSSL.selectedProperty(), selected -> this.visualizer.initVisualization(this.viewModel.keystoreValidation(), (Control)this.fileKeystore, true));
        });
    }

    @FXML
    private void showSaveDbToFileDialog(ActionEvent event) {
        this.viewModel.showSaveDbToFileDialog();
    }

    @FXML
    private void showOpenKeystoreFileDialog(ActionEvent event) {
        this.viewModel.showOpenKeystoreFileDialog();
    }
}

