/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.shared;

import com.google.common.eventbus.Subscribe;
import java.sql.SQLException;
import java.util.Optional;
import javafx.scene.control.Alert;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javax.swing.undo.UndoManager;
import org.jabref.gui.ClipBoardManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTab;
import org.jabref.gui.LibraryTabContainer;
import org.jabref.gui.StateManager;
import org.jabref.gui.entryeditor.EntryEditor;
import org.jabref.gui.mergeentries.EntriesMergeResult;
import org.jabref.gui.mergeentries.MergeEntriesDialog;
import org.jabref.gui.shared.SharedDatabaseLoginDialogView;
import org.jabref.gui.undo.UndoableRemoveEntries;
import org.jabref.gui.util.TaskExecutor;
import org.jabref.logic.importer.ParserResult;
import org.jabref.logic.l10n.Localization;
import org.jabref.logic.shared.DBMSConnection;
import org.jabref.logic.shared.DBMSConnectionProperties;
import org.jabref.logic.shared.DBMSSynchronizer;
import org.jabref.logic.shared.DatabaseNotSupportedException;
import org.jabref.logic.shared.DatabaseSynchronizer;
import org.jabref.logic.shared.event.ConnectionLostEvent;
import org.jabref.logic.shared.event.SharedEntriesNotPresentEvent;
import org.jabref.logic.shared.event.UpdateRefusedEvent;
import org.jabref.logic.shared.exception.InvalidDBMSConnectionPropertiesException;
import org.jabref.logic.shared.exception.NotASharedDatabaseException;
import org.jabref.logic.shared.prefs.SharedDatabasePreferences;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.entry.BibEntry;
import org.jabref.model.entry.BibEntryTypesManager;
import org.jabref.model.util.FileUpdateMonitor;
import org.jabref.preferences.PreferencesService;

public class SharedDatabaseUIManager {
    private final LibraryTabContainer tabContainer;
    private DatabaseSynchronizer dbmsSynchronizer;
    private final DialogService dialogService;
    private final PreferencesService preferencesService;
    private final StateManager stateManager;
    private final BibEntryTypesManager entryTypesManager;
    private final FileUpdateMonitor fileUpdateMonitor;
    private final UndoManager undoManager;
    private final ClipBoardManager clipBoardManager;
    private final TaskExecutor taskExecutor;

    public SharedDatabaseUIManager(LibraryTabContainer tabContainer, DialogService dialogService, PreferencesService preferencesService, StateManager stateManager, BibEntryTypesManager entryTypesManager, FileUpdateMonitor fileUpdateMonitor, UndoManager undoManager, ClipBoardManager clipBoardManager, TaskExecutor taskExecutor) {
        this.tabContainer = tabContainer;
        this.dialogService = dialogService;
        this.preferencesService = preferencesService;
        this.stateManager = stateManager;
        this.entryTypesManager = entryTypesManager;
        this.fileUpdateMonitor = fileUpdateMonitor;
        this.undoManager = undoManager;
        this.clipBoardManager = clipBoardManager;
        this.taskExecutor = taskExecutor;
    }

    @Subscribe
    public void listen(ConnectionLostEvent connectionLostEvent) {
        ButtonType reconnect = new ButtonType(Localization.lang("Reconnect", new Object[0]), ButtonBar.ButtonData.YES);
        ButtonType workOffline = new ButtonType(Localization.lang("Work offline", new Object[0]), ButtonBar.ButtonData.NO);
        ButtonType closeLibrary = new ButtonType(Localization.lang("Close library", new Object[0]), ButtonBar.ButtonData.CANCEL_CLOSE);
        Optional<ButtonType> answer = this.dialogService.showCustomButtonDialogAndWait(Alert.AlertType.WARNING, Localization.lang("Connection lost", new Object[0]), Localization.lang("The connection to the server has been terminated.", new Object[0]), reconnect, workOffline, closeLibrary);
        if (answer.isPresent()) {
            if (answer.get().equals(reconnect)) {
                this.tabContainer.closeTab(this.tabContainer.getCurrentLibraryTab());
                this.dialogService.showCustomDialogAndWait(new SharedDatabaseLoginDialogView(this.tabContainer));
            } else if (answer.get().equals(workOffline)) {
                connectionLostEvent.getBibDatabaseContext().convertToLocalDatabase();
                this.tabContainer.getLibraryTabs().forEach(tab -> tab.updateTabTitle(tab.isModified()));
                this.dialogService.notify(Localization.lang("Working offline.", new Object[0]));
            }
        } else {
            this.tabContainer.closeTab(this.tabContainer.getCurrentLibraryTab());
        }
    }

    @Subscribe
    public void listen(UpdateRefusedEvent updateRefusedEvent) {
        this.dialogService.notify(Localization.lang("Update refused.", new Object[0]));
        BibEntry localBibEntry = updateRefusedEvent.getLocalBibEntry();
        BibEntry sharedBibEntry = updateRefusedEvent.getSharedBibEntry();
        String message = Localization.lang("Update could not be performed due to existing change conflicts.", new Object[0]) + "\r\n" + Localization.lang("You are not working on the newest version of BibEntry.", new Object[0]) + "\r\n" + Localization.lang("Shared version: %0", String.valueOf(sharedBibEntry.getSharedBibEntryData().getVersion())) + "\r\n" + Localization.lang("Local version: %0", String.valueOf(localBibEntry.getSharedBibEntryData().getVersion())) + "\r\n" + Localization.lang("Press \"Merge entries\" to merge the changes and resolve this problem.", new Object[0]) + "\r\n" + Localization.lang("Canceling this operation will leave your changes unsynchronized.", new Object[0]);
        ButtonType merge = new ButtonType(Localization.lang("Merge entries", new Object[0]), ButtonBar.ButtonData.YES);
        Optional<ButtonType> response = this.dialogService.showCustomButtonDialogAndWait(Alert.AlertType.CONFIRMATION, Localization.lang("Update refused", new Object[0]), message, ButtonType.CANCEL, merge);
        if (response.isPresent() && response.get().equals(merge)) {
            MergeEntriesDialog dialog = new MergeEntriesDialog(localBibEntry, sharedBibEntry, this.preferencesService);
            dialog.setTitle(Localization.lang("Update refused", new Object[0]));
            Optional<BibEntry> mergedEntry = this.dialogService.showCustomDialogAndWait(dialog).map(EntriesMergeResult::mergedEntry);
            mergedEntry.ifPresent(mergedBibEntry -> {
                mergedBibEntry.getSharedBibEntryData().setSharedID(sharedBibEntry.getSharedBibEntryData().getSharedID());
                mergedBibEntry.getSharedBibEntryData().setVersion(sharedBibEntry.getSharedBibEntryData().getVersion());
                this.dbmsSynchronizer.synchronizeSharedEntry((BibEntry)mergedBibEntry);
                this.dbmsSynchronizer.synchronizeLocalDatabase();
            });
        }
    }

    @Subscribe
    public void listen(SharedEntriesNotPresentEvent event) {
        LibraryTab libraryTab = this.tabContainer.getCurrentLibraryTab();
        EntryEditor entryEditor = libraryTab.getEntryEditor();
        libraryTab.getUndoManager().addEdit(new UndoableRemoveEntries(libraryTab.getDatabase(), event.getBibEntries()));
        if (entryEditor != null && event.getBibEntries().contains(entryEditor.getCurrentlyEditedEntry())) {
            this.dialogService.showInformationDialogAndWait(Localization.lang("Shared entry is no longer present", new Object[0]), Localization.lang("The entry you currently work on has been deleted on the shared side.", new Object[0]) + "\n" + Localization.lang("You can restore the entry using the \"Undo\" operation.", new Object[0]));
            libraryTab.closeBottomPane();
        }
    }

    public LibraryTab openNewSharedDatabaseTab(DBMSConnectionProperties dbmsConnectionProperties) throws SQLException, DatabaseNotSupportedException, InvalidDBMSConnectionPropertiesException {
        BibDatabaseContext bibDatabaseContext = this.getBibDatabaseContextForSharedDatabase();
        this.dbmsSynchronizer = bibDatabaseContext.getDBMSSynchronizer();
        this.dbmsSynchronizer.openSharedDatabase(new DBMSConnection(dbmsConnectionProperties));
        this.dbmsSynchronizer.registerListener(this);
        this.dialogService.notify(Localization.lang("Connection to %0 server established.", dbmsConnectionProperties.getType().toString()));
        LibraryTab libraryTab = LibraryTab.createLibraryTab(bibDatabaseContext, this.tabContainer, this.dialogService, this.preferencesService, this.stateManager, this.fileUpdateMonitor, this.entryTypesManager, this.undoManager, this.clipBoardManager, this.taskExecutor);
        this.tabContainer.addTab(libraryTab, true);
        return libraryTab;
    }

    public void openSharedDatabaseFromParserResult(ParserResult parserResult) throws SQLException, DatabaseNotSupportedException, InvalidDBMSConnectionPropertiesException, NotASharedDatabaseException {
        Optional<String> sharedDatabaseIDOptional = parserResult.getDatabase().getSharedDatabaseID();
        if (sharedDatabaseIDOptional.isEmpty()) {
            throw new NotASharedDatabaseException();
        }
        String sharedDatabaseID = sharedDatabaseIDOptional.get();
        DBMSConnectionProperties dbmsConnectionProperties = new DBMSConnectionProperties(new SharedDatabasePreferences(sharedDatabaseID));
        BibDatabaseContext bibDatabaseContext = this.getBibDatabaseContextForSharedDatabase();
        bibDatabaseContext.getDatabase().setSharedDatabaseID(sharedDatabaseID);
        bibDatabaseContext.setDatabasePath(parserResult.getDatabaseContext().getDatabasePath().orElse(null));
        this.dbmsSynchronizer = bibDatabaseContext.getDBMSSynchronizer();
        this.dbmsSynchronizer.openSharedDatabase(new DBMSConnection(dbmsConnectionProperties));
        this.dbmsSynchronizer.registerListener(this);
        this.dialogService.notify(Localization.lang("Connection to %0 server established.", dbmsConnectionProperties.getType().toString()));
        parserResult.setDatabaseContext(bibDatabaseContext);
    }

    private BibDatabaseContext getBibDatabaseContextForSharedDatabase() {
        BibDatabaseContext bibDatabaseContext = new BibDatabaseContext();
        bibDatabaseContext.setMode(this.preferencesService.getLibraryPreferences().getDefaultBibDatabaseMode());
        DBMSSynchronizer synchronizer = new DBMSSynchronizer(bibDatabaseContext, this.preferencesService.getBibEntryPreferences().getKeywordSeparator(), this.preferencesService.getFieldPreferences(), this.preferencesService.getCitationKeyPatternPreferences().getKeyPatterns(), this.fileUpdateMonitor);
        bibDatabaseContext.convertToSharedDatabase(synchronizer);
        return bibDatabaseContext;
    }
}

