/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.slr;

import com.airhacks.afterburner.views.ViewLoader;
import jakarta.inject.Inject;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.function.Consumer;
import java.util.stream.Stream;
import javafx.beans.binding.Bindings;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.Label;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TableView;
import javafx.scene.control.TextField;
import javafx.scene.control.Tooltip;
import javafx.scene.control.cell.CheckBoxTableCell;
import javafx.scene.control.cell.TextFieldTableCell;
import javafx.scene.input.KeyCode;
import javafx.scene.input.MouseButton;
import org.jabref.gui.DialogService;
import org.jabref.gui.icon.IconTheme;
import org.jabref.gui.slr.ManageStudyDefinitionViewModel;
import org.jabref.gui.slr.SlrStudyAndDirectory;
import org.jabref.gui.slr.StudyCatalogItem;
import org.jabref.gui.theme.ThemeManager;
import org.jabref.gui.util.BaseDialog;
import org.jabref.gui.util.DirectoryDialogConfiguration;
import org.jabref.gui.util.ValueTableCellFactory;
import org.jabref.gui.util.ViewModelTableRowFactory;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.study.Study;
import org.jabref.preferences.PreferencesService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManageStudyDefinitionView
extends BaseDialog<SlrStudyAndDirectory> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ManageStudyDefinitionView.class);
    @FXML
    private TextField studyTitle;
    @FXML
    private TextField addAuthor;
    @FXML
    private TextField addResearchQuestion;
    @FXML
    private TextField addQuery;
    @FXML
    private TextField studyDirectory;
    @FXML
    private Button selectStudyDirectory;
    @FXML
    private ButtonType saveSurveyButtonType;
    @FXML
    private Label helpIcon;
    @FXML
    private TableView<String> authorTableView;
    @FXML
    private TableColumn<String, String> authorsColumn;
    @FXML
    private TableColumn<String, String> authorsActionColumn;
    @FXML
    private TableView<String> questionTableView;
    @FXML
    private TableColumn<String, String> questionsColumn;
    @FXML
    private TableColumn<String, String> questionsActionColumn;
    @FXML
    private TableView<String> queryTableView;
    @FXML
    private TableColumn<String, String> queriesColumn;
    @FXML
    private TableColumn<String, String> queriesActionColumn;
    @FXML
    private TableView<StudyCatalogItem> catalogTable;
    @FXML
    private TableColumn<StudyCatalogItem, Boolean> catalogEnabledColumn;
    @FXML
    private TableColumn<StudyCatalogItem, String> catalogColumn;
    @FXML
    private Label directoryWarning;
    @Inject
    private DialogService dialogService;
    @Inject
    private PreferencesService prefs;
    @Inject
    private ThemeManager themeManager;
    private ManageStudyDefinitionViewModel viewModel;
    private final Optional<Study> study;
    private final Path pathToStudyDataDirectory;

    public ManageStudyDefinitionView(Path pathToStudyDataDirectory) {
        this.pathToStudyDataDirectory = pathToStudyDataDirectory;
        this.setTitle("Define study parameters");
        this.study = Optional.empty();
        ViewLoader.view((Object)((Object)this)).load().setAsDialogPane((Dialog)this);
        this.setupSaveSurveyButton(false);
        this.themeManager.updateFontStyle(this.getDialogPane().getScene());
    }

    public ManageStudyDefinitionView(Study study, Path studyDirectory) {
        this.pathToStudyDataDirectory = studyDirectory;
        this.setTitle(Localization.lang("Manage study definition", new Object[0]));
        this.study = Optional.of(study);
        ViewLoader.view((Object)((Object)this)).load().setAsDialogPane((Dialog)this);
        this.setupSaveSurveyButton(true);
        this.themeManager.updateFontStyle(this.getDialogPane().getScene());
    }

    private void setupSaveSurveyButton(boolean isEdit) {
        Button saveSurveyButton = (Button)this.getDialogPane().lookupButton(this.saveSurveyButtonType);
        if (!isEdit) {
            saveSurveyButton.setText(Localization.lang("Start survey", new Object[0]));
        }
        saveSurveyButton.disableProperty().bind((ObservableValue)Bindings.or((ObservableBooleanValue)Bindings.or((ObservableBooleanValue)Bindings.or((ObservableBooleanValue)Bindings.or((ObservableBooleanValue)Bindings.or((ObservableBooleanValue)Bindings.isEmpty(this.viewModel.getQueries()), (ObservableBooleanValue)Bindings.isEmpty(this.viewModel.getCatalogs())), (ObservableBooleanValue)Bindings.isEmpty(this.viewModel.getAuthors())), (ObservableBooleanValue)this.viewModel.getTitle().isEmpty()), (ObservableBooleanValue)this.viewModel.getDirectory().isEmpty()), (ObservableBooleanValue)this.directoryWarning.visibleProperty()));
        this.setResultConverter(button -> {
            if (button == this.saveSurveyButtonType) {
                return this.viewModel.saveStudy();
            }
            return null;
        });
    }

    @FXML
    private void initialize() {
        if (this.study.isEmpty()) {
            this.viewModel = new ManageStudyDefinitionViewModel(this.prefs.getImportFormatPreferences(), this.prefs.getImporterPreferences(), this.dialogService);
        } else {
            this.viewModel = new ManageStudyDefinitionViewModel(this.study.get(), this.pathToStudyDataDirectory, this.prefs.getImportFormatPreferences(), this.prefs.getImporterPreferences(), this.dialogService);
            this.studyDirectory.setEditable(false);
            this.selectStudyDirectory.setDisable(true);
        }
        this.studyTitle.textProperty().bindBidirectional(this.viewModel.titleProperty());
        this.studyDirectory.textProperty().bindBidirectional((Property)this.viewModel.getDirectory());
        this.initAuthorTab();
        this.initQuestionsTab();
        this.initQueriesTab();
        this.initCatalogsTab();
    }

    private void updateDirectoryWarning(Path directory) {
        if (!Files.isDirectory(directory, new LinkOption[0])) {
            this.directoryWarning.setText(Localization.lang("Warning: The selected directory is not a valid directory.", new Object[0]));
            this.directoryWarning.setVisible(true);
        } else {
            try (Stream<Path> entries = Files.list(directory);){
                if (entries.findAny().isPresent()) {
                    this.directoryWarning.setText(Localization.lang("Warning: The selected directory is not empty.", new Object[0]));
                    this.directoryWarning.setVisible(true);
                } else {
                    this.directoryWarning.setVisible(false);
                }
            }
            catch (IOException e) {
                this.directoryWarning.setText(Localization.lang("Warning: Failed to check if the directory is empty.", new Object[0]));
                this.directoryWarning.setVisible(true);
            }
        }
    }

    private void initAuthorTab() {
        this.setupCommonPropertiesForTables((Node)this.addAuthor, this::addAuthor, this.authorsColumn, this.authorsActionColumn);
        this.setupCellFactories(this.authorsColumn, this.authorsActionColumn, this.viewModel::deleteAuthor);
        this.authorTableView.setItems(this.viewModel.getAuthors());
    }

    private void initQuestionsTab() {
        this.setupCommonPropertiesForTables((Node)this.addResearchQuestion, this::addResearchQuestion, this.questionsColumn, this.questionsActionColumn);
        this.setupCellFactories(this.questionsColumn, this.questionsActionColumn, this.viewModel::deleteQuestion);
        this.questionTableView.setItems(this.viewModel.getResearchQuestions());
    }

    private void initQueriesTab() {
        this.setupCommonPropertiesForTables((Node)this.addQuery, this::addQuery, this.queriesColumn, this.queriesActionColumn);
        this.setupCellFactories(this.queriesColumn, this.queriesActionColumn, this.viewModel::deleteQuery);
        this.queryTableView.setItems(this.viewModel.getQueries());
        this.helpIcon.setTooltip(new Tooltip(new StringJoiner("\n").add(Localization.lang("Query terms are separated by spaces.", new Object[0])).add(Localization.lang("All query terms are joined using the logical AND, and OR operators", new Object[0]) + ".").add(Localization.lang("If the sequence of terms is relevant wrap them in double quotes", new Object[0]) + "(\").").add(Localization.lang("An example:", new Object[0]) + " rain AND (clouds OR drops) AND \"precipitation distribution\"").toString()));
    }

    private void initCatalogsTab() {
        new ViewModelTableRowFactory<StudyCatalogItem>().withOnMouseClickedEvent((entry, event) -> {
            if (event.getButton() == MouseButton.PRIMARY) {
                entry.setEnabled(!entry.isEnabled());
            }
        }).install(this.catalogTable);
        this.catalogColumn.setReorderable(false);
        this.catalogColumn.setCellFactory(TextFieldTableCell.forTableColumn());
        this.catalogEnabledColumn.setResizable(false);
        this.catalogEnabledColumn.setReorderable(false);
        this.catalogEnabledColumn.setCellFactory(CheckBoxTableCell.forTableColumn(this.catalogEnabledColumn));
        this.catalogEnabledColumn.setCellValueFactory(param -> ((StudyCatalogItem)param.getValue()).enabledProperty());
        this.catalogColumn.setEditable(false);
        this.catalogColumn.setCellValueFactory(param -> ((StudyCatalogItem)param.getValue()).nameProperty());
        this.catalogTable.setItems(this.viewModel.getCatalogs());
    }

    private void setupCommonPropertiesForTables(Node addControl, Runnable addAction, TableColumn<?, String> contentColumn, TableColumn<?, String> actionColumn) {
        addControl.setOnKeyPressed(event -> {
            if (event.getCode() == KeyCode.ENTER) {
                addAction.run();
            }
        });
        contentColumn.setReorderable(false);
        contentColumn.setCellFactory(TextFieldTableCell.forTableColumn());
        actionColumn.setReorderable(false);
        actionColumn.setResizable(false);
    }

    private void setupCellFactories(TableColumn<String, String> contentColumn, TableColumn<String, String> actionColumn, Consumer<String> removeAction) {
        contentColumn.setCellValueFactory(param -> new SimpleStringProperty((String)param.getValue()));
        actionColumn.setCellValueFactory(param -> new SimpleStringProperty((String)param.getValue()));
        new ValueTableCellFactory().withGraphic(item -> IconTheme.JabRefIcons.DELETE_ENTRY.getGraphicNode()).withTooltip(name -> Localization.lang("Remove", new Object[0])).withOnMouseClickedEvent(item -> evt -> removeAction.accept((String)item)).install(actionColumn);
    }

    @FXML
    private void addAuthor() {
        this.viewModel.addAuthor(this.addAuthor.getText());
        this.addAuthor.setText("");
    }

    @FXML
    private void addResearchQuestion() {
        this.viewModel.addResearchQuestion(this.addResearchQuestion.getText());
        this.addResearchQuestion.setText("");
    }

    @FXML
    private void addQuery() {
        this.viewModel.addQuery(this.addQuery.getText());
        this.addQuery.setText("");
    }

    @FXML
    public void selectStudyDirectory() {
        DirectoryDialogConfiguration directoryDialogConfiguration = new DirectoryDialogConfiguration.Builder().withInitialDirectory(this.pathToStudyDataDirectory).build();
        Optional<Path> selectedDirectoryOptional = this.dialogService.showDirectorySelectionDialog(directoryDialogConfiguration);
        selectedDirectoryOptional.ifPresent(selectedDirectory -> {
            this.viewModel.setStudyDirectory(Optional.of(selectedDirectory));
            this.updateDirectoryWarning((Path)selectedDirectory);
        });
    }
}

