/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.specialfields;

import de.saxsys.mvvmfx.utils.commands.Command;
import java.util.function.Function;
import java.util.function.Supplier;
import javafx.beans.value.ObservableValue;
import javafx.scene.control.Menu;
import javafx.scene.control.MenuItem;
import javax.swing.undo.UndoManager;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTab;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionFactory;
import org.jabref.gui.specialfields.SpecialFieldValueViewModel;
import org.jabref.gui.specialfields.SpecialFieldViewModel;
import org.jabref.model.entry.field.SpecialField;
import org.jabref.model.entry.field.SpecialFieldValue;
import org.jabref.preferences.PreferencesService;

public class SpecialFieldMenuItemFactory {
    public static MenuItem getSpecialFieldSingleItem(SpecialField field, ActionFactory factory, Supplier<LibraryTab> tabSupplier, DialogService dialogService, PreferencesService preferencesService, UndoManager undoManager, StateManager stateManager) {
        SpecialFieldValueViewModel specialField = new SpecialFieldValueViewModel(field.getValues().getFirst());
        MenuItem menuItem = factory.createMenuItem(specialField.getAction(), (Command)new SpecialFieldViewModel(field, preferencesService, undoManager).getSpecialFieldAction(field.getValues().getFirst(), tabSupplier, dialogService, stateManager));
        menuItem.visibleProperty().bind((ObservableValue)preferencesService.getSpecialFieldsPreferences().specialFieldsEnabledProperty());
        return menuItem;
    }

    public static Menu createSpecialFieldMenu(SpecialField field, ActionFactory factory, Supplier<LibraryTab> tabSupplier, DialogService dialogService, PreferencesService preferencesService, UndoManager undoManager, StateManager stateManager) {
        return SpecialFieldMenuItemFactory.createSpecialFieldMenu(field, factory, preferencesService, undoManager, specialField -> new SpecialFieldViewModel(field, preferencesService, undoManager).getSpecialFieldAction(specialField.getValue(), tabSupplier, dialogService, stateManager));
    }

    public static Menu createSpecialFieldMenu(SpecialField field, ActionFactory factory, PreferencesService preferencesService, UndoManager undoManager, Function<SpecialFieldValueViewModel, Command> commandFactory) {
        SpecialFieldViewModel viewModel = new SpecialFieldViewModel(field, preferencesService, undoManager);
        Menu menu = factory.createMenu(viewModel.getAction());
        for (SpecialFieldValue Value : field.getValues()) {
            SpecialFieldValueViewModel valueViewModel = new SpecialFieldValueViewModel(Value);
            menu.getItems().add((Object)factory.createMenuItem(valueViewModel.getAction(), commandFactory.apply(valueViewModel)));
        }
        menu.visibleProperty().bind((ObservableValue)preferencesService.getSpecialFieldsPreferences().specialFieldsEnabledProperty());
        return menu;
    }
}

