/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.texparser;

import com.airhacks.afterburner.views.ViewLoader;
import com.tobiasdiez.easybind.EasyBind;
import jakarta.inject.Inject;
import java.nio.file.Path;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.Dialog;
import javafx.scene.control.ListView;
import javafx.scene.text.Text;
import org.jabref.gui.texparser.CitationsDisplay;
import org.jabref.gui.texparser.ParseLatexResultViewModel;
import org.jabref.gui.texparser.ReferenceViewModel;
import org.jabref.gui.theme.ThemeManager;
import org.jabref.gui.util.BaseDialog;
import org.jabref.gui.util.ControlHelper;
import org.jabref.gui.util.ViewModelListCellFactory;
import org.jabref.logic.l10n.Localization;
import org.jabref.model.database.BibDatabaseContext;
import org.jabref.model.texparser.LatexBibEntriesResolverResult;

public class ParseLatexResultView
extends BaseDialog<Void> {
    private final LatexBibEntriesResolverResult resolverResult;
    private final BibDatabaseContext databaseContext;
    private final Path basePath;
    @FXML
    private ListView<ReferenceViewModel> referenceListView;
    @FXML
    private CitationsDisplay citationsDisplay;
    @FXML
    private ButtonType importButtonType;
    @Inject
    private ThemeManager themeManager;
    private ParseLatexResultViewModel viewModel;

    public ParseLatexResultView(LatexBibEntriesResolverResult resolverResult, BibDatabaseContext databaseContext, Path basePath) {
        this.resolverResult = resolverResult;
        this.databaseContext = databaseContext;
        this.basePath = basePath;
        this.setTitle(Localization.lang("LaTeX Citations Search Results", new Object[0]));
        ViewLoader.view((Object)((Object)this)).load().setAsDialogPane((Dialog)this);
        ControlHelper.setAction(this.importButtonType, this.getDialogPane(), event -> {
            this.viewModel.importButtonClicked();
            this.close();
        });
        Button importButton = (Button)this.getDialogPane().lookupButton(this.importButtonType);
        importButton.disableProperty().bind((ObservableValue)this.viewModel.importButtonDisabledProperty());
        this.themeManager.updateFontStyle(this.getDialogPane().getScene());
    }

    @FXML
    private void initialize() {
        this.viewModel = new ParseLatexResultViewModel(this.resolverResult, this.databaseContext);
        this.referenceListView.setItems(this.viewModel.getReferenceList());
        this.referenceListView.getSelectionModel().selectFirst();
        new ViewModelListCellFactory().withGraphic(reference -> {
            Text referenceText = new Text(reference.getDisplayText());
            if (reference.isHighlighted()) {
                referenceText.setStyle("-fx-fill: -fx-accent");
            }
            return referenceText;
        }).install(this.referenceListView);
        EasyBind.subscribe((ObservableValue)this.referenceListView.getSelectionModel().selectedItemProperty(), this.viewModel::activeReferenceChanged);
        this.citationsDisplay.basePathProperty().set((Object)this.basePath);
        this.citationsDisplay.setItems(this.viewModel.getCitationListByReference());
    }
}

