/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.texparser;

import java.util.Collection;
import javafx.beans.property.ReadOnlyListWrapper;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import org.jabref.model.texparser.Citation;

public class ReferenceViewModel {
    private final String entry;
    private final boolean highlighted;
    private final ObservableList<Citation> citationList;

    public ReferenceViewModel(String entry, boolean highlighted, Collection<Citation> citationColl) {
        this.entry = entry;
        this.highlighted = highlighted;
        this.citationList = FXCollections.observableArrayList();
        this.citationList.setAll(citationColl);
    }

    public boolean isHighlighted() {
        return this.highlighted;
    }

    public ObservableList<Citation> getCitationList() {
        return new ReadOnlyListWrapper(this.citationList);
    }

    public String getDisplayText() {
        return "%s (%s)".formatted(this.entry, this.citationList.size());
    }

    public String toString() {
        return "ReferenceViewModel{entry='%s', highlighted=%s, citationList=%s}".formatted(this.entry, this.highlighted, this.citationList);
    }
}

