/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.theme;

import java.util.Objects;
import java.util.Optional;
import org.jabref.gui.theme.StyleSheet;

public class Theme {
    public static final String BASE_CSS = "Base.css";
    public static final String EMBEDDED_DARK_CSS = "Dark.css";
    private final Type type;
    private final String name;
    private final Optional<StyleSheet> additionalStylesheet;

    public Theme(String name) {
        Objects.requireNonNull(name);
        if ("".equals(name) || BASE_CSS.equalsIgnoreCase(name)) {
            this.additionalStylesheet = Optional.empty();
            this.type = Type.DEFAULT;
            this.name = "";
        } else if (EMBEDDED_DARK_CSS.equalsIgnoreCase(name)) {
            this.additionalStylesheet = StyleSheet.create(EMBEDDED_DARK_CSS);
            if (this.additionalStylesheet.isPresent()) {
                this.type = Type.EMBEDDED;
                this.name = EMBEDDED_DARK_CSS;
            } else {
                this.type = Type.DEFAULT;
                this.name = "";
            }
        } else {
            this.additionalStylesheet = StyleSheet.create(name);
            if (this.additionalStylesheet.isPresent()) {
                this.type = Type.CUSTOM;
                this.name = name;
            } else {
                this.type = Type.DEFAULT;
                this.name = "";
            }
        }
    }

    public static Theme light() {
        return new Theme("");
    }

    public static Theme dark() {
        return new Theme(EMBEDDED_DARK_CSS);
    }

    public static Theme custom(String name) {
        return new Theme(name);
    }

    public Type getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public Optional<StyleSheet> getAdditionalStylesheet() {
        return this.additionalStylesheet;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Theme that = (Theme)o;
        return this.type == that.type && this.name.equals(that.name);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.type, this.name});
    }

    public String toString() {
        return "Theme{type=" + String.valueOf((Object)this.type) + ", name='" + this.name + "'}";
    }

    public static enum Type {
        DEFAULT,
        EMBEDDED,
        CUSTOM;

    }
}

