/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.undo;

import java.util.function.Supplier;
import javafx.beans.value.ObservableValue;
import javax.swing.undo.CannotRedoException;
import org.jabref.gui.DialogService;
import org.jabref.gui.LibraryTab;
import org.jabref.gui.StateManager;
import org.jabref.gui.actions.ActionHelper;
import org.jabref.gui.actions.SimpleCommand;
import org.jabref.logic.l10n.Localization;

public class RedoAction
extends SimpleCommand {
    private final Supplier<LibraryTab> tabSupplier;
    private final DialogService dialogService;

    public RedoAction(Supplier<LibraryTab> tabSupplier, DialogService dialogService, StateManager stateManager) {
        this.tabSupplier = tabSupplier;
        this.dialogService = dialogService;
        this.executable.bind((ObservableValue)ActionHelper.needsDatabase(stateManager));
    }

    public void execute() {
        LibraryTab libraryTab = this.tabSupplier.get();
        try {
            libraryTab.getUndoManager().redo();
            this.dialogService.notify(Localization.lang("Redo", new Object[0]));
        }
        catch (CannotRedoException ex) {
            this.dialogService.notify(Localization.lang("Nothing to redo", new Object[0]) + ".");
        }
        libraryTab.markChangedOrUnChanged();
    }
}

