/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.StyleableObjectProperty;
import javafx.css.StyleableProperty;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Skin;
import javafx.scene.control.TitledPane;
import javafx.scene.control.skin.TitledPaneSkin;
import javafx.scene.layout.Region;
import javafx.scene.text.Text;
import javafx.scene.transform.Rotate;

public class CustomTitledPaneSkin
extends TitledPaneSkin {
    private final StyleableObjectProperty<ArrowSide> arrowSide = new SimpleStyleableObjectProperty<ArrowSide>(StyleableProperties.ARROW_SIDE, (Object)this, "arrowSide", ArrowSide.LEFT){

        protected void invalidated() {
            CustomTitledPaneSkin.this.adjustTitleLayout();
        }
    };
    private final Region title;
    private final Region arrowButton;
    private final Region arrow;
    private final Text text;
    private DoubleBinding arrowTranslateBinding;
    private DoubleBinding textGraphicTranslateBinding;
    private Node graphic;

    public final void setArrowSide(ArrowSide arrowSide) {
        this.arrowSide.set((Object)arrowSide);
    }

    public final ArrowSide getArrowSide() {
        return (ArrowSide)((Object)this.arrowSide.get());
    }

    public final ObjectProperty<ArrowSide> arrowSideProperty() {
        return this.arrowSide;
    }

    public CustomTitledPaneSkin(TitledPane control) {
        super(control);
        this.title = (Region)Objects.requireNonNull(control.lookup(".title"));
        this.arrowButton = (Region)Objects.requireNonNull(this.title.lookup(".arrow-button"));
        this.arrow = (Region)Objects.requireNonNull(this.arrowButton.lookup(".arrow"));
        this.text = (Text)Objects.requireNonNull(this.title.lookup(".text"));
        Rotate rotate = new Rotate();
        rotate.pivotXProperty().bind((ObservableValue)this.arrow.widthProperty().divide(2.0));
        rotate.pivotYProperty().bind((ObservableValue)this.arrow.heightProperty().divide(2.0));
        rotate.angleProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)control.expandedProperty()).then(-180.0).otherwise(90.0));
        this.arrow.getTransforms().add((Object)rotate);
        this.registerChangeListener((ObservableValue)control.graphicProperty(), ov -> this.adjustTitleLayout());
    }

    private void adjustTitleLayout() {
        this.clearBindings();
        if (this.getArrowSide() != ArrowSide.RIGHT) {
            return;
        }
        this.arrowTranslateBinding = Bindings.createDoubleBinding(() -> {
            double rightInset = this.title.getPadding().getRight();
            return this.title.getWidth() - this.arrowButton.getLayoutX() - this.arrowButton.getWidth() - rightInset;
        }, (Observable[])new Observable[]{this.title.paddingProperty(), this.title.widthProperty(), this.arrowButton.widthProperty(), this.arrowButton.layoutXProperty()});
        this.arrowButton.translateXProperty().bind((ObservableValue)this.arrowTranslateBinding);
        this.textGraphicTranslateBinding = Bindings.createDoubleBinding(() -> switch (((TitledPane)this.getSkinnable()).getAlignment()) {
            case Pos.TOP_CENTER, Pos.CENTER, Pos.BOTTOM_CENTER, Pos.BASELINE_CENTER -> 0.0;
            default -> -this.arrowButton.getWidth();
        }, (Observable[])new Observable[]{((TitledPane)this.getSkinnable()).alignmentProperty(), this.arrowButton.widthProperty()});
        this.text.translateXProperty().bind((ObservableValue)this.textGraphicTranslateBinding);
        this.graphic = ((TitledPane)this.getSkinnable()).getGraphic();
        if (this.graphic != null) {
            this.graphic.translateXProperty().bind((ObservableValue)this.textGraphicTranslateBinding);
        }
    }

    private void clearBindings() {
        if (this.arrowTranslateBinding != null) {
            this.arrowButton.translateXProperty().unbind();
            this.arrowButton.setTranslateX(0.0);
            this.arrowTranslateBinding.dispose();
            this.arrowTranslateBinding = null;
        }
        if (this.textGraphicTranslateBinding != null) {
            this.text.translateXProperty().unbind();
            this.text.setTranslateX(0.0);
            if (this.graphic != null) {
                this.graphic.translateXProperty().unbind();
                this.graphic.setTranslateX(0.0);
                this.graphic = null;
            }
            this.textGraphicTranslateBinding.dispose();
            this.textGraphicTranslateBinding = null;
        }
    }

    public void dispose() {
        this.clearBindings();
        this.unregisterChangeListeners((ObservableValue)((TitledPane)this.getSkinnable()).graphicProperty());
        super.dispose();
    }

    public static List<CssMetaData<?, ?>> getClassCssMetaData() {
        return StyleableProperties.CSS_META_DATA;
    }

    public List<CssMetaData<?, ?>> getCssMetaData() {
        return CustomTitledPaneSkin.getClassCssMetaData();
    }

    public static enum ArrowSide {
        LEFT,
        RIGHT;

    }

    private static class StyleableProperties {
        private static final CssMetaData<TitledPane, ArrowSide> ARROW_SIDE = new CssMetaData<TitledPane, ArrowSide>("-fx-arrow-side", StyleConverter.getEnumConverter(ArrowSide.class), ArrowSide.LEFT){

            public boolean isSettable(TitledPane styleable) {
                Property prop = (Property)this.getStyleableProperty(styleable);
                return prop != null && !prop.isBound();
            }

            public StyleableProperty<ArrowSide> getStyleableProperty(TitledPane styleable) {
                Skin skin = styleable.getSkin();
                if (skin instanceof CustomTitledPaneSkin) {
                    CustomTitledPaneSkin paneSkin = (CustomTitledPaneSkin)skin;
                    return paneSkin.arrowSide;
                }
                return null;
            }
        };
        private static final List<CssMetaData<?, ?>> CSS_META_DATA;

        private StyleableProperties() {
        }

        static {
            ArrayList<CssMetaData<TitledPane, ArrowSide>> list = new ArrayList<CssMetaData<TitledPane, ArrowSide>>(TitledPane.getClassCssMetaData().size() + 1);
            list.addAll(TitledPaneSkin.getClassCssMetaData());
            list.add(ARROW_SIDE);
            CSS_META_DATA = Collections.unmodifiableList(list);
        }
    }
}

