/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.gui.util;

import java.util.Optional;
import java.util.function.BiFunction;
import javafx.scene.Node;
import org.jabref.gui.util.ValueTableCellFactory;

public class OptionalValueTableCellFactory<S, T>
extends ValueTableCellFactory<S, Optional<T>> {
    private BiFunction<S, T, Node> toGraphicIfPresent;
    private Node defaultGraphic;

    public OptionalValueTableCellFactory<S, T> withGraphicIfPresent(BiFunction<S, T, Node> toGraphicIfPresent) {
        this.toGraphicIfPresent = toGraphicIfPresent;
        this.setToGraphic();
        return this;
    }

    public OptionalValueTableCellFactory<S, T> withDefaultGraphic(Node defaultGraphic) {
        this.defaultGraphic = defaultGraphic;
        this.setToGraphic();
        return this;
    }

    private void setToGraphic() {
        this.withGraphic((S rowItem, T item) -> {
            if (item.isPresent() && this.toGraphicIfPresent != null) {
                return this.toGraphicIfPresent.apply(rowItem, item.get());
            }
            return this.defaultGraphic;
        });
    }
}

