/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.bibtex;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.jabref.model.entry.LinkedFile;
import org.jabref.model.strings.StringUtil;

public class FileFieldWriter {
    private FileFieldWriter() {
    }

    public static String getStringRepresentation(List<LinkedFile> fields) {
        String[][] array = new String[fields.size()][];
        int i = 0;
        for (LinkedFile entry : fields) {
            array[i] = StringUtil.isNullOrEmpty(entry.getSourceUrl()) ? new String[]{entry.getDescription(), entry.getLink(), entry.getFileType()} : new String[]{entry.getDescription(), entry.getLink(), entry.getFileType(), entry.getSourceUrl()};
            ++i;
        }
        return FileFieldWriter.encodeStringArray(array);
    }

    public static String getStringRepresentation(LinkedFile field) {
        return FileFieldWriter.getStringRepresentation(Collections.singletonList(field));
    }

    public static String encodeStringArray(String[][] values) {
        return Arrays.stream(values).map(FileFieldWriter::encodeStringArray).collect(Collectors.joining(";"));
    }

    private static String encodeStringArray(String[] entry) {
        return Arrays.stream(entry).map(FileFieldWriter::quote).collect(Collectors.joining(":"));
    }

    public static String quote(String s) {
        if (s == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c == ';' || c == ':' || c == '\\') {
                sb.append('\\');
            }
            sb.append(c);
        }
        return sb.toString();
    }
}

