/*
 * Decompiled with CFR 0.152.
 */
package org.jabref.logic.citationstyle;

import de.undercouch.citeproc.LocaleProvider;
import de.undercouch.citeproc.helper.CSLUtils;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;

public class JabRefLocaleProvider
implements LocaleProvider {
    private static final String LOCALES_ROOT = "/csl-locales";
    private final Map<String, String> locales = new HashMap<String, String>();

    public String retrieveLocale(String lang) {
        return this.locales.computeIfAbsent(lang, locale -> {
            try {
                URL url = this.getClass().getResource("/csl-locales/locales-" + locale + ".xml");
                if (url == null) {
                    throw new IllegalArgumentException("Unable to load locale " + locale);
                }
                return CSLUtils.readURLToString((URL)url, (String)"UTF-8");
            }
            catch (IOException e) {
                throw new UncheckedIOException("failed to read locale " + locale, e);
            }
        });
    }
}

